/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.reflection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTAScene;
import qilin.core.reflection.ReflectionKind;
import qilin.core.reflection.ReflectionModel;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.expr.JVirtualInvokeExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.stmt.InvokableStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ArrayType;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.language.JavaJimple;

public class TamiflexModel
extends ReflectionModel {
    protected Map<ReflectionKind, Map<Stmt, Set<String>>> reflectionMap = DataFactory.createMap();

    public TamiflexModel(PTAScene ptaScene) {
        super(ptaScene);
        this.parseTamiflexLog(CoreConfig.v().getAppConfig().REFLECTION_LOG, false);
    }

    @Override
    Collection<Stmt> transformClassForName(InvokableStmt s) {
        Set<Stmt> ret = DataFactory.createSet();
        Map classForNames = this.reflectionMap.getOrDefault((Object)ReflectionKind.ClassForName, Collections.emptyMap());
        if (classForNames.containsKey(s)) {
            Collection fornames = (Collection)classForNames.get(s);
            for (String clazz : fornames) {
                ClassConstant cc = JavaJimple.getInstance().newClassConstant(TamiflexModel.dot2slashStyle(clazz));
                if (!(s instanceof JAssignStmt)) continue;
                LValue lvalue = ((JAssignStmt)s).getLeftOp();
                ret.add((Stmt)new JAssignStmt(lvalue, (Value)cc, StmtPositionInfo.getNoStmtPositionInfo()));
            }
        }
        return ret;
    }

    public static String dot2slashStyle(String clazz) {
        String x = clazz.replace('.', '/');
        return "L" + x + ";";
    }

    @Override
    protected Collection<Stmt> transformClassNewInstance(InvokableStmt s) {
        if (!(s instanceof JAssignStmt)) {
            return Collections.emptySet();
        }
        LValue lvalue = ((JAssignStmt)s).getLeftOp();
        Set<Stmt> ret = DataFactory.createSet();
        Map classNewInstances = this.reflectionMap.getOrDefault((Object)ReflectionKind.ClassNewInstance, Collections.emptyMap());
        if (classNewInstances.containsKey(s)) {
            Collection classNames = (Collection)classNewInstances.get(s);
            for (String clsName : classNames) {
                MethodSubSignature initSubSig;
                SootClass cls = this.ptaScene.getSootClass(clsName);
                Optional omthd = cls.getMethod(initSubSig = JavaIdentifierFactory.getInstance().parseMethodSubSignature("void <init>()"));
                if (!omthd.isPresent()) continue;
                JNewExpr newExpr = new JNewExpr(cls.getType());
                ret.add((Stmt)new JAssignStmt(lvalue, (Value)newExpr, StmtPositionInfo.getNoStmtPositionInfo()));
                SootMethod constructor = (SootMethod)omthd.get();
                ret.add((Stmt)new JInvokeStmt((AbstractInvokeExpr)new JSpecialInvokeExpr((Local)lvalue, (MethodSignature)constructor.getSignature(), Collections.emptyList()), StmtPositionInfo.getNoStmtPositionInfo()));
            }
        }
        return ret;
    }

    @Override
    protected Collection<Stmt> transformConstructorNewInstance(InvokableStmt s) {
        if (!(s instanceof JAssignStmt)) {
            return Collections.emptySet();
        }
        LValue lvalue = ((JAssignStmt)s).getLeftOp();
        Set<Stmt> ret = DataFactory.createSet();
        Map constructorNewInstances = this.reflectionMap.getOrDefault((Object)ReflectionKind.ConstructorNewInstance, Collections.emptyMap());
        if (constructorNewInstances.containsKey(s)) {
            Collection constructorSignatures = (Collection)constructorNewInstances.get(s);
            AbstractInvokeExpr iie = (AbstractInvokeExpr)s.asInvokableStmt().getInvokeExpr().get();
            Immediate args = iie.getArg(0);
            JArrayRef arrayRef = JavaJimple.getInstance().newArrayRef((Local)args, (Immediate)IntConstant.getInstance((int)0));
            Local arg = Jimple.newLocal((String)("intermediate/" + arrayRef), (Type)PTAUtils.getClassType("java.lang.Object"));
            ret.add((Stmt)new JAssignStmt((LValue)arg, (Value)arrayRef, StmtPositionInfo.getNoStmtPositionInfo()));
            for (String constructorSignature : constructorSignatures) {
                SootMethod constructor = this.ptaScene.getMethod(constructorSignature);
                JNewExpr newExpr = new JNewExpr(constructor.getDeclaringClassType());
                ret.add((Stmt)new JAssignStmt(lvalue, (Value)newExpr, StmtPositionInfo.getNoStmtPositionInfo()));
                int argCount = constructor.getParameterCount();
                ArrayList<Local> mArgs = new ArrayList<Local>(argCount);
                for (int i = 0; i < argCount; ++i) {
                    mArgs.add(arg);
                }
                ret.add((Stmt)new JInvokeStmt((AbstractInvokeExpr)new JSpecialInvokeExpr((Local)lvalue, (MethodSignature)constructor.getSignature(), mArgs), StmtPositionInfo.getNoStmtPositionInfo()));
            }
        }
        return ret;
    }

    @Override
    protected Collection<Stmt> transformMethodInvoke(InvokableStmt s) {
        Set<Stmt> ret = DataFactory.createSet();
        Map methodInvokes = this.reflectionMap.getOrDefault((Object)ReflectionKind.MethodInvoke, Collections.emptyMap());
        if (methodInvokes.containsKey(s)) {
            Collection methodSignatures = (Collection)methodInvokes.get(s);
            AbstractInvokeExpr iie = (AbstractInvokeExpr)s.getInvokeExpr().get();
            Immediate base = iie.getArg(0);
            Immediate args = iie.getArg(1);
            Local arg = null;
            if (args.getType() instanceof ArrayType) {
                JArrayRef arrayRef = JavaJimple.getInstance().newArrayRef((Local)args, (Immediate)IntConstant.getInstance((int)0));
                arg = Jimple.newLocal((String)("intermediate/" + arrayRef), (Type)PTAUtils.getClassType("java.lang.Object"));
                ret.add((Stmt)new JAssignStmt((LValue)arg, (Value)arrayRef, StmtPositionInfo.getNoStmtPositionInfo()));
            }
            for (String methodSignature : methodSignatures) {
                JStaticInvokeExpr ie;
                SootMethod method = this.ptaScene.getMethod(methodSignature);
                int argCount = method.getParameterCount();
                ArrayList<Object> mArgs = new ArrayList<Object>(argCount);
                for (int i = 0; i < argCount; ++i) {
                    if (arg != null) {
                        mArgs.add(arg);
                        continue;
                    }
                    mArgs.add(NullConstant.getInstance());
                }
                if (method.isStatic()) {
                    assert (base instanceof NullConstant);
                    ie = new JStaticInvokeExpr((MethodSignature)method.getSignature(), mArgs);
                } else {
                    assert (!(base instanceof NullConstant));
                    ie = new JVirtualInvokeExpr((Local)base, (MethodSignature)method.getSignature(), mArgs);
                }
                if (s instanceof JAssignStmt) {
                    LValue lvalue = ((JAssignStmt)s).getLeftOp();
                    ret.add((Stmt)new JAssignStmt(lvalue, (Value)ie, StmtPositionInfo.getNoStmtPositionInfo()));
                    continue;
                }
                ret.add((Stmt)new JInvokeStmt((AbstractInvokeExpr)ie, StmtPositionInfo.getNoStmtPositionInfo()));
            }
        }
        return ret;
    }

    @Override
    protected Collection<Stmt> transformFieldSet(InvokableStmt s) {
        Set<Stmt> ret = DataFactory.createSet();
        Map fieldSets = this.reflectionMap.getOrDefault((Object)ReflectionKind.FieldSet, Collections.emptyMap());
        if (fieldSets.containsKey(s)) {
            Collection fieldSignatures = (Collection)fieldSets.get(s);
            AbstractInvokeExpr iie = (AbstractInvokeExpr)s.getInvokeExpr().get();
            Immediate base = iie.getArg(0);
            Immediate rValue = iie.getArg(1);
            for (String fieldSignature : fieldSignatures) {
                JStaticFieldRef fieldRef;
                FieldSignature fieldSig = JavaIdentifierFactory.getInstance().parseFieldSignature(fieldSignature);
                SootField field = (SootField)this.ptaScene.getView().getField(fieldSig).get();
                if (field.isStatic()) {
                    assert (base instanceof NullConstant);
                    fieldRef = Jimple.newStaticFieldRef((FieldSignature)((FieldSignature)field.getSignature()));
                } else {
                    assert (!(base instanceof NullConstant));
                    fieldRef = Jimple.newInstanceFieldRef((Local)((Local)base), (FieldSignature)((FieldSignature)field.getSignature()));
                }
                JAssignStmt stmt = new JAssignStmt((LValue)fieldRef, (Value)rValue, StmtPositionInfo.getNoStmtPositionInfo());
                ret.add((Stmt)stmt);
            }
        }
        return ret;
    }

    @Override
    protected Collection<Stmt> transformFieldGet(InvokableStmt s) {
        Set<Stmt> ret = DataFactory.createSet();
        Map fieldGets = this.reflectionMap.getOrDefault((Object)ReflectionKind.FieldGet, Collections.emptyMap());
        if (fieldGets.containsKey(s) && s instanceof JAssignStmt) {
            Collection fieldSignatures = (Collection)fieldGets.get(s);
            LValue lvalue = ((JAssignStmt)s).getLeftOp();
            AbstractInvokeExpr iie = (AbstractInvokeExpr)s.getInvokeExpr().get();
            Immediate base = iie.getArg(0);
            for (String fieldSignature : fieldSignatures) {
                JStaticFieldRef fieldRef;
                FieldSignature fieldSig = JavaIdentifierFactory.getInstance().parseFieldSignature(fieldSignature);
                SootField field = (SootField)this.ptaScene.getView().getField(fieldSig).get();
                if (field.isStatic()) {
                    assert (base instanceof NullConstant);
                    fieldRef = Jimple.newStaticFieldRef((FieldSignature)((FieldSignature)field.getSignature()));
                } else {
                    assert (!(base instanceof NullConstant));
                    fieldRef = Jimple.newInstanceFieldRef((Local)((Local)base), (FieldSignature)((FieldSignature)field.getSignature()));
                }
                if (!(fieldRef.getType() instanceof ReferenceType)) continue;
                JAssignStmt stmt = new JAssignStmt(lvalue, (Value)fieldRef, StmtPositionInfo.getNoStmtPositionInfo());
                ret.add((Stmt)stmt);
            }
        }
        return ret;
    }

    @Override
    protected Collection<Stmt> transformArrayNewInstance(InvokableStmt s) {
        Set<Stmt> ret = DataFactory.createSet();
        Map mappedToArrayTypes = this.reflectionMap.getOrDefault((Object)ReflectionKind.ArrayNewInstance, Collections.emptyMap());
        Collection arrayTypes = mappedToArrayTypes.getOrDefault(s, Collections.emptySet());
        for (String arrayType : arrayTypes) {
            ArrayType at = (ArrayType)JavaIdentifierFactory.getInstance().getType(arrayType);
            JNewArrayExpr newExpr = JavaJimple.getInstance().newNewArrayExpr(at.getElementType(), (Immediate)IntConstant.getInstance((int)1));
            if (!(s instanceof JAssignStmt)) continue;
            LValue lvalue = ((JAssignStmt)s).getLeftOp();
            ret.add((Stmt)new JAssignStmt(lvalue, (Value)newExpr, StmtPositionInfo.getNoStmtPositionInfo()));
        }
        return ret;
    }

    @Override
    Collection<Stmt> transformArrayGet(InvokableStmt s) {
        Set<Stmt> ret = DataFactory.createSet();
        AbstractInvokeExpr iie = (AbstractInvokeExpr)s.getInvokeExpr().get();
        Immediate base = iie.getArg(0);
        if (s instanceof JAssignStmt) {
            LValue lvalue = ((JAssignStmt)s).getLeftOp();
            JArrayRef arrayRef = null;
            if (base.getType() instanceof ArrayType) {
                arrayRef = JavaJimple.getInstance().newArrayRef((Local)base, (Immediate)IntConstant.getInstance((int)0));
            } else if (base.getType() == PTAUtils.getClassType("java.lang.Object")) {
                Local local = Jimple.newLocal((String)("intermediate/" + base), (Type)new ArrayType((Type)PTAUtils.getClassType("java.lang.Object"), 1));
                ret.add((Stmt)new JAssignStmt((LValue)local, (Value)base, StmtPositionInfo.getNoStmtPositionInfo()));
                arrayRef = JavaJimple.getInstance().newArrayRef(local, (Immediate)IntConstant.getInstance((int)0));
            }
            if (arrayRef != null) {
                ret.add((Stmt)new JAssignStmt(lvalue, (Value)arrayRef, StmtPositionInfo.getNoStmtPositionInfo()));
            }
        }
        return ret;
    }

    @Override
    Collection<Stmt> transformArraySet(InvokableStmt s) {
        Set<Stmt> ret = DataFactory.createSet();
        AbstractInvokeExpr iie = (AbstractInvokeExpr)s.getInvokeExpr().get();
        Immediate base = iie.getArg(0);
        if (base.getType() instanceof ArrayType) {
            Immediate from = iie.getArg(2);
            JArrayRef arrayRef = JavaJimple.getInstance().newArrayRef((Local)base, (Immediate)IntConstant.getInstance((int)0));
            ret.add((Stmt)new JAssignStmt((LValue)arrayRef, (Value)from, StmtPositionInfo.getNoStmtPositionInfo()));
        }
        return ret;
    }

    private void parseTamiflexLog(String logFile, boolean verbose) {
        try (InputStream fis = Files.newInputStream(Paths.get(logFile, new String[0]), new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(fis);
             BufferedReader reader = new BufferedReader(isr);){
            String line;
            block24: while ((line = reader.readLine()) != null) {
                int lineNumber;
                String[] portions = line.split(";", -1);
                if (portions.length < 4) {
                    if (!verbose) continue;
                    System.out.println("Warning: illegal tamiflex log: " + line);
                    continue;
                }
                ReflectionKind kind = ReflectionKind.parse(portions[0]);
                String mappedTarget = portions[1];
                String inClzDotMthdStr = portions[2];
                int n = lineNumber = portions[3].length() == 0 ? -1 : Integer.parseInt(portions[3]);
                if (kind == null) {
                    if (!verbose) continue;
                    System.out.println("Warning: illegal tamiflex reflection kind: " + portions[0]);
                    continue;
                }
                switch (kind) {
                    case ClassForName: {
                        break;
                    }
                    case ClassNewInstance: {
                        if (this.ptaScene.containsClass(mappedTarget)) break;
                        if (!verbose) continue block24;
                        System.out.println("Warning: Unknown mapped class for signature: " + mappedTarget);
                        continue block24;
                    }
                    case ConstructorNewInstance: 
                    case MethodInvoke: {
                        if (this.ptaScene.containsMethod(mappedTarget)) break;
                        if (!verbose) continue block24;
                        System.out.println("Warning: Unknown mapped method for signature: " + mappedTarget);
                        continue block24;
                    }
                    case FieldSet: 
                    case FieldGet: {
                        if (this.ptaScene.containsField(mappedTarget)) break;
                        if (!verbose) continue block24;
                        System.out.println("Warning: Unknown mapped field for signature: " + mappedTarget);
                        continue block24;
                    }
                    case ArrayNewInstance: {
                        break;
                    }
                    default: {
                        if (!verbose) break;
                        System.out.println("Warning: Unsupported reflection kind: " + (Object)((Object)kind));
                    }
                }
                Collection<Stmt> possibleSourceStmts = this.inferSourceStmt(inClzDotMthdStr, kind, lineNumber);
                for (Stmt stmt : possibleSourceStmts) {
                    this.reflectionMap.computeIfAbsent(kind, m -> DataFactory.createMap()).computeIfAbsent(stmt, k -> DataFactory.createSet()).add(mappedTarget);
                }
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<SootMethod> inferSourceMethod(String inClzDotMthd) {
        String inClassStr = inClzDotMthd.substring(0, inClzDotMthd.lastIndexOf("."));
        String inMethodStr = inClzDotMthd.substring(inClzDotMthd.lastIndexOf(".") + 1);
        if (!this.ptaScene.containsClass(inClassStr)) {
            System.out.println("Warning: unknown class \"" + inClassStr + "\" is referenced.");
            return Collections.emptySet();
        }
        SootClass sootClass = this.ptaScene.getSootClass(inClassStr);
        Set<SootMethod> ret = DataFactory.createSet();
        Set declMethods = sootClass.getMethods();
        for (SootMethod m : declMethods) {
            if (!m.isConcrete() || !m.getName().equals(inMethodStr)) continue;
            ret.add(m);
        }
        return ret;
    }

    private Collection<Stmt> inferSourceStmt(String inClzDotMthd, ReflectionKind kind, int lineNumber) {
        Set<Stmt> ret = DataFactory.createSet();
        Set<Stmt> potential = DataFactory.createSet();
        Collection<SootMethod> sourceMethods = this.inferSourceMethod(inClzDotMthd);
        for (SootMethod sm : sourceMethods) {
            Body body = PTAUtils.getMethodBody(sm);
            for (Stmt stmt : body.getStmts()) {
                String methodSig;
                if (!stmt.isInvokableStmt() || !stmt.asInvokableStmt().containsInvokeExpr() || !this.matchReflectionKind(kind, methodSig = ((AbstractInvokeExpr)stmt.asInvokableStmt().getInvokeExpr().get()).getMethodSignature().toString())) continue;
                potential.add(stmt);
            }
        }
        for (Stmt stmt : potential) {
            int firstLine = stmt.getPositionInfo().getStmtPosition().getFirstLine();
            int lastLine = stmt.getPositionInfo().getStmtPosition().getLastLine();
            if (lineNumber >= 0 && (firstLine > lineNumber || lineNumber > lastLine)) continue;
            ret.add(stmt);
        }
        if (ret.size() == 0 && potential.size() > 0) {
            System.out.print("Warning: Mismatch between statement and reflection log entry - ");
            System.out.println((Object)((Object)kind) + ";" + inClzDotMthd + ";" + lineNumber + ";");
            return potential;
        }
        return ret;
    }

    private boolean matchReflectionKind(ReflectionKind kind, String methodSig) {
        switch (kind) {
            case ClassForName: {
                return methodSig.equals("<java.lang.Class: java.lang.Class forName(java.lang.String)>") || methodSig.equals("<java.lang.Class: java.lang.Class forName(java.lang.String,boolean,java.lang.ClassLoader)>");
            }
            case ClassNewInstance: {
                return methodSig.equals("<java.lang.Class: java.lang.Object newInstance()>");
            }
            case ConstructorNewInstance: {
                return methodSig.equals("<java.lang.reflect.Constructor: java.lang.Object newInstance(java.lang.Object[])>");
            }
            case MethodInvoke: {
                return methodSig.equals("<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>");
            }
            case FieldSet: {
                return methodSig.equals("<java.lang.reflect.Field: void set(java.lang.Object,java.lang.Object)>");
            }
            case FieldGet: {
                return methodSig.equals("<java.lang.reflect.Field: java.lang.Object get(java.lang.Object)>");
            }
            case ArrayNewInstance: {
                return methodSig.equals("<java.lang.reflect.Array: java.lang.Object newInstance(java.lang.Class,int)>");
            }
        }
        return false;
    }
}

