/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.context;

import java.util.Arrays;
import qilin.core.context.Context;
import qilin.core.context.ContextElement;

public class ContextElements
implements Context {
    private final ContextElement[] array;
    private final int size;
    private int hashCode = 0;

    public ContextElements(ContextElement[] array, int s) {
        this.array = array;
        this.size = s;
    }

    public ContextElement[] getElements() {
        return this.array;
    }

    public ContextElement get(int i) {
        return this.array[i];
    }

    public boolean contains(ContextElement heap) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != heap) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.array);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextElements other = (ContextElements)obj;
        if (this.array == null || other.array == null) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            ContextElement o1 = this.array[i];
            ContextElement o2 = other.array[i];
            if (o1 != null ? ((Object)o1).equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder localStringBuilder = new StringBuilder();
        localStringBuilder.append('[');
        for (int i = 0; i < this.array.length; ++i) {
            localStringBuilder.append(this.array[i]);
            if (i >= this.array.length - 1) continue;
            localStringBuilder.append(", ");
        }
        localStringBuilder.append(']');
        return localStringBuilder.toString();
    }

    public static ContextElements newContext(ContextElements c, ContextElement ce, int depth) {
        ContextElement[] array;
        if (c.size() < depth) {
            array = new ContextElement[c.size() + 1];
            System.arraycopy(c.getElements(), 0, array, 1, c.size());
        } else {
            array = new ContextElement[depth];
            System.arraycopy(c.getElements(), 0, array, 1, depth - 1);
        }
        array[0] = ce;
        return new ContextElements(array, array.length);
    }
}

