/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.core.VirtualCalls;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.builder.callgraph.Edge;
import qilin.core.builder.callgraph.Kind;
import qilin.core.builder.callgraph.OnFlyCallGraph;
import qilin.core.context.Context;
import qilin.core.pag.AllocNode;
import qilin.core.pag.CallSite;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.core.pag.VirtualCallSite;
import qilin.core.sets.P2SetVisitor;
import qilin.core.sets.PointsToSetInternal;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import qilin.util.queue.ChunkedQueue;
import qilin.util.queue.QueueReader;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.stmt.InvokableStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ClassType;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;

public class CallGraphBuilder {
    private static final ClassType clRunnable = PTAUtils.getClassType("java.lang.Runnable");
    protected final Map<VarNode, Collection<VirtualCallSite>> receiverToSites;
    protected final Map<SootMethod, Map<Object, InvokableStmt>> methodToInvokeStmt;
    protected final Set<ContextMethod> reachMethods;
    private ChunkedQueue<ContextMethod> rmQueue;
    protected final Set<Edge> calledges;
    protected final PTA pta;
    protected final PAG pag;
    protected final PTAScene ptaScene;
    protected final VirtualCalls virtualCalls;
    protected OnFlyCallGraph cicg;

    public CallGraphBuilder(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
        this.ptaScene = pta.getScene();
        this.ptaScene.setCallGraph(new OnFlyCallGraph());
        this.virtualCalls = new VirtualCalls(this.ptaScene.getView());
        this.receiverToSites = DataFactory.createMap((int)this.ptaScene.getView().getClasses().count());
        this.methodToInvokeStmt = DataFactory.createMap();
        this.reachMethods = DataFactory.createSet();
        this.calledges = DataFactory.createSet();
    }

    public void setRMQueue(ChunkedQueue<ContextMethod> rmQueue) {
        this.rmQueue = rmQueue;
    }

    public Collection<ContextMethod> getReachableMethods() {
        return this.reachMethods;
    }

    public Map<VarNode, Collection<VirtualCallSite>> getReceiverToSitesMap() {
        return this.receiverToSites;
    }

    public Collection<VirtualCallSite> callSitesLookUp(VarNode receiver) {
        return this.receiverToSites.getOrDefault(receiver, Collections.emptySet());
    }

    public SootMethod resolveNonSpecial(ClassType t, MethodSubSignature subSig) {
        return this.virtualCalls.resolveNonSpecial(t, subSig);
    }

    public OnFlyCallGraph getCallGraph() {
        if (this.cicg == null) {
            this.constructCallGraph();
        }
        return this.ptaScene.getCallGraph();
    }

    public OnFlyCallGraph getCICallGraph() {
        if (this.cicg == null) {
            this.constructCallGraph();
        }
        return this.cicg;
    }

    private void constructCallGraph() {
        this.cicg = new OnFlyCallGraph();
        Map map = DataFactory.createMap();
        this.calledges.forEach(e -> {
            this.ptaScene.getCallGraph().addEdge((Edge)e);
            SootMethod src = e.src();
            SootMethod tgt = e.tgt();
            InvokableStmt unit = e.srcUnit();
            Map submap = map.computeIfAbsent(unit, k -> DataFactory.createMap());
            Set set = submap.computeIfAbsent(src, k -> DataFactory.createSet());
            if (set.add(tgt)) {
                this.cicg.addEdge(new Edge(new ContextMethod(src, this.pta.emptyContext()), e.srcUnit(), new ContextMethod(tgt, this.pta.emptyContext()), e.kind()));
            }
        });
    }

    public List<ContextMethod> getEntryPoints() {
        Node thisRef = this.pag.getMethodPAG(this.ptaScene.getFakeMainMethod()).nodeFactory().caseThis();
        thisRef = this.pta.parameterize(thisRef, this.pta.emptyContext());
        this.pag.addEdge(this.pta.getRootNode(), thisRef);
        return Collections.singletonList(this.pta.parameterize(this.ptaScene.getFakeMainMethod(), this.pta.emptyContext()));
    }

    public void initReachableMethods() {
        for (ContextMethod momc : this.getEntryPoints()) {
            if (!this.reachMethods.add(momc)) continue;
            this.rmQueue.add(momc);
        }
    }

    public VarNode getReceiverVarNode(Local receiver, ContextMethod m) {
        if (receiver.getType() == UnknownType.getInstance()) {
            System.out.println("why unknown??" + m.method() + ";;" + receiver);
            throw new RuntimeException();
        }
        LocalVarNode base = this.pag.makeLocalVarNode(receiver, receiver.getType(), m.method());
        return (VarNode)this.pta.parameterize(base, m.context());
    }

    protected void dispatch(AllocNode receiverNode, VirtualCallSite site) {
        Type type = receiverNode.getType();
        QueueReader<SootMethod> targets = this.dispatch(type, site);
        while (targets.hasNext()) {
            SootMethod target = targets.next();
            if (site.iie() instanceof JSpecialInvokeExpr) {
                ClassType calleeDeclType = target.getDeclaringClassType();
                if (!PTAUtils.canStoreType(this.pta.getView(), type, (Type)calleeDeclType)) continue;
            }
            this.addVirtualEdge(site.container(), site.getUnit(), target, site.kind(), receiverNode);
        }
    }

    private void addVirtualEdge(ContextMethod caller, InvokableStmt callStmt, SootMethod callee, Kind kind, AllocNode receiverNode) {
        Context tgtContext = this.pta.createCalleeCtx(caller, receiverNode, new CallSite(callStmt), callee);
        ContextMethod cstarget = this.pta.parameterize(callee, tgtContext);
        this.handleCallEdge(new Edge(caller, callStmt, cstarget, kind));
        Node thisRef = this.pag.getMethodPAG(callee).nodeFactory().caseThis();
        thisRef = this.pta.parameterize(thisRef, cstarget.context());
        this.pag.addEdge(receiverNode, thisRef);
    }

    public void injectCallEdge(Object heapOrType, ContextMethod callee, Kind kind) {
        Map stmtMap = this.methodToInvokeStmt.computeIfAbsent(callee.method(), k -> DataFactory.createMap());
        if (!stmtMap.containsKey(heapOrType)) {
            JStaticInvokeExpr ie = new JStaticInvokeExpr((MethodSignature)callee.method().getSignature(), Collections.emptyList());
            JInvokeStmt stmt = new JInvokeStmt((AbstractInvokeExpr)ie, StmtPositionInfo.getNoStmtPositionInfo());
            stmtMap.put(heapOrType, stmt);
            this.handleCallEdge(new Edge(this.pta.parameterize(this.ptaScene.getFakeMainMethod(), this.pta.emptyContext()), (InvokableStmt)stmtMap.get(heapOrType), callee, kind));
        }
    }

    public void addStaticEdge(ContextMethod caller, InvokableStmt callStmt, SootMethod calleem, Kind kind) {
        Context typeContext = this.pta.createCalleeCtx(caller, null, new CallSite(callStmt), calleem);
        ContextMethod callee = this.pta.parameterize(calleem, typeContext);
        this.handleCallEdge(new Edge(caller, callStmt, callee, kind));
    }

    protected void handleCallEdge(Edge edge) {
        if (this.calledges.add(edge)) {
            ContextMethod callee = edge.getTgt();
            if (this.reachMethods.add(callee)) {
                this.rmQueue.add(callee);
            }
            this.processCallAssign(edge);
        }
    }

    public boolean recordVirtualCallSite(VarNode receiver, VirtualCallSite site) {
        Collection sites = this.receiverToSites.computeIfAbsent(receiver, k -> DataFactory.createSet());
        return sites.add(site);
    }

    public void virtualCallDispatch(PointsToSetInternal p2set, final VirtualCallSite site) {
        p2set.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                CallGraphBuilder.this.dispatch((AllocNode)n, site);
            }
        });
    }

    private void processCallAssign(Edge e) {
        LValue dest;
        MethodPAG srcmpag = this.pag.getMethodPAG(e.src());
        MethodPAG tgtmpag = this.pag.getMethodPAG(e.tgt());
        InvokableStmt s = e.srcUnit();
        Context srcContext = e.srcCtxt();
        Context tgtContext = e.tgtCtxt();
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
        SootMethod tgtmtd = tgtmpag.getMethod();
        AbstractInvokeExpr ie = (AbstractInvokeExpr)s.asInvokableStmt().getInvokeExpr().get();
        int numArgs = ie.getArgCount();
        for (int i = 0; i < numArgs; ++i) {
            Type tgtType;
            Immediate arg = ie.getArg(i);
            if (!(arg.getType() instanceof ReferenceType) || arg instanceof NullConstant || !((tgtType = tgtmtd.getParameterType(i)) instanceof ReferenceType)) continue;
            Node argNode = srcnf.getNode((Value)arg);
            argNode = this.pta.parameterize(argNode, srcContext);
            Node parm = tgtnf.caseParm(i);
            parm = this.pta.parameterize(parm, tgtContext);
            this.pag.addEdge(argNode, parm);
        }
        if (s instanceof JAssignStmt && (dest = ((JAssignStmt)s).getLeftOp()).getType() instanceof ReferenceType) {
            Node destNode = srcnf.getNode((Value)dest);
            destNode = this.pta.parameterize(destNode, srcContext);
            if (tgtmtd.getReturnType() instanceof ReferenceType) {
                Node retNode = tgtnf.caseRet();
                retNode = this.pta.parameterize(retNode, tgtContext);
                this.pag.addEdge(retNode, destNode);
            }
        }
        if (CoreConfig.v().getPtaConfig().preciseExceptions) {
            Node throwNode = tgtnf.caseMethodThrow();
            throwNode = this.pta.parameterize(throwNode, tgtContext);
            MethodNodeFactory mnf = srcmpag.nodeFactory();
            Node dst = mnf.makeInvokeStmtThrowVarNode((Stmt)s, srcmpag.getMethod());
            dst = this.pta.parameterize(dst, srcContext);
            this.pag.addEdge(throwNode, dst);
        }
    }

    public QueueReader<SootMethod> dispatch(Type type, VirtualCallSite site) {
        ChunkedQueue<SootMethod> targetsQueue = new ChunkedQueue<SootMethod>();
        QueueReader<SootMethod> targets = targetsQueue.reader();
        if (site.kind() == Kind.THREAD && !PTAUtils.canStoreType(this.ptaScene.getView(), type, (Type)clRunnable)) {
            return targets;
        }
        ContextMethod container = site.container();
        if (site.iie() instanceof JSpecialInvokeExpr && site.kind() != Kind.THREAD) {
            SootMethod target = this.virtualCalls.resolveSpecial((JSpecialInvokeExpr)site.iie(), site.subSig(), container.method());
            if (target != null) {
                targetsQueue.add(target);
            }
        } else {
            Type mType = site.recNode().getType();
            this.virtualCalls.resolve(type, mType, site.subSig(), container.method(), targetsQueue);
        }
        return targets;
    }
}

