/*
 * Decompiled with CFR 0.152.
 */
package sootup.jimple.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import sootup.core.IdentifierFactory;
import sootup.core.cache.ClassCache;
import sootup.core.cache.provider.ClassCacheProvider;
import sootup.core.cache.provider.FullCacheProvider;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.frontend.ResolveException;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SootClass;
import sootup.core.model.SourceType;
import sootup.core.types.ClassType;
import sootup.core.views.AbstractView;
import sootup.core.views.View;
import sootup.jimple.parser.JimpleLanguage;

public class JimpleView
extends AbstractView {
    @Nonnull
    protected final List<AnalysisInputLocation> inputLocations;
    @Nonnull
    private final ClassCache cache;
    @Nonnull
    protected final SourceType sourceType;
    private volatile boolean isFullyResolved = false;

    public JimpleView(@Nonnull AnalysisInputLocation inputLocation) {
        this(Collections.singletonList(inputLocation));
    }

    public JimpleView(@Nonnull List<AnalysisInputLocation> inputLocations) {
        this(inputLocations, (ClassCacheProvider)new FullCacheProvider(), SourceType.Application);
    }

    public JimpleView(@Nonnull List<AnalysisInputLocation> inputLocations, @Nonnull ClassCacheProvider cacheProvider, SourceType sourceType) {
        this.inputLocations = inputLocations;
        this.cache = cacheProvider.createCache();
        this.sourceType = sourceType;
    }

    @Nonnull
    public synchronized Collection<SootClass> getClasses() {
        return this.getAbstractClassSources();
    }

    @Nonnull
    synchronized Collection<SootClass> getAbstractClassSources() {
        this.resolveAll();
        return this.cache.getClasses();
    }

    @Nonnull
    public synchronized Optional<SootClass> getClass(@Nonnull ClassType type) {
        return this.getAbstractClass(type);
    }

    @Nonnull
    public IdentifierFactory getIdentifierFactory() {
        return new JimpleLanguage().getIdentifierFactory();
    }

    @Nonnull
    Optional<SootClass> getAbstractClass(@Nonnull ClassType type) {
        SootClass cachedClass = this.cache.getClass(type);
        if (cachedClass != null) {
            return Optional.of(cachedClass);
        }
        List foundClassSources = this.inputLocations.stream().map(location -> location.getClassSource(type, (View)this)).filter(Optional::isPresent).limit(2L).map(Optional::get).collect(Collectors.toList());
        if (foundClassSources.size() < 1) {
            return Optional.empty();
        }
        if (foundClassSources.size() > 1) {
            throw new ResolveException("Multiple class candidates for \"" + type + "\" found in the given AnalysisInputLocations. Soot can't decide which AnalysisInputLocation it should refer to for this Type.\nThe candidates are " + foundClassSources.stream().map(cs -> cs.getSourcePath().toString()).collect(Collectors.joining(",")), ((SootClassSource)foundClassSources.get(0)).getSourcePath());
        }
        return this.buildClassFrom((AbstractClassSource)foundClassSources.get(0));
    }

    @Nonnull
    private synchronized Optional<SootClass> buildClassFrom(AbstractClassSource classSource) {
        SootClass theClass;
        ClassType classType = classSource.getClassType();
        if (!this.cache.hasClass(classType)) {
            theClass = classSource.buildClass(this.sourceType);
            this.cache.putClass(classType, theClass);
        } else {
            theClass = this.cache.getClass(classType);
        }
        return Optional.of(theClass);
    }

    private synchronized void resolveAll() {
        if (this.isFullyResolved) {
            return;
        }
        this.inputLocations.stream().flatMap(location -> location.getClassSources((View)this).stream()).forEach(this::buildClassFrom);
        this.isFullyResolved = true;
    }
}

