/*
 * Decompiled with CFR 0.152.
 */
package sootup.jimple.parser;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.ResolveException;
import sootup.core.jimple.Jimple;
import sootup.core.model.FullPosition;
import sootup.core.model.Position;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.signatures.PackageName;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.java.core.JavaIdentifierFactory;
import sootup.jimple.JimpleLexer;
import sootup.jimple.JimpleParser;

public class JimpleConverterUtil {
    private final IdentifierFactory identifierFactory = JavaIdentifierFactory.getInstance();
    private final Map<String, PackageName> imports = new HashMap<String, PackageName>();
    @Nonnull
    private final Path fileUri;

    public JimpleConverterUtil(@Nonnull Path file) {
        this.fileUri = file;
    }

    public IdentifierFactory getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Type getType(String typename) {
        PackageName packageName = this.imports.get(typename = Jimple.unescape((String)typename));
        return packageName == null ? this.identifierFactory.getType(typename) : this.identifierFactory.getType(packageName.getName() + "." + typename);
    }

    public ClassType getClassType(String typename) {
        PackageName packageName = this.imports.get(typename = Jimple.unescape((String)typename));
        return packageName == null ? this.identifierFactory.getClassType(typename) : this.identifierFactory.getClassType(typename, packageName.getName());
    }

    @Nonnull
    public static Position buildPositionFromCtx(@Nonnull ParserRuleContext ctx) {
        String tokenstr = ctx.getText();
        int lineCount = -1;
        int fromIdx = 0;
        int lastLineBreakIdx = 0;
        while ((fromIdx = tokenstr.indexOf("\n", fromIdx)) != -1) {
            lastLineBreakIdx = fromIdx++;
            ++lineCount;
        }
        int endCharLength = tokenstr.length() - lastLineBreakIdx;
        return new FullPosition(ctx.start.getLine() - 1, ctx.start.getCharPositionInLine(), ctx.stop.getLine() + lineCount, ctx.stop.getCharPositionInLine() + endCharLength);
    }

    public void addImport(JimpleParser.ImportItemContext item) {
        if (item == null || item.location == null) {
            return;
        }
        ClassType classType = this.identifierFactory.getClassType(Jimple.unescape((String)item.location.getText()));
        PackageName duplicate = this.imports.putIfAbsent(classType.getClassName(), classType.getPackageName());
        if (duplicate != null && !duplicate.equals((Object)classType.getPackageName())) {
            throw new ResolveException("Multiple Imports for the same ClassName can not be resolved!", this.fileUri, JimpleConverterUtil.buildPositionFromCtx(item));
        }
    }

    @Nonnull
    public MethodSignature getMethodSignature(JimpleParser.Method_signatureContext ctx, ParserRuleContext parentCtx) {
        if (ctx == null) {
            throw new ResolveException("MethodSignature is missing.", this.fileUri, JimpleConverterUtil.buildPositionFromCtx(parentCtx));
        }
        JimpleParser.IdentifierContext class_name = ctx.class_name;
        if (class_name == null) {
            throw new ResolveException("MethodSignature is not well formed.", this.fileUri, JimpleConverterUtil.buildPositionFromCtx(ctx));
        }
        MethodSubSignature methodSubSignature = this.getMethodSubSignature(ctx.method_subsignature(), ctx);
        String classname = class_name.getText();
        return this.identifierFactory.getMethodSignature(this.getClassType(classname), methodSubSignature);
    }

    @Nonnull
    public MethodSubSignature getMethodSubSignature(JimpleParser.Method_subsignatureContext ctx, ParserRuleContext parentCtx) {
        if (ctx == null) {
            throw new ResolveException("MethodSignature is missing.", this.fileUri, JimpleConverterUtil.buildPositionFromCtx(parentCtx));
        }
        JimpleParser.TypeContext typeCtx = ctx.type();
        JimpleParser.Method_nameContext method_nameCtx = ctx.method_name();
        if (typeCtx == null || method_nameCtx == null) {
            throw new ResolveException("MethodSignature is not well formed.", this.fileUri, JimpleConverterUtil.buildPositionFromCtx(ctx));
        }
        Type type = this.getType(typeCtx.getText());
        String methodname = Jimple.unescape((String)method_nameCtx.getText());
        List<Type> params = this.getTypeList(ctx.type_list());
        return this.identifierFactory.getMethodSubSignature(methodname, type, params);
    }

    public FieldSignature getFieldSignature(JimpleParser.Field_signatureContext ctx) {
        String classname = Jimple.unescape((String)ctx.classname.getText());
        Type type = this.getType(Jimple.unescape((String)ctx.type().getText()));
        String fieldname = Jimple.unescape((String)ctx.fieldname.getText());
        return this.identifierFactory.getFieldSignature(fieldname, this.getClassType(classname), type);
    }

    public List<Type> getTypeList(JimpleParser.Type_listContext type_list) {
        if (type_list == null) {
            return Collections.emptyList();
        }
        List<JimpleParser.TypeContext> typeList = type_list.type();
        int size = typeList.size();
        if (size < 1) {
            return Collections.emptyList();
        }
        ArrayList<Type> list = new ArrayList<Type>(size);
        for (JimpleParser.TypeContext typeContext : typeList) {
            list.add(this.identifierFactory.getType(Jimple.unescape((String)typeContext.getText())));
        }
        return list;
    }

    public List<ClassType> getClassTypeList(JimpleParser.Type_listContext type_list) {
        if (type_list == null) {
            return Collections.emptyList();
        }
        List<JimpleParser.TypeContext> typeList = type_list.type();
        int size = typeList.size();
        if (size < 1) {
            return Collections.emptyList();
        }
        ArrayList<ClassType> list = new ArrayList<ClassType>(size);
        for (JimpleParser.TypeContext typeContext : typeList) {
            list.add(this.identifierFactory.getClassType(Jimple.unescape((String)typeContext.getText())));
        }
        return list;
    }

    public Set<ClassType> getClassTypeSet(JimpleParser.Type_listContext type_list) {
        if (type_list == null) {
            return Collections.emptySet();
        }
        List<JimpleParser.TypeContext> typeList = type_list.type();
        int size = typeList.size();
        if (size < 1) {
            return Collections.emptySet();
        }
        HashSet<ClassType> set = new HashSet<ClassType>(size);
        for (JimpleParser.TypeContext typeContext : typeList) {
            set.add(this.identifierFactory.getClassType(Jimple.unescape((String)typeContext.getText())));
        }
        return set;
    }

    @Nonnull
    public static JimpleParser createJimpleParser(CharStream charStream, final Path path) {
        JimpleLexer lexer = new JimpleLexer(charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new ResolveException("Jimple SyntaxError: " + msg, path, (Position)new FullPosition(line - 1, charPositionInLine, line - 1, Integer.MAX_VALUE));
            }
        });
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JimpleParser parser = new JimpleParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                FullPosition position;
                if (e != null) {
                    if (e.getCause() instanceof NoViableAltException) {
                        Token start = ((NoViableAltException)e.getCause()).getStartToken();
                        position = new FullPosition(start.getLine() - 1, start.getCharPositionInLine(), charPositionInLine - 1, Integer.MAX_VALUE);
                    } else {
                        int sizeOfBad = e.getCtx().getText().length();
                        int firstCol = Math.max(charPositionInLine - sizeOfBad, 0);
                        position = new FullPosition(line - 1, firstCol, line - 1, Integer.MAX_VALUE);
                    }
                } else {
                    position = new FullPosition(line - 1, charPositionInLine, line - 1, Integer.MAX_VALUE);
                }
                throw new ResolveException("Jimple SyntaxError: " + msg, path, (Position)position);
            }
        });
        return parser;
    }
}

