/*
 * Decompiled with CFR 0.152.
 */
package sootup.jimple.parser;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.BodySource;
import sootup.core.frontend.OverridingBodySource;
import sootup.core.frontend.OverridingClassSource;
import sootup.core.frontend.ResolveException;
import sootup.core.graph.MutableBlockStmtGraph;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.jimple.basic.SimpleStmtPositionInfo;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.BooleanConstant;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.DoubleConstant;
import sootup.core.jimple.common.constant.FloatConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.MethodHandle;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.expr.JAddExpr;
import sootup.core.jimple.common.expr.JAndExpr;
import sootup.core.jimple.common.expr.JCmpExpr;
import sootup.core.jimple.common.expr.JCmpgExpr;
import sootup.core.jimple.common.expr.JCmplExpr;
import sootup.core.jimple.common.expr.JDivExpr;
import sootup.core.jimple.common.expr.JEqExpr;
import sootup.core.jimple.common.expr.JGeExpr;
import sootup.core.jimple.common.expr.JGtExpr;
import sootup.core.jimple.common.expr.JLeExpr;
import sootup.core.jimple.common.expr.JLtExpr;
import sootup.core.jimple.common.expr.JMulExpr;
import sootup.core.jimple.common.expr.JNeExpr;
import sootup.core.jimple.common.expr.JOrExpr;
import sootup.core.jimple.common.expr.JRemExpr;
import sootup.core.jimple.common.expr.JShlExpr;
import sootup.core.jimple.common.expr.JShrExpr;
import sootup.core.jimple.common.expr.JSubExpr;
import sootup.core.jimple.common.expr.JUshrExpr;
import sootup.core.jimple.common.expr.JXorExpr;
import sootup.core.jimple.common.ref.IdentityRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.model.Body;
import sootup.core.model.ClassModifier;
import sootup.core.model.FieldModifier;
import sootup.core.model.MethodModifier;
import sootup.core.model.Position;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.SootClassMemberSignature;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;
import sootup.core.types.VoidType;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.language.JavaJimple;
import sootup.jimple.JimpleBaseVisitor;
import sootup.jimple.JimpleParser;
import sootup.jimple.parser.JimpleConverterUtil;

public class JimpleConverter {
    public OverridingClassSource run(@Nonnull CharStream charStream, @Nonnull AnalysisInputLocation inputlocation, @Nonnull Path sourcePath) {
        return this.run(charStream, inputlocation, sourcePath, Collections.emptyList());
    }

    public OverridingClassSource run(@Nonnull CharStream charStream, @Nonnull AnalysisInputLocation inputlocation, @Nonnull Path sourcePath, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        JimpleParser jimpleParser = JimpleConverterUtil.createJimpleParser(charStream, sourcePath);
        jimpleParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        return this.run(jimpleParser, inputlocation, sourcePath, bodyInterceptors);
    }

    public OverridingClassSource run(@Nonnull JimpleParser parser, @Nonnull AnalysisInputLocation inputlocation, @Nonnull Path sourcePath) {
        return this.run(parser, inputlocation, sourcePath, Collections.emptyList());
    }

    public OverridingClassSource run(@Nonnull JimpleParser parser, @Nonnull AnalysisInputLocation inputlocation, @Nonnull Path sourcePath, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        ClassVisitor classVisitor;
        try {
            classVisitor = new ClassVisitor(sourcePath);
            classVisitor.visit((ParseTree)parser.file());
        }
        catch (ParseCancellationException ex) {
            throw new ResolveException("Syntax Error", sourcePath, (Exception)((Object)ex));
        }
        return new OverridingClassSource(classVisitor.methods, classVisitor.fields, classVisitor.modifiers, classVisitor.interfaces, classVisitor.superclass, classVisitor.outerclass, classVisitor.position, sourcePath, classVisitor.clazz, inputlocation);
    }

    private static class ClassVisitor
    extends JimpleBaseVisitor<Boolean> {
        @Nonnull
        private final IdentifierFactory identifierFactory = JavaIdentifierFactory.getInstance();
        @Nonnull
        private final JimpleConverterUtil util;
        @Nonnull
        private final Path path;
        private ClassType clazz = null;
        Set<SootField> fields = new HashSet<SootField>();
        Set<SootMethod> methods = new HashSet<SootMethod>();
        ClassType superclass = null;
        Set<ClassType> interfaces = null;
        ClassType outerclass = null;
        Position position = NoPositionInformation.getInstance();
        EnumSet<ClassModifier> modifiers = null;

        public ClassVisitor(@Nonnull Path path) {
            this.path = path;
            this.util = new JimpleConverterUtil(path);
        }

        @Override
        @Nonnull
        public Boolean visitFile(@Nonnull JimpleParser.FileContext ctx) {
            String classname;
            this.position = JimpleConverterUtil.buildPositionFromCtx(ctx);
            ctx.importItem().stream().filter(item -> item.location != null).forEach(this.util::addImport);
            if (ctx.classname != null) {
                classname = ctx.classname.getText();
                int dollarPostition = classname.indexOf(36);
                if (dollarPostition > -1) {
                    this.outerclass = this.util.getClassType(classname.substring(0, dollarPostition));
                }
            } else {
                throw new ResolveException("Classname is not well formed.", this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
            }
            this.clazz = this.util.getClassType(classname);
            this.modifiers = this.getClassModifiers(ctx.class_modifier());
            if (ctx.file_type() != null) {
                if (ctx.file_type().getText().equals("interface")) {
                    this.modifiers.add(ClassModifier.INTERFACE);
                }
                if (ctx.file_type().getText().equals("annotation")) {
                    this.modifiers.add(ClassModifier.ANNOTATION);
                }
            }
            this.superclass = ctx.extends_clause() != null ? this.util.getClassType(ctx.extends_clause().classname.getText()) : null;
            this.interfaces = ctx.implements_clause() != null ? this.util.getClassTypeSet(ctx.implements_clause().type_list()) : Collections.emptySet();
            for (int i = 0; i < ctx.member().size(); ++i) {
                if (ctx.member(i).method() != null) {
                    SootMethod m = (SootMethod)new MethodVisitor().visitMember(ctx.member(i));
                    if (this.methods.stream().anyMatch(meth -> {
                        MethodSignature signature = (MethodSignature)m.getSignature();
                        return ((MethodSignature)meth.getSignature()).equals((Object)signature);
                    })) {
                        throw new ResolveException("Method with the same Signature does already exist.", this.path, m.getPosition());
                    }
                    this.methods.add(m);
                    continue;
                }
                JimpleParser.FieldContext fieldCtx = ctx.member(i).field();
                EnumSet<FieldModifier> modifier = this.getFieldModifiers(fieldCtx.field_modifier());
                Position pos = JimpleConverterUtil.buildPositionFromCtx(fieldCtx);
                String fieldName = Jimple.unescape((String)fieldCtx.identifier().getText());
                SootField f = new SootField(this.identifierFactory.getFieldSignature(fieldName, this.clazz, fieldCtx.type().getText()), modifier, pos);
                if (this.fields.stream().anyMatch(e -> e.getName().equals(fieldName))) {
                    throw new ResolveException("Field with the same name does already exist.", this.path, pos);
                }
                this.fields.add(f);
            }
            return true;
        }

        private EnumSet<ClassModifier> getClassModifiers(List<JimpleParser.Class_modifierContext> modifier) {
            return modifier.stream().map(modContext -> ClassModifier.valueOf((String)modContext.getText().toUpperCase())).collect(Collectors.toCollection(() -> EnumSet.noneOf(ClassModifier.class)));
        }

        private EnumSet<MethodModifier> getMethodModifiers(List<JimpleParser.Method_modifierContext> modifier) {
            return modifier.stream().map(modContext -> MethodModifier.valueOf((String)modContext.getText().toUpperCase())).collect(Collectors.toCollection(() -> EnumSet.noneOf(MethodModifier.class)));
        }

        private EnumSet<FieldModifier> getFieldModifiers(List<JimpleParser.Field_modifierContext> modifier) {
            return modifier.stream().map(modContext -> FieldModifier.valueOf((String)modContext.getText().toUpperCase())).collect(Collectors.toCollection(() -> EnumSet.noneOf(FieldModifier.class)));
        }

        private class MethodVisitor
        extends JimpleBaseVisitor<SootMethod> {
            private final HashMap<BranchingStmt, List<String>> unresolvedBranches = new HashMap();
            private final HashMap<String, Stmt> labeledStmts = new HashMap();
            private HashMap<String, Local> locals = new HashMap();

            private MethodVisitor() {
            }

            public Local getLocal(@Nonnull String name) {
                return this.locals.computeIfAbsent(name, ignored -> new Local(name, (Type)UnknownType.getInstance()));
            }

            @Override
            @Nonnull
            public SootMethod visitMethod(@Nonnull JimpleParser.MethodContext ctx) {
                Body build;
                EnumSet modifier = ctx.method_modifier() == null ? EnumSet.noneOf(MethodModifier.class) : ClassVisitor.this.getMethodModifiers(ctx.method_modifier());
                JimpleParser.Method_subsignatureContext method_subsignatureContext = ctx.method_subsignature();
                if (method_subsignatureContext == null) {
                    throw new ResolveException("Methodsubsignature not found.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                }
                Type type = ClassVisitor.this.util.getType(method_subsignatureContext.type().getText());
                if (type == null) {
                    throw new ResolveException("Returntype not found.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                }
                String methodname = method_subsignatureContext.method_name().getText();
                if (methodname == null) {
                    throw new ResolveException("Methodname not found.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                }
                List<Type> params = ClassVisitor.this.util.getTypeList(method_subsignatureContext.type_list());
                MethodSignature methodSignature = ClassVisitor.this.identifierFactory.getMethodSignature(ClassVisitor.this.clazz, Jimple.unescape((String)methodname), type, params);
                List exceptions = ctx.throws_clause() == null ? Collections.emptyList() : ClassVisitor.this.util.getClassTypeList(ctx.throws_clause().type_list());
                ArrayList<Trap> traps = new ArrayList<Trap>();
                ArrayList stmtList = new ArrayList();
                HashMap branchingMap = new HashMap();
                if (ctx.method_body() == null) {
                    throw new ResolveException("404 Body not found.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                }
                if (ctx.method_body().SEMICOLON() == null) {
                    List<JimpleParser.Trap_clauseContext> trap_clauseContexts;
                    this.locals = new HashMap();
                    JimpleParser.Method_body_contentsContext method_body_contentsContext = ctx.method_body().method_body_contents();
                    if (method_body_contentsContext.declarations() != null) {
                        for (JimpleParser.DeclarationContext it : method_body_contentsContext.declarations().declaration()) {
                            List<JimpleParser.ImmediateContext> immediates;
                            UnknownType localtype;
                            String typeStr = it.type().getText();
                            Object object = localtype = typeStr.equals("unknown") ? UnknownType.getInstance() : ClassVisitor.this.util.getType(typeStr);
                            if (localtype == VoidType.getInstance()) {
                                throw new ResolveException("Void is not an allowed Type for a Local.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                            }
                            if (it.arg_list() == null || (immediates = it.arg_list().immediate()) == null) continue;
                            for (JimpleParser.ImmediateContext immediate : immediates) {
                                if (immediate != null && immediate.local != null) {
                                    String localname = immediate.local.getText();
                                    this.locals.put(localname, new Local(localname, (Type)localtype));
                                    continue;
                                }
                                throw new ResolveException("Thats not a Local in the Local Declaration.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                            }
                        }
                    }
                    StmtVisitor stmtVisitor = new StmtVisitor();
                    JimpleParser.StatementsContext statements = method_body_contentsContext.statements();
                    if (statements != null && statements.statement() != null) {
                        statements.statement().forEach(stmtCtx -> stmtList.add(stmtVisitor.visitStatement((JimpleParser.StatementContext)((Object)stmtCtx))));
                    }
                    if ((trap_clauseContexts = method_body_contentsContext.trap_clauses().trap_clause()) != null) {
                        for (JimpleParser.Trap_clauseContext it : trap_clauseContexts) {
                            ClassType exceptionType = ClassVisitor.this.util.getClassType(it.exceptiontype.getText());
                            String beginLabel = it.from.getText();
                            String toLabel = it.to.getText();
                            String handlerLabel = it.with.getText();
                            traps.add(Jimple.newTrap((ClassType)exceptionType, (Stmt)this.labeledStmts.get(beginLabel), (Stmt)this.labeledStmts.get(toLabel), (Stmt)this.labeledStmts.get(handlerLabel)));
                        }
                    }
                }
                Position classPosition = JimpleConverterUtil.buildPositionFromCtx(ctx);
                for (Map.Entry<BranchingStmt, List<String>> item : this.unresolvedBranches.entrySet()) {
                    List<String> targetLabels = item.getValue();
                    ArrayList<Stmt> targets = new ArrayList<Stmt>(targetLabels.size());
                    for (String targetLabel : targetLabels) {
                        Stmt target = this.labeledStmts.get(targetLabel);
                        if (target == null) {
                            throw new ResolveException("Don't jump into the Space! The target Stmt is not found i.e. no label for: " + item.getKey() + " to " + targetLabel, ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                        }
                        targets.add(target);
                    }
                    branchingMap.put(item.getKey(), targets);
                }
                Position methodPosition = JimpleConverterUtil.buildPositionFromCtx(ctx);
                try {
                    MutableBlockStmtGraph graph = new MutableBlockStmtGraph();
                    graph.initializeWith(stmtList, branchingMap, traps);
                    Body.BodyBuilder builder = Body.builder((MutableStmtGraph)graph);
                    builder.setModifiers((Set)modifier);
                    builder.setMethodSignature(methodSignature);
                    builder.setLocals(new HashSet<Local>(this.locals.values()));
                    builder.setPosition(classPosition);
                    build = builder.build();
                }
                catch (Exception e) {
                    throw new ResolveException(methodname + " " + e.getMessage(), ClassVisitor.this.path, methodPosition, e);
                }
                OverridingBodySource oms = new OverridingBodySource(methodSignature, build);
                return new SootMethod((BodySource)oms, methodSignature, (Iterable)modifier, exceptions, methodPosition);
            }

            private class ValueVisitor
            extends JimpleBaseVisitor<Value> {
                private ValueVisitor() {
                }

                @Override
                public Value visitValue(JimpleParser.ValueContext ctx) {
                    if (ctx.NEW() != null && ctx.base_type != null) {
                        Type type = ClassVisitor.this.util.getType(ctx.base_type.getText());
                        if (!(type instanceof ReferenceType)) {
                            throw new ResolveException(type + " is not a ReferenceType.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                        }
                        return Jimple.newNewExpr((ClassType)((ClassType)type));
                    }
                    if (ctx.NEWARRAY() != null) {
                        Type type = ClassVisitor.this.util.getType(ctx.array_type.getText());
                        if (type instanceof VoidType || type instanceof NullType) {
                            throw new ResolveException(type + " can not be an ArrayType.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                        }
                        Immediate dim = this.visitImmediate(ctx.array_descriptor().immediate());
                        return JavaJimple.getInstance().newNewArrayExpr(type, dim);
                    }
                    if (ctx.NEWMULTIARRAY() != null && ctx.immediate() != null) {
                        Type type = ClassVisitor.this.util.getType(ctx.multiarray_type.getText());
                        if (!(type instanceof ReferenceType) && !(type instanceof PrimitiveType)) {
                            throw new ResolveException(" Only base types are allowed", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                        }
                        List sizes = ctx.immediate().stream().map(this::visitImmediate).collect(Collectors.toList());
                        if (sizes.isEmpty()) {
                            throw new ResolveException("The Size list must have at least one Element.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                        }
                        ArrayType arrtype = ClassVisitor.this.identifierFactory.getArrayType(type, sizes.size());
                        return Jimple.newNewMultiArrayExpr((ArrayType)arrtype, sizes);
                    }
                    if (ctx.nonvoid_cast != null && ctx.op != null) {
                        Type type = ClassVisitor.this.util.getType(ctx.nonvoid_cast.getText());
                        Immediate val = this.visitImmediate(ctx.op);
                        return Jimple.newCastExpr((Immediate)val, (Type)type);
                    }
                    if (ctx.INSTANCEOF() != null && ctx.op != null) {
                        Type type = ClassVisitor.this.util.getType(ctx.nonvoid_type.getText());
                        Immediate val = this.visitImmediate(ctx.op);
                        return Jimple.newInstanceOfExpr((Immediate)val, (Type)type);
                    }
                    return (Value)super.visitValue(ctx);
                }

                @Override
                public Immediate visitImmediate(JimpleParser.ImmediateContext ctx) {
                    if (ctx.identifier() != null) {
                        return MethodVisitor.this.getLocal(ctx.identifier().getText());
                    }
                    return this.visitConstant(ctx.constant());
                }

                @Override
                public Value visitReference(JimpleParser.ReferenceContext ctx) {
                    if (ctx.array_descriptor() != null) {
                        Immediate idx = this.visitImmediate(ctx.array_descriptor().immediate());
                        Local type = MethodVisitor.this.getLocal(ctx.identifier().getText());
                        return JavaJimple.getInstance().newArrayRef(type, idx);
                    }
                    if (ctx.DOT() != null) {
                        String base = ctx.identifier().getText();
                        FieldSignature fs = ClassVisitor.this.util.getFieldSignature(ctx.field_signature());
                        return Jimple.newInstanceFieldRef((Local)MethodVisitor.this.getLocal(base), (FieldSignature)fs);
                    }
                    FieldSignature fs = ClassVisitor.this.util.getFieldSignature(ctx.field_signature());
                    return Jimple.newStaticFieldRef((FieldSignature)fs);
                }

                @Override
                public Expr visitInvoke_expr(JimpleParser.Invoke_exprContext ctx) {
                    List<Immediate> arglist = this.getArgList(ctx.arg_list(0));
                    if (ctx.nonstaticinvoke != null) {
                        Local base = MethodVisitor.this.getLocal(ctx.local_name.getText());
                        MethodSignature methodSig = ClassVisitor.this.util.getMethodSignature(ctx.method_signature(), ctx);
                        switch (ctx.nonstaticinvoke.getText().charAt(0)) {
                            case 'i': {
                                return Jimple.newInterfaceInvokeExpr((Local)base, (MethodSignature)methodSig, arglist);
                            }
                            case 'v': {
                                return Jimple.newVirtualInvokeExpr((Local)base, (MethodSignature)methodSig, arglist);
                            }
                            case 's': {
                                return Jimple.newSpecialInvokeExpr((Local)base, (MethodSignature)methodSig, arglist);
                            }
                        }
                        throw new ResolveException("Unknown Nonstatic Invoke.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                    }
                    if (ctx.staticinvoke != null) {
                        MethodSignature methodSig = ClassVisitor.this.util.getMethodSignature(ctx.method_signature(), ctx);
                        return Jimple.newStaticInvokeExpr((MethodSignature)methodSig, arglist);
                    }
                    if (ctx.dynamicinvoke != null) {
                        List<Type> bootstrapMethodRefParams = ClassVisitor.this.util.getTypeList(ctx.type_list());
                        MethodSignature bootstrapMethodRef = ClassVisitor.this.identifierFactory.getMethodSignature(ClassVisitor.this.identifierFactory.getClassType("sootup.dummy.InvokeDynamic"), ctx.STRING_CONSTANT().getText().replace("\"", ""), ClassVisitor.this.util.getType(ctx.name.getText()), bootstrapMethodRefParams);
                        MethodSignature methodRef = ClassVisitor.this.util.getMethodSignature(ctx.bsm, ctx);
                        List<Immediate> bootstrapArgs = this.getArgList(ctx.staticargs);
                        return Jimple.newDynamicInvokeExpr((MethodSignature)methodRef, bootstrapArgs, (MethodSignature)bootstrapMethodRef, this.getArgList(ctx.dyn_args));
                    }
                    throw new ResolveException("Malformed Invoke Expression.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                }

                @Override
                public Constant visitConstant(JimpleParser.ConstantContext ctx) {
                    if (ctx.integer_constant() != null) {
                        int lastCharPos;
                        String intConst = ctx.integer_constant().getText();
                        if (intConst.charAt(lastCharPos = intConst.length() - 1) == 'L' || intConst.charAt(lastCharPos) == 'l') {
                            intConst = intConst.substring(0, lastCharPos);
                            return LongConstant.getInstance((long)Long.parseLong(intConst));
                        }
                        return IntConstant.getInstance((int)Integer.parseInt(intConst));
                    }
                    if (ctx.FLOAT_CONSTANT() != null) {
                        int lastCharPos;
                        String floatStr = ctx.FLOAT_CONSTANT().getText();
                        if (floatStr.charAt(lastCharPos = floatStr.length() - 1) == 'F' || floatStr.charAt(lastCharPos) == 'f') {
                            floatStr = floatStr.substring(0, lastCharPos);
                            return FloatConstant.getInstance((float)Float.parseFloat(floatStr));
                        }
                        if (floatStr.charAt(0) == '#') {
                            switch (floatStr.substring(1)) {
                                case "Infinity": {
                                    return DoubleConstant.getInstance((double)Double.POSITIVE_INFINITY);
                                }
                                case "-Infinity": {
                                    return DoubleConstant.getInstance((double)Double.NEGATIVE_INFINITY);
                                }
                                case "NaN": {
                                    return DoubleConstant.getInstance((double)Double.NaN);
                                }
                            }
                        }
                        return DoubleConstant.getInstance((double)Double.parseDouble(floatStr));
                    }
                    if (ctx.CLASS() != null) {
                        String text = Jimple.unescape((String)ctx.STRING_CONSTANT().getText());
                        return JavaJimple.getInstance().newClassConstant(text);
                    }
                    if (ctx.STRING_CONSTANT() != null) {
                        String text = Jimple.unescape((String)ctx.STRING_CONSTANT().getText());
                        return JavaJimple.getInstance().newStringConstant(text);
                    }
                    if (ctx.BOOL_CONSTANT() != null) {
                        char firstChar = ctx.BOOL_CONSTANT().getText().charAt(0);
                        return BooleanConstant.getInstance((firstChar == 't' || firstChar == 'T' ? 1 : 0) != 0);
                    }
                    if (ctx.NULL() != null) {
                        return NullConstant.getInstance();
                    }
                    if (ctx.methodhandle() != null) {
                        JimpleParser.MethodhandleContext methodhandleContext = ctx.methodhandle();
                        String kindName = methodhandleContext.STRING_CONSTANT().getText();
                        FieldSignature referenceSignature = methodhandleContext.method_signature() != null ? ClassVisitor.this.util.getMethodSignature(methodhandleContext.method_signature(), methodhandleContext) : ClassVisitor.this.util.getFieldSignature(methodhandleContext.field_signature());
                        return JavaJimple.getInstance().newMethodHandle((SootClassMemberSignature)referenceSignature, MethodHandle.Kind.getKind((String)kindName.substring(1, kindName.length() - 1)));
                    }
                    if (ctx.methodtype != null && ctx.method_subsignature() != null) {
                        JimpleParser.Type_listContext typelist = ctx.method_subsignature().type_list();
                        List<Type> typeList = ClassVisitor.this.util.getTypeList(typelist);
                        return JavaJimple.getInstance().newMethodType(typeList, ClassVisitor.this.identifierFactory.getType(ctx.method_subsignature().type().getText()));
                    }
                    throw new ResolveException("Unknown Constant.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                }

                @Override
                public AbstractBinopExpr visitBinop_expr(JimpleParser.Binop_exprContext ctx) {
                    Immediate left = this.visitImmediate(ctx.left);
                    Immediate right = this.visitImmediate(ctx.right);
                    JimpleParser.BinopContext binopctx = ctx.binop();
                    if (binopctx.AND() != null) {
                        return new JAndExpr(left, right);
                    }
                    if (binopctx.OR() != null) {
                        return new JOrExpr(left, right);
                    }
                    if (binopctx.CMP() != null) {
                        return new JCmpExpr(left, right);
                    }
                    if (binopctx.CMPG() != null) {
                        return new JCmpgExpr(left, right);
                    }
                    if (binopctx.CMPL() != null) {
                        return new JCmplExpr(left, right);
                    }
                    if (binopctx.CMPEQ() != null) {
                        return new JEqExpr(left, right);
                    }
                    if (binopctx.CMPNE() != null) {
                        return new JNeExpr(left, right);
                    }
                    if (binopctx.CMPGT() != null) {
                        return new JGtExpr(left, right);
                    }
                    if (binopctx.CMPGE() != null) {
                        return new JGeExpr(left, right);
                    }
                    if (binopctx.CMPLT() != null) {
                        return new JLtExpr(left, right);
                    }
                    if (binopctx.CMPLE() != null) {
                        return new JLeExpr(left, right);
                    }
                    if (binopctx.SHL() != null) {
                        return new JShlExpr(left, right);
                    }
                    if (binopctx.SHR() != null) {
                        return new JShrExpr(left, right);
                    }
                    if (binopctx.USHR() != null) {
                        return new JUshrExpr(left, right);
                    }
                    if (binopctx.PLUS() != null) {
                        return new JAddExpr(left, right);
                    }
                    if (binopctx.MINUS() != null) {
                        return new JSubExpr(left, right);
                    }
                    if (binopctx.MULT() != null) {
                        return new JMulExpr(left, right);
                    }
                    if (binopctx.DIV() != null) {
                        return new JDivExpr(left, right);
                    }
                    if (binopctx.XOR() != null) {
                        return new JXorExpr(left, right);
                    }
                    if (binopctx.MOD() != null) {
                        return new JRemExpr(left, right);
                    }
                    throw new ResolveException("Unknown BinOp: " + binopctx.getText(), ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                }

                @Override
                public Expr visitUnop_expr(JimpleParser.Unop_exprContext ctx) {
                    Immediate value = this.visitImmediate(ctx.immediate());
                    if (ctx.unop().NEG() != null) {
                        return Jimple.newNegExpr((Immediate)value);
                    }
                    return Jimple.newLengthExpr((Immediate)value);
                }

                @Nonnull
                private List<Immediate> getArgList(JimpleParser.Arg_listContext ctx) {
                    if (ctx == null || ctx.immediate() == null) {
                        return Collections.emptyList();
                    }
                    List<JimpleParser.ImmediateContext> immediates = ctx.immediate();
                    ArrayList<Immediate> arglist = new ArrayList<Immediate>(immediates.size());
                    for (JimpleParser.ImmediateContext immediate : immediates) {
                        arglist.add(this.visitImmediate(immediate));
                    }
                    return arglist;
                }
            }

            private class StmtVisitor
            extends JimpleBaseVisitor<Stmt> {
                final ValueVisitor valueVisitor;

                private StmtVisitor() {
                    this.valueVisitor = new ValueVisitor();
                }

                @Override
                public Stmt visitStatement(JimpleParser.StatementContext ctx) {
                    JimpleParser.StmtContext stmtCtx = ctx.stmt();
                    if (stmtCtx == null) {
                        throw new ResolveException("Couldn't parse Stmt.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                    }
                    Stmt stmt = this.visitStmt(stmtCtx);
                    if (ctx.label_name != null) {
                        String labelname = ctx.label_name.getText();
                        MethodVisitor.this.labeledStmts.put(labelname, stmt);
                    }
                    return stmt;
                }

                @Override
                @Nonnull
                public Stmt visitStmt(JimpleParser.StmtContext ctx) {
                    SimpleStmtPositionInfo pos = new SimpleStmtPositionInfo(ctx.start.getLine());
                    if (ctx.BREAKPOINT() != null) {
                        return Jimple.newBreakpointStmt((StmtPositionInfo)pos);
                    }
                    if (ctx.ENTERMONITOR() != null) {
                        return Jimple.newEnterMonitorStmt((Immediate)this.valueVisitor.visitImmediate(ctx.immediate()), (StmtPositionInfo)pos);
                    }
                    if (ctx.EXITMONITOR() != null) {
                        return Jimple.newExitMonitorStmt((Immediate)this.valueVisitor.visitImmediate(ctx.immediate()), (StmtPositionInfo)pos);
                    }
                    if (ctx.SWITCH() != null) {
                        JSwitchStmt switchStmt;
                        Immediate key = this.valueVisitor.visitImmediate(ctx.immediate());
                        ArrayList<IntConstant> lookup = new ArrayList<IntConstant>();
                        ArrayList<String> targetLabels = new ArrayList<String>();
                        int min = Integer.MAX_VALUE;
                        String defaultLabel = null;
                        for (JimpleParser.Case_stmtContext it : ctx.case_stmt()) {
                            JimpleParser.Case_labelContext case_labelContext = it.case_label();
                            if (case_labelContext.getText() != null && case_labelContext.DEFAULT() != null) {
                                if (defaultLabel == null) {
                                    defaultLabel = it.goto_stmt().label_name.getText();
                                    continue;
                                }
                                throw new ResolveException("Only one default label is allowed!", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                            }
                            if (case_labelContext.integer_constant().getText() != null) {
                                int value = Integer.parseInt(case_labelContext.integer_constant().getText());
                                min = Math.min(min, value);
                                lookup.add(IntConstant.getInstance((int)value));
                                targetLabels.add(it.goto_stmt().label_name.getText());
                                continue;
                            }
                            throw new ResolveException("Label is invalid.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                        }
                        targetLabels.add(defaultLabel);
                        if (ctx.SWITCH().getText().charAt(0) == 't') {
                            int high = min + lookup.size() - 1;
                            switchStmt = Jimple.newTableSwitchStmt((Immediate)key, (int)min, (int)high, (StmtPositionInfo)pos);
                        } else {
                            switchStmt = Jimple.newLookupSwitchStmt((Immediate)key, lookup, (StmtPositionInfo)pos);
                        }
                        MethodVisitor.this.unresolvedBranches.put(switchStmt, targetLabels);
                        return switchStmt;
                    }
                    JimpleParser.AssignmentsContext assignments = ctx.assignments();
                    if (assignments != null) {
                        if (assignments.COLON_EQUALS() != null) {
                            JCaughtExceptionRef ref;
                            Local left = MethodVisitor.this.getLocal(assignments.local.getText());
                            JimpleParser.Identity_refContext identityRefCtx = assignments.identity_ref();
                            if (identityRefCtx.caught != null) {
                                ref = JavaJimple.getInstance().newCaughtExceptionRef();
                            } else {
                                String type = assignments.identity_ref().type().getText();
                                if (identityRefCtx.parameter_idx != null) {
                                    int idx = Integer.parseInt(identityRefCtx.parameter_idx.getText());
                                    ref = Jimple.newParameterRef((Type)ClassVisitor.this.util.getType(type), (int)idx);
                                } else {
                                    ref = ClassVisitor.this.clazz.toString().equals(type) ? Jimple.newThisRef((ClassType)ClassVisitor.this.clazz) : Jimple.newThisRef((ClassType)ClassVisitor.this.util.getClassType(type));
                                }
                            }
                            return Jimple.newIdentityStmt((Local)left, (IdentityRef)ref, (StmtPositionInfo)pos);
                        }
                        if (assignments.EQUALS() != null) {
                            Local left = assignments.local != null ? MethodVisitor.this.getLocal(assignments.local.getText()) : (LValue)this.valueVisitor.visitReference(assignments.reference());
                            Value right = this.valueVisitor.visitValue(assignments.value());
                            return Jimple.newAssignStmt((LValue)left, (Value)right, (StmtPositionInfo)pos);
                        }
                        throw new ResolveException("Invalid assignment.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                    }
                    if (ctx.IF() != null) {
                        JIfStmt stmt = Jimple.newIfStmt((AbstractConditionExpr)((AbstractConditionExpr)this.valueVisitor.visitBool_expr(ctx.bool_expr())), (StmtPositionInfo)pos);
                        MethodVisitor.this.unresolvedBranches.put(stmt, Collections.singletonList(ctx.goto_stmt().label_name.getText()));
                        return stmt;
                    }
                    if (ctx.goto_stmt() != null) {
                        JGotoStmt stmt = Jimple.newGotoStmt((StmtPositionInfo)pos);
                        MethodVisitor.this.unresolvedBranches.put(stmt, Collections.singletonList(ctx.goto_stmt().label_name.getText()));
                        return stmt;
                    }
                    if (ctx.NOP() != null) {
                        return Jimple.newNopStmt((StmtPositionInfo)pos);
                    }
                    if (ctx.RET() != null) {
                        return Jimple.newRetStmt((Immediate)this.valueVisitor.visitImmediate(ctx.immediate()), (StmtPositionInfo)pos);
                    }
                    if (ctx.RETURN() != null) {
                        if (ctx.immediate() == null) {
                            return Jimple.newReturnVoidStmt((StmtPositionInfo)pos);
                        }
                        return Jimple.newReturnStmt((Immediate)this.valueVisitor.visitImmediate(ctx.immediate()), (StmtPositionInfo)pos);
                    }
                    if (ctx.THROW() != null) {
                        return Jimple.newThrowStmt((Immediate)this.valueVisitor.visitImmediate(ctx.immediate()), (StmtPositionInfo)pos);
                    }
                    if (ctx.invoke_expr() != null) {
                        return Jimple.newInvokeStmt((AbstractInvokeExpr)((AbstractInvokeExpr)this.valueVisitor.visitInvoke_expr(ctx.invoke_expr())), (StmtPositionInfo)pos);
                    }
                    throw new ResolveException("Unknown Stmt.", ClassVisitor.this.path, JimpleConverterUtil.buildPositionFromCtx(ctx));
                }
            }
        }
    }
}

