/*
 * Decompiled with CFR 0.152.
 */
package sootup.jimple.parser;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.CharStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.frontend.ClassProvider;
import sootup.core.frontend.ResolveException;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.FileType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.jimple.parser.JimpleConverter;

public class JimpleClassProvider
implements ClassProvider {
    @Nonnull
    private final List<BodyInterceptor> bodyInterceptors;
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(JimpleClassProvider.class);

    public JimpleClassProvider(List<BodyInterceptor> bodyInterceptors) {
        this.bodyInterceptors = bodyInterceptors;
    }

    public Optional<SootClassSource> createClassSource(AnalysisInputLocation inputlocation, Path sourcePath, ClassType classSignature) {
        try {
            JimpleConverter jimpleConverter = new JimpleConverter();
            return Optional.of(jimpleConverter.run(CharStreams.fromPath((Path)sourcePath), inputlocation, sourcePath, this.bodyInterceptors));
        }
        catch (IOException | ResolveException e) {
            logger.warn("The jimple file of " + classSignature + " in path: " + sourcePath + " could not be converted because of: " + e.getMessage());
            return Optional.empty();
        }
    }

    public FileType getHandledFileType() {
        return FileType.JIMPLE;
    }
}

