/*
 * Decompiled with CFR 0.152.
 */
package sootup.jimple.parser;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.ClassProvider;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.FileType;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.util.PathUtils;
import sootup.core.util.StreamUtils;
import sootup.core.views.View;
import sootup.jimple.parser.JimpleClassProvider;

public class JimpleAnalysisInputLocation
implements AnalysisInputLocation {
    final Path path;
    private final SourceType srcType;
    @Nonnull
    private final List<BodyInterceptor> bodyInterceptors;

    public JimpleAnalysisInputLocation(@Nonnull Path path) {
        this(path, SourceType.Application, Collections.emptyList());
    }

    public JimpleAnalysisInputLocation(@Nonnull Path path, @Nullable SourceType srcType) {
        this(path, srcType, Collections.emptyList());
    }

    public JimpleAnalysisInputLocation(@Nonnull Path path, @Nullable SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("The configured path '" + path + "' pointing to '" + path.toAbsolutePath() + "' does not exist.");
        }
        this.bodyInterceptors = bodyInterceptors;
        this.path = path;
        this.srcType = srcType;
    }

    @Nonnull
    public SourceType getSourceType() {
        return this.srcType;
    }

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.bodyInterceptors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    List<SootClassSource> walkDirectory(@Nonnull Path dirPath, @Nonnull IdentifierFactory factory, @Nonnull ClassProvider classProvider) {
        try (Stream<Path> walk = Files.walk(this.path, new FileVisitOption[0]);){
            List<SootClassSource> list = walk.filter(filePath -> PathUtils.hasExtension((Path)filePath, (FileType[])new FileType[]{FileType.JIMPLE})).flatMap(p -> {
                String fullyQualifiedName = FilenameUtils.removeExtension((String)p.subpath(this.path.getNameCount(), p.getNameCount()).toString().replace(p.getFileSystem().getSeparator(), "."));
                return StreamUtils.optionalToStream((Optional)classProvider.createClassSource((AnalysisInputLocation)this, p, factory.getClassType(fullyQualifiedName)));
            }).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    public Collection<SootClassSource> getClassSources(@Nonnull View view) {
        return this.walkDirectory(this.path, view.getIdentifierFactory(), new JimpleClassProvider(this.bodyInterceptors));
    }

    @Nonnull
    public Optional<SootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        JimpleClassProvider classProvider = new JimpleClassProvider(this.bodyInterceptors);
        String ext = classProvider.getHandledFileType().toString().toLowerCase();
        Path pathToClass = this.path.resolve(type.getFullyQualifiedName() + "." + ext);
        if (!Files.exists(pathToClass, new LinkOption[0]) && !Files.exists(pathToClass = this.path.resolve(type.getPackageName().toString().replace('.', File.separatorChar) + File.separator + type.getClassName() + "." + ext), new LinkOption[0])) {
            return Optional.empty();
        }
        return classProvider.createClassSource(this, pathToClass, type);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JimpleAnalysisInputLocation)) {
            return false;
        }
        return this.path.equals(((JimpleAnalysisInputLocation)o).path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

