/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.inputlocation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.ClassProvider;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.FileType;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.util.PathUtils;
import sootup.core.util.StreamUtils;
import sootup.core.views.View;
import sootup.java.bytecode.frontend.AsmJavaClassProvider;
import sootup.java.bytecode.inputlocation.ArchiveBasedAnalysisInputLocation;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.interceptors.BytecodeBodyInterceptors;
import sootup.java.core.types.JavaClassType;

public abstract class PathBasedAnalysisInputLocation
implements AnalysisInputLocation {
    @Nonnull
    protected Path path;
    @Nonnull
    protected Collection<Path> ignoredPaths;
    @Nonnull
    protected final SourceType sourceType;
    @Nonnull
    protected final List<BodyInterceptor> bodyInterceptors;

    protected PathBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType) {
        this(path, srcType, Collections.emptyList());
    }

    protected PathBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this(path, srcType, bodyInterceptors, Collections.emptyList());
    }

    protected PathBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors, @Nonnull Collection<Path> ignoredPaths) {
        this.path = path;
        this.ignoredPaths = ignoredPaths.stream().map(Path::toAbsolutePath).collect(Collectors.toCollection(HashSet::new));
        this.sourceType = srcType;
        this.bodyInterceptors = bodyInterceptors;
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("The provided path '" + path + "' does not exist.");
        }
    }

    @Nonnull
    public SourceType getSourceType() {
        return this.sourceType;
    }

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.bodyInterceptors;
    }

    @Nonnull
    public static PathBasedAnalysisInputLocation create(@Nonnull Path path, @Nonnull SourceType sourceType) {
        return PathBasedAnalysisInputLocation.create(path, sourceType, Collections.emptyList());
    }

    @Nonnull
    public static PathBasedAnalysisInputLocation create(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        return PathBasedAnalysisInputLocation.create(path, srcType, bodyInterceptors, Collections.emptyList());
    }

    @Nonnull
    public static PathBasedAnalysisInputLocation create(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors, @Nonnull Collection<Path> ignoredPaths) {
        if (ignoredPaths.stream().anyMatch(ignoPath -> path.toString().startsWith(ignoPath.toString()))) {
            throw new IllegalArgumentException("The Path for the AnalysisInputLocation is in the ignored paths.");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new DirectoryBasedAnalysisInputLocation(path, srcType, bodyInterceptors, ignoredPaths);
        }
        if (PathUtils.isArchive((Path)path)) {
            if (PathUtils.hasExtension((Path)path, (FileType[])new FileType[]{FileType.JAR})) {
                return new ArchiveBasedAnalysisInputLocation(path, srcType, bodyInterceptors, ignoredPaths);
            }
            if (PathUtils.hasExtension((Path)path, (FileType[])new FileType[]{FileType.WAR})) {
                try {
                    return new WarArchiveAnalysisInputLocation(path, srcType, bodyInterceptors, ignoredPaths);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new IllegalArgumentException("Path '" + path.toAbsolutePath() + "' has to be pointing to the root of a class container, e.g. directory, jar, zip, apk, war etc.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    Collection<JavaSootClassSource> walkDirectory(@Nonnull Path dirPath, @Nonnull IdentifierFactory factory, @Nonnull ClassProvider classProvider) {
        FileType handledFileType = classProvider.getHandledFileType();
        String moduleInfoFilename = "module-info.class";
        try (Stream<Path> walk = Files.walk(dirPath, new FileVisitOption[0]);){
            Collection collection = walk.filter(filePath -> PathUtils.hasExtension((Path)filePath, (FileType[])new FileType[]{handledFileType}) && !filePath.toString().endsWith("module-info.class") && this.ignoredPaths.stream().noneMatch(p -> filePath.toString().startsWith(p.toString()))).flatMap(p -> {
                String fullyQualifiedName = this.fromPath(dirPath, (Path)p);
                return StreamUtils.optionalToStream((Optional)classProvider.createClassSource((AnalysisInputLocation)this, p, factory.getClassType(fullyQualifiedName)));
            }).map(src -> (JavaSootClassSource)src).collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    protected String fromPath(@Nonnull Path baseDirPath, Path packageNamePathAndClass) {
        return FilenameUtils.removeExtension((String)packageNamePathAndClass.subpath(baseDirPath.getNameCount(), packageNamePathAndClass.getNameCount()).toString().replace(packageNamePathAndClass.getFileSystem().getSeparator(), "."));
    }

    @Nonnull
    protected Optional<JavaSootClassSource> getClassSourceInternal(@Nonnull JavaClassType signature, @Nonnull Path path, @Nonnull ClassProvider classProvider) {
        Path pathToClass = path.resolve(path.getFileSystem().getPath(signature.getFullyQualifiedName().replace('.', '/') + classProvider.getHandledFileType().getExtensionWithDot(), new String[0]));
        if (!Files.exists(pathToClass, new LinkOption[0])) {
            return Optional.empty();
        }
        Optional classSource = classProvider.createClassSource((AnalysisInputLocation)this, pathToClass, (ClassType)signature);
        return classSource.map(src -> (JavaSootClassSource)src);
    }

    protected Optional<JavaSootClassSource> getSingleClass(@Nonnull JavaClassType signature, @Nonnull Path path, @Nonnull ClassProvider classProvider) {
        Path pathToClass = Paths.get(path.toString(), new String[0]);
        Optional classSource = classProvider.createClassSource((AnalysisInputLocation)this, pathToClass, (ClassType)signature);
        return classSource.map(src -> (JavaSootClassSource)src);
    }

    private static final class WarArchiveAnalysisInputLocation
    extends DirectoryBasedAnalysisInputLocation {
        public List<AnalysisInputLocation> containedInputLocations = new ArrayList<AnalysisInputLocation>();
        public static int maxAllowedBytesToExtract = 524288000;

        private WarArchiveAnalysisInputLocation(@Nonnull Path warPath, @Nonnull SourceType srcType) throws IOException {
            this(warPath, srcType, BytecodeBodyInterceptors.Default.getBodyInterceptors(), Collections.emptyList());
        }

        private WarArchiveAnalysisInputLocation(@Nonnull Path warPath, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors, @Nonnull Collection<Path> ignoredPaths) throws IOException {
            super(Files.createTempDirectory("sootUp-war-" + warPath.hashCode(), new FileAttribute[0]).toAbsolutePath(), srcType, bodyInterceptors, ignoredPaths);
            Path libDir;
            this.extractWarFile(warPath, this.path);
            Path webInfPath = this.path.resolve("WEB-INF");
            Path classDir = webInfPath.resolve("classes");
            if (Files.exists(classDir, new LinkOption[0])) {
                this.containedInputLocations.add(new DirectoryBasedAnalysisInputLocation(classDir, srcType, bodyInterceptors));
            }
            if (Files.exists(libDir = webInfPath.resolve("lib"), new LinkOption[0])) {
                try {
                    Files.walk(libDir, new FileVisitOption[0]).filter(f -> PathUtils.hasExtension((Path)f, (FileType[])new FileType[]{FileType.JAR})).forEach(f -> this.containedInputLocations.add(new ArchiveBasedAnalysisInputLocation((Path)f, srcType, bodyInterceptors)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public WarArchiveAnalysisInputLocation(Path path, SourceType srcType, List<BodyInterceptor> bodyInterceptors) throws IOException {
            this(path, srcType, bodyInterceptors, Collections.emptyList());
        }

        @Override
        @Nonnull
        public Collection<JavaSootClassSource> getClassSources(@Nonnull View view) {
            HashSet foundClasses = new HashSet();
            for (AnalysisInputLocation inputLoc : this.containedInputLocations) {
                foundClasses.addAll(inputLoc.getClassSources(view));
            }
            return foundClasses.stream().map(src -> (JavaSootClassSource)src).collect(Collectors.toList());
        }

        @Override
        @Nonnull
        public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
            for (AnalysisInputLocation inputLocation : this.containedInputLocations) {
                Optional classSource = inputLocation.getClassSource(type, view);
                if (!classSource.isPresent()) continue;
                return classSource.map(src -> (JavaSootClassSource)src);
            }
            return Optional.empty();
        }

        void extractWarFile(Path warFilePath, Path destDirectory) {
            int extractedSize = 0;
            try {
                ZipEntry zipEntry;
                File dest = destDirectory.toFile();
                if (!dest.exists()) {
                    if (!dest.mkdir()) {
                        throw new RuntimeException("Could not create the directory to extract Warfile: " + destDirectory);
                    }
                    dest.deleteOnExit();
                }
                ZipInputStream zis = new ZipInputStream(Files.newInputStream(warFilePath, new OpenOption[0]));
                while ((zipEntry = zis.getNextEntry()) != null) {
                    Path filepath = destDirectory.resolve(zipEntry.getName());
                    File file = filepath.toFile();
                    file.deleteOnExit();
                    if (zipEntry.isDirectory()) {
                        file.mkdir();
                    } else {
                        int readBytesZip;
                        byte[] incomingValues = new byte[4096];
                        if (file.exists()) {
                            BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                            byte[] bisBuf = new byte[4096];
                            while ((readBytesZip = zis.read(incomingValues)) != -1) {
                                if (extractedSize > maxAllowedBytesToExtract) {
                                    throw new RuntimeException("The extracted warfile exceeds the size of " + maxAllowedBytesToExtract + " byte. Either the file is a big archive (-> increase PathBasedAnalysisInputLocation.WarArchiveInputLocation.maxAllowedBytesToExtract) or maybe it contains an archive bomb.");
                                }
                                int readBytesExistingFile = bis.read(bisBuf, 0, readBytesZip);
                                if (readBytesExistingFile != readBytesZip) {
                                    throw new RuntimeException("Can't extract File \"" + file + "\" as it already exists and has a different size.");
                                }
                                if (!Arrays.equals(bisBuf, incomingValues)) {
                                    throw new RuntimeException("Can't extract File \"" + file + "\" as it already exists and has a different content which we can't override.");
                                }
                                extractedSize += readBytesZip;
                            }
                        } else {
                            BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
                            while ((readBytesZip = zis.read(incomingValues)) != -1) {
                                if (extractedSize > maxAllowedBytesToExtract) {
                                    throw new RuntimeException("The extracted warfile exceeds the size of " + maxAllowedBytesToExtract + " byte. Either the file is a big archive or maybe it contains an archive bomb.");
                                }
                                bos.write(incomingValues, 0, readBytesZip);
                                extractedSize += readBytesZip;
                            }
                            bos.close();
                        }
                    }
                    zis.closeEntry();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Nonnull
        public List<String> retrieveServletClasses(String extractedWARPath) {
            ArrayList<String> classesInXML = new ArrayList<String>();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new File(extractedWARPath + "/WEB-INF/web.xml"));
                document.getDocumentElement().normalize();
                NodeList nList = document.getElementsByTagName("servlet");
                for (int temp = 0; temp < nList.getLength(); ++temp) {
                    Node node = nList.item(temp);
                    if (node.getNodeType() != 1) continue;
                    Element eElement = (Element)node;
                    classesInXML.add(eElement.getElementsByTagName("servlet-class").item(0).getTextContent());
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException(e);
            }
            return classesInXML;
        }
    }

    private static class DirectoryBasedAnalysisInputLocation
    extends PathBasedAnalysisInputLocation {
        protected DirectoryBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
            this(path, srcType, bodyInterceptors, Collections.emptyList());
        }

        protected DirectoryBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors, @Nonnull Collection<Path> ignoredPaths) {
            super(path, srcType, bodyInterceptors, ignoredPaths);
        }

        @Nonnull
        public Collection<JavaSootClassSource> getClassSources(@Nonnull View view) {
            return this.walkDirectory(this.path, view.getIdentifierFactory(), new AsmJavaClassProvider(view));
        }

        @Nonnull
        public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
            return this.getClassSourceInternal((JavaClassType)type, this.path, new AsmJavaClassProvider(view));
        }
    }

    public static class ClassFileBasedAnalysisInputLocation
    extends PathBasedAnalysisInputLocation {
        @Nonnull
        private final String omittedPackageName;

        public ClassFileBasedAnalysisInputLocation(@Nonnull Path classFilePath, @Nonnull String omittedPackageName, @Nonnull SourceType srcType) {
            this(classFilePath, omittedPackageName, srcType, BytecodeBodyInterceptors.Default.getBodyInterceptors());
        }

        public ClassFileBasedAnalysisInputLocation(@Nonnull Path classFilePath, @Nonnull String omittedPackageName, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
            super(classFilePath, srcType, bodyInterceptors);
            this.omittedPackageName = omittedPackageName;
            if (!Files.isRegularFile(classFilePath, new LinkOption[0])) {
                throw new IllegalArgumentException("Needs to point to a regular file!");
            }
            if (Files.isDirectory(classFilePath, new LinkOption[0])) {
                throw new IllegalArgumentException("Needs to point to a regular file - not to a directory.");
            }
        }

        @Nonnull
        public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
            if (!type.getPackageName().getName().startsWith(this.omittedPackageName)) {
                return Optional.empty();
            }
            return this.getSingleClass((JavaClassType)type, this.path, new AsmJavaClassProvider(view));
        }

        @Nonnull
        public Collection<JavaSootClassSource> getClassSources(@Nonnull View view) {
            AsmJavaClassProvider classProvider = new AsmJavaClassProvider(view);
            IdentifierFactory factory = view.getIdentifierFactory();
            Path dirPath = this.path.getParent();
            String fullyQualifiedName = this.fromPath(dirPath, this.path);
            Optional<JavaSootClassSource> classSource = classProvider.createClassSource(this, this.path, factory.getClassType(fullyQualifiedName)).map(src -> (JavaSootClassSource)src);
            return Collections.singletonList(classSource.get());
        }

        @Override
        @Nonnull
        protected String fromPath(@Nonnull Path baseDirPath, Path packageNamePathAndClass) {
            String str = FilenameUtils.removeExtension((String)packageNamePathAndClass.subpath(baseDirPath.getNameCount(), packageNamePathAndClass.getNameCount()).toString().replace(packageNamePathAndClass.getFileSystem().getSeparator(), "."));
            return this.omittedPackageName.isEmpty() ? str : this.omittedPackageName + "." + str;
        }
    }
}

