/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import com.google.common.base.Suppliers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.ModuleExportNode;
import org.objectweb.asm.tree.ModuleNode;
import org.objectweb.asm.tree.ModuleOpenNode;
import org.objectweb.asm.tree.ModuleProvideNode;
import org.objectweb.asm.tree.ModuleRequireNode;
import sootup.core.frontend.ResolveException;
import sootup.java.bytecode.frontend.AsmUtil;
import sootup.java.core.JavaModuleIdentifierFactory;
import sootup.java.core.JavaModuleInfo;
import sootup.java.core.ModuleModifier;
import sootup.java.core.signatures.ModuleSignature;
import sootup.java.core.types.JavaClassType;

public class AsmModuleSource
extends JavaModuleInfo {
    @Nonnull
    private final Path sourcePath;
    @Nonnull
    private final Supplier<ModuleNode> _lazyModule = Suppliers.memoize(this::_lazyModule);

    public AsmModuleSource(@Nonnull Path sourcePath) {
        this.sourcePath = sourcePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModuleNode _lazyModule() {
        try (InputStream sourceFileInputStream = Files.newInputStream(this.sourcePath, new OpenOption[0]);){
            ClassReader clsr = new ClassReader(sourceFileInputStream);
            ClassNode classNode = new ClassNode(589824);
            clsr.accept((ClassVisitor)classNode, 4);
            ModuleNode moduleNode = classNode.module;
            return moduleNode;
        }
        catch (IOException e) {
            throw new ResolveException("Can not parse the module descriptor file!", this.sourcePath, (Exception)e);
        }
    }

    public ModuleSignature getModuleSignature() {
        return JavaModuleIdentifierFactory.getModuleSignature((String)this._lazyModule.get().name);
    }

    public Collection<JavaModuleInfo.ModuleReference> requires() {
        ModuleNode module = this._lazyModule.get();
        if (module.requires == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaModuleInfo.ModuleReference> requires = new ArrayList<JavaModuleInfo.ModuleReference>(module.requires.size());
        for (ModuleRequireNode moduleRequireNode : module.requires) {
            ModuleSignature moduleSignature = JavaModuleIdentifierFactory.getModuleSignature((String)moduleRequireNode.module);
            JavaModuleInfo.ModuleReference reference = new JavaModuleInfo.ModuleReference(moduleSignature, AsmUtil.getModuleModifiers(moduleRequireNode.access));
            requires.add(reference);
        }
        return requires;
    }

    public Collection<JavaModuleInfo.PackageReference> exports() {
        ModuleNode module = this._lazyModule.get();
        if (module.exports == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaModuleInfo.PackageReference> exports = new ArrayList<JavaModuleInfo.PackageReference>(module.exports.size());
        JavaModuleIdentifierFactory identifierFactory = JavaModuleIdentifierFactory.getInstance();
        for (ModuleExportNode exportNode : module.exports) {
            ArrayList<ModuleSignature> modules = new ArrayList<ModuleSignature>(exportNode.modules.size());
            for (String moduleName : exportNode.modules) {
                modules.add(JavaModuleIdentifierFactory.getModuleSignature((String)moduleName));
            }
            JavaModuleInfo.PackageReference reference = new JavaModuleInfo.PackageReference(identifierFactory.getPackageName(exportNode.packaze.replace('/', '.'), this.getModuleSignature().toString()), AsmUtil.getModuleModifiers(exportNode.access), modules);
            exports.add(reference);
        }
        return exports;
    }

    public Collection<JavaModuleInfo.PackageReference> opens() {
        ModuleNode module = this._lazyModule.get();
        if (module.opens == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaModuleInfo.PackageReference> opens = new ArrayList<JavaModuleInfo.PackageReference>(module.opens.size());
        JavaModuleIdentifierFactory identifierFactory = JavaModuleIdentifierFactory.getInstance();
        for (ModuleOpenNode openNode : module.opens) {
            ArrayList<ModuleSignature> modules = new ArrayList<ModuleSignature>(openNode.modules.size());
            for (String moduleName : openNode.modules) {
                modules.add(JavaModuleIdentifierFactory.getModuleSignature((String)moduleName));
            }
            JavaModuleInfo.PackageReference reference = new JavaModuleInfo.PackageReference(identifierFactory.getPackageName(openNode.packaze.replace('/', '.'), this.getModuleSignature().toString()), AsmUtil.getModuleModifiers(openNode.access), modules);
            opens.add(reference);
        }
        return opens;
    }

    public Collection<JavaModuleInfo.InterfaceReference> provides() {
        ModuleNode module = this._lazyModule.get();
        if (module.provides == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaModuleInfo.InterfaceReference> providers = new ArrayList<JavaModuleInfo.InterfaceReference>(module.provides.size());
        for (ModuleProvideNode moduleProvideNode : module.provides) {
            JavaClassType serviceSignature = AsmUtil.toJimpleClassType(moduleProvideNode.service);
            if (serviceSignature == null) {
                throw new IllegalStateException("provides entry without 'with' .");
            }
            Collection<JavaClassType> providersSignatures = AsmUtil.asmIdToSignature(moduleProvideNode.providers);
            for (JavaClassType sootClassSignature : providersSignatures) {
                providers.add(new JavaModuleInfo.InterfaceReference(sootClassSignature, serviceSignature));
            }
        }
        return providers;
    }

    public Collection<JavaClassType> uses() {
        ModuleNode module = this._lazyModule.get();
        if (module.uses == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaClassType> uses = new ArrayList<JavaClassType>(module.uses.size());
        for (String usedService : module.uses) {
            JavaClassType serviceSignature = AsmUtil.toJimpleClassType(usedService);
            uses.add(serviceSignature);
        }
        return uses;
    }

    public boolean isAutomaticModule() {
        return false;
    }

    public Set<ModuleModifier> getModifiers() {
        ModuleNode module = this._lazyModule.get();
        return AsmUtil.getModuleModifiers(module.access);
    }
}

