/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.inputlocation;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.util.StreamUtils;
import sootup.core.views.View;
import sootup.java.bytecode.frontend.AsmJavaClassProvider;
import sootup.java.bytecode.frontend.AsmModuleSource;
import sootup.java.core.JavaModuleIdentifierFactory;
import sootup.java.core.JavaModuleInfo;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.ModuleInfoAnalysisInputLocation;
import sootup.java.core.signatures.ModulePackageName;
import sootup.java.core.signatures.ModuleSignature;
import sootup.java.core.types.JavaClassType;

public class JrtFileSystemAnalysisInputLocation
implements ModuleInfoAnalysisInputLocation {
    private static final FileSystem theFileSystem = FileSystems.getFileSystem(URI.create("jrt:/"));
    private final Map<ModuleSignature, JavaModuleInfo> moduleInfoMap = new HashMap<ModuleSignature, JavaModuleInfo>();
    boolean isResolved = false;
    @Nonnull
    private final SourceType sourceType;
    @Nonnull
    private final List<BodyInterceptor> bodyInterceptors;

    public JrtFileSystemAnalysisInputLocation() {
        this(SourceType.Library);
    }

    public JrtFileSystemAnalysisInputLocation(@Nonnull SourceType sourceType) {
        this(sourceType, Collections.emptyList());
    }

    public JrtFileSystemAnalysisInputLocation(@Nonnull SourceType sourceType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this.sourceType = sourceType;
        this.bodyInterceptors = bodyInterceptors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType classType, @Nonnull View view) {
        JavaClassType klassType = (JavaClassType)classType;
        AsmJavaClassProvider classProvider = new AsmJavaClassProvider(view);
        Path filepath = theFileSystem.getPath(klassType.getFullyQualifiedName().replace('.', '/') + classProvider.getHandledFileType().getExtensionWithDot(), new String[0]);
        if (klassType.getPackageName() instanceof ModulePackageName) {
            ModulePackageName modulePackageSignature = (ModulePackageName)klassType.getPackageName();
            Path module = theFileSystem.getPath("modules", modulePackageSignature.getModuleSignature().getModuleName());
            Path foundClass = module.resolve(filepath);
            if (!Files.isRegularFile(foundClass, new LinkOption[0])) return Optional.empty();
            return classProvider.createClassSource((AnalysisInputLocation)this, foundClass, (ClassType)klassType).map(src -> (JavaSootClassSource)src);
        }
        Path moduleRoot = theFileSystem.getPath("modules", new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(moduleRoot);){
            Path entry;
            Path foundfile;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return Optional.empty();
            } while (!Files.isRegularFile(foundfile = (entry = iterator.next()).resolve(filepath), new LinkOption[0]));
            Optional<JavaSootClassSource> optional = classProvider.createClassSource((AnalysisInputLocation)this, foundfile, (ClassType)klassType).map(src -> (JavaSootClassSource)src);
            return optional;
        }
        catch (IOException e) {
            throw new ResolveException("Error loading a module", moduleRoot, (Exception)e);
        }
    }

    @Nonnull
    public Collection<JavaSootClassSource> getModulesClassSources(@Nonnull ModuleSignature moduleSignature, @Nonnull View view) {
        return this.getClassSourcesInternal(moduleSignature, view.getIdentifierFactory(), view).collect(Collectors.toList());
    }

    @Nonnull
    protected Stream<JavaSootClassSource> getClassSourcesInternal(@Nonnull ModuleSignature moduleSignature, @Nonnull IdentifierFactory identifierFactory, @Nonnull View view) {
        AsmJavaClassProvider classProvider = new AsmJavaClassProvider(view);
        String moduleInfoFilename = "module-info" + classProvider.getHandledFileType().getExtensionWithDot();
        Path archiveRoot = theFileSystem.getPath("modules", moduleSignature.getModuleName());
        try {
            return Files.walk(archiveRoot, new FileVisitOption[0]).filter(filePath -> !Files.isDirectory(filePath, new LinkOption[0]) && filePath.toString().endsWith(classProvider.getHandledFileType().getExtensionWithDot()) && !filePath.toString().endsWith(moduleInfoFilename)).flatMap(p -> StreamUtils.optionalToStream((Optional)classProvider.createClassSource((AnalysisInputLocation)this, (Path)p, (ClassType)this.fromPath((Path)p, identifierFactory)))).map(src -> (JavaSootClassSource)src);
        }
        catch (IOException e) {
            throw new ResolveException("Error loading module " + moduleSignature, archiveRoot, (Exception)e);
        }
    }

    @Nonnull
    public Collection<JavaSootClassSource> getClassSources(@Nonnull View view) {
        Collection<ModuleSignature> moduleSignatures = this.discoverModules();
        return moduleSignatures.stream().flatMap(sig -> this.getClassSourcesInternal((ModuleSignature)sig, view.getIdentifierFactory(), view)).collect(Collectors.toList());
    }

    @Nonnull
    public Collection<ModuleSignature> discoverModules() {
        if (!this.isResolved) {
            Path moduleRoot = theFileSystem.getPath("modules", new String[0]);
            String moduleInfoFilename = "module-info.class";
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(moduleRoot);){
                for (Path entry : stream) {
                    if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                    ModuleSignature moduleSignature = JavaModuleIdentifierFactory.getModuleSignature((String)entry.subpath(1, 2).toString());
                    Path moduleInfo = entry.resolve("module-info.class");
                    if (Files.exists(moduleInfo, new LinkOption[0])) {
                        this.moduleInfoMap.put(moduleSignature, new AsmModuleSource(moduleInfo));
                        continue;
                    }
                    this.moduleInfoMap.put(moduleSignature, JavaModuleInfo.createAutomaticModuleInfo((ModuleSignature)moduleSignature));
                }
            }
            catch (IOException e) {
                throw new ResolveException("Error while discovering modules", moduleRoot, (Exception)e);
            }
            this.isResolved = true;
        }
        return this.moduleInfoMap.keySet();
    }

    @Nonnull
    private JavaClassType fromPath(@Nonnull Path p, @Nonnull IdentifierFactory identifierFactory) {
        Path moduleDir = p.subpath(1, 2);
        Path filename = p.subpath(2, p.getNameCount());
        String fullyQualifiedName = FilenameUtils.removeExtension((String)filename.toString().replace(filename.getFileSystem().getSeparator(), "."));
        JavaClassType sig = (JavaClassType)identifierFactory.getClassType(fullyQualifiedName);
        if (identifierFactory instanceof JavaModuleIdentifierFactory) {
            return ((JavaModuleIdentifierFactory)identifierFactory).getClassType(sig.getClassName(), sig.getPackageName().getName(), moduleDir.toString());
        }
        return sig;
    }

    @Nonnull
    public Optional<JavaModuleInfo> getModuleInfo(ModuleSignature sig, View view) {
        if (!this.isResolved) {
            this.discoverModules();
        }
        return Optional.ofNullable(this.moduleInfoMap.get(sig));
    }

    @Nonnull
    public Set<ModuleSignature> getModules(View view) {
        if (!this.isResolved) {
            this.discoverModules();
        }
        return Collections.unmodifiableSet(this.moduleInfoMap.keySet());
    }

    @Nonnull
    public SourceType getSourceType() {
        return this.sourceType;
    }

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.bodyInterceptors;
    }

    public boolean equals(Object o) {
        return o instanceof JrtFileSystemAnalysisInputLocation;
    }

    public int hashCode() {
        return 31;
    }
}

