/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.inputlocation;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.ClassProvider;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.FileType;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.util.PathUtils;
import sootup.core.util.StreamUtils;
import sootup.java.bytecode.frontend.inputlocation.ArchiveBasedAnalysisInputLocation;
import sootup.java.bytecode.frontend.inputlocation.DirectoryBasedAnalysisInputLocation;
import sootup.java.bytecode.frontend.inputlocation.WarArchiveAnalysisInputLocation;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.types.JavaClassType;

public abstract class PathBasedAnalysisInputLocation
implements AnalysisInputLocation {
    @Nonnull
    protected Path path;
    @Nonnull
    protected Collection<Path> ignoredPaths;
    @Nonnull
    protected final SourceType sourceType;
    @Nonnull
    protected final List<BodyInterceptor> bodyInterceptors;

    protected PathBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType) {
        this(path, srcType, Collections.emptyList());
    }

    protected PathBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this(path, srcType, bodyInterceptors, Collections.emptyList());
    }

    protected PathBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors, @Nonnull Collection<Path> ignoredPaths) {
        this.path = path;
        this.ignoredPaths = ignoredPaths.stream().map(Path::toAbsolutePath).collect(Collectors.toCollection(HashSet::new));
        this.sourceType = srcType;
        this.bodyInterceptors = bodyInterceptors;
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("The provided path '" + path + "' does not exist.");
        }
    }

    @Nonnull
    public SourceType getSourceType() {
        return this.sourceType;
    }

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.bodyInterceptors;
    }

    @Nonnull
    public static PathBasedAnalysisInputLocation create(@Nonnull Path path, @Nonnull SourceType sourceType) {
        return PathBasedAnalysisInputLocation.create(path, sourceType, Collections.emptyList());
    }

    @Nonnull
    public static PathBasedAnalysisInputLocation create(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        return PathBasedAnalysisInputLocation.create(path, srcType, bodyInterceptors, Collections.emptyList());
    }

    @Nonnull
    public static PathBasedAnalysisInputLocation create(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors, @Nonnull Collection<Path> ignoredPaths) {
        if (ignoredPaths.stream().anyMatch(ignoPath -> path.toString().startsWith(ignoPath.toString()))) {
            throw new IllegalArgumentException("The Path for the AnalysisInputLocation is in the ignored paths.");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new DirectoryBasedAnalysisInputLocation(path, srcType, bodyInterceptors, ignoredPaths);
        }
        if (PathUtils.isArchive((Path)path)) {
            if (PathUtils.hasExtension((Path)path, (FileType[])new FileType[]{FileType.JAR})) {
                return new ArchiveBasedAnalysisInputLocation(path, srcType, bodyInterceptors, ignoredPaths);
            }
            if (PathUtils.hasExtension((Path)path, (FileType[])new FileType[]{FileType.WAR})) {
                try {
                    return new WarArchiveAnalysisInputLocation(path, srcType, bodyInterceptors, ignoredPaths);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new IllegalArgumentException("Path '" + path.toAbsolutePath() + "' has to be pointing to the root of a class container, e.g. directory, jar, zip, apk, war etc.");
    }

    @Nonnull
    protected Stream<JavaSootClassSource> walkDirectory(@Nonnull Path dirPath, @Nonnull IdentifierFactory factory, @Nonnull ClassProvider classProvider) {
        FileType handledFileType = classProvider.getHandledFileType();
        String moduleInfoFilename = "module-info.class";
        try {
            return Files.walk(dirPath, new FileVisitOption[0]).filter(filePath -> PathUtils.hasExtension((Path)filePath, (FileType[])new FileType[]{handledFileType}) && !filePath.toString().endsWith("module-info.class") && this.ignoredPaths.stream().noneMatch(p -> filePath.toString().startsWith(p.toString()))).flatMap(p -> {
                String fullyQualifiedName = this.fromPath(dirPath, (Path)p);
                return StreamUtils.optionalToStream((Optional)classProvider.createClassSource((AnalysisInputLocation)this, p, factory.getClassType(fullyQualifiedName)));
            }).map(src -> (JavaSootClassSource)src);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    protected String fromPath(@Nonnull Path baseDirPath, Path packageNamePathAndClass) {
        return FilenameUtils.removeExtension((String)packageNamePathAndClass.subpath(baseDirPath.getNameCount(), packageNamePathAndClass.getNameCount()).toString().replace(packageNamePathAndClass.getFileSystem().getSeparator(), "."));
    }

    @Nonnull
    protected Optional<JavaSootClassSource> getClassSourceInternal(@Nonnull JavaClassType signature, @Nonnull Path path, @Nonnull ClassProvider classProvider) {
        Path pathToClass = path.resolve(path.getFileSystem().getPath(signature.getFullyQualifiedName().replace('.', '/') + classProvider.getHandledFileType().getExtensionWithDot(), new String[0]));
        if (!Files.exists(pathToClass, new LinkOption[0])) {
            return Optional.empty();
        }
        Optional classSource = classProvider.createClassSource((AnalysisInputLocation)this, pathToClass, (ClassType)signature);
        return classSource.map(src -> (JavaSootClassSource)src);
    }

    protected Optional<JavaSootClassSource> getSingleClass(@Nonnull JavaClassType signature, @Nonnull Path path, @Nonnull ClassProvider classProvider) {
        Path pathToClass = Paths.get(path.toString(), new String[0]);
        Optional classSource = classProvider.createClassSource((AnalysisInputLocation)this, pathToClass, (ClassType)signature);
        return classSource.map(src -> (JavaSootClassSource)src);
    }
}

