/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.inputlocation;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.interceptors.BytecodeBodyInterceptors;
import sootup.java.bytecode.frontend.inputlocation.ArchiveBasedAnalysisInputLocation;
import sootup.java.core.JavaSootClassSource;

public class MultiReleaseJarAnalysisInputLocation
extends ArchiveBasedAnalysisInputLocation {
    protected static final Integer DEFAULT_VERSION = 0;
    @Nonnull
    private final List<BodyInterceptor> bodyInterceptors;
    @Nonnull
    protected final Map<Integer, AnalysisInputLocation> inputLocations = new LinkedHashMap<Integer, AnalysisInputLocation>();
    private final int version;

    public static AnalysisInputLocation create(@Nonnull Path path, @Nonnull SourceType srcType, int version, List<BodyInterceptor> bodyInterceptors) {
        if (MultiReleaseJarAnalysisInputLocation.isMultiReleaseJar(path)) {
            return new MultiReleaseJarAnalysisInputLocation(path, srcType, version, bodyInterceptors, true);
        }
        return MultiReleaseJarAnalysisInputLocation.create(path, srcType, bodyInterceptors, Collections.singletonList(Paths.get("/META-INF", new String[0])));
    }

    public MultiReleaseJarAnalysisInputLocation(@Nonnull Path path, int version) {
        this(path, SourceType.Application, version);
    }

    public MultiReleaseJarAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, int version) {
        this(path, srcType, version, BytecodeBodyInterceptors.Default.getBodyInterceptors());
    }

    public MultiReleaseJarAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, int version, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this(path, srcType, version, bodyInterceptors, MultiReleaseJarAnalysisInputLocation.isMultiReleaseJar(path));
    }

    protected MultiReleaseJarAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, int version, @Nonnull List<BodyInterceptor> bodyInterceptors, boolean isMultiRelease) {
        super(path, srcType);
        FileSystem fs;
        this.version = version;
        this.bodyInterceptors = bodyInterceptors;
        if (!isMultiRelease) {
            throw new IllegalArgumentException("The given path does not point to a multi release jar.");
        }
        try {
            fs = (FileSystem)fileSystemCache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Could not open filesystemcache.", e);
        }
        Path archiveRoot = fs.getPath("/", new String[0]);
        Path versionedRoot = archiveRoot.getFileSystem().getPath("/META-INF/versions/", new String[0]);
        try (Stream<Path> list = Files.list(versionedRoot);){
            list.map(dir -> {
                String versionDirName = dir.getFileName().toString();
                return versionDirName.substring(0, versionDirName.length() - 1);
            }).map(Integer::new).filter(ver -> ver <= version).sorted(Comparator.reverseOrder()).forEach(ver -> {
                Path versionRoot = archiveRoot.getFileSystem().getPath("/META-INF", "versions", ver.toString());
                this.inputLocations.put((Integer)ver, MultiReleaseJarAnalysisInputLocation.create(versionRoot, this.sourceType, bodyInterceptors, Collections.emptyList()));
            });
            this.inputLocations.put(DEFAULT_VERSION, this.createAnalysisInputLocation(archiveRoot, srcType, this.getBodyInterceptors()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not index the given file.", e);
        }
    }

    protected AnalysisInputLocation createAnalysisInputLocation(Path archiveRoot, SourceType sourceType, List<BodyInterceptor> bodyInterceptors) {
        return MultiReleaseJarAnalysisInputLocation.create(archiveRoot, sourceType, bodyInterceptors, Collections.singletonList(Paths.get("/META-INF", new String[0])));
    }

    @Override
    @Nonnull
    public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        for (AnalysisInputLocation analysisInputLocation : this.inputLocations.values()) {
            Optional classSource = analysisInputLocation.getClassSource(type, view);
            if (!classSource.isPresent()) continue;
            SootClassSource src = (SootClassSource)classSource.get();
            JavaSootClassSource javaSootClassSource = (JavaSootClassSource)src;
            return Optional.of(javaSootClassSource);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Stream<JavaSootClassSource> getClassSources(@Nonnull View view) {
        ArrayList classSources = new ArrayList();
        this.inputLocations.values().stream().flatMap(location -> location.getClassSources(view)).map(src -> (JavaSootClassSource)src).forEach(cs -> {
            if (classSources.stream().noneMatch(bestMatchCS -> bestMatchCS.getClassType().getFullyQualifiedName().equals(cs.getClassType().getFullyQualifiedName()))) {
                classSources.add(cs);
            }
        });
        return classSources.stream();
    }

    @Nonnull
    public int getVersion() {
        return this.version;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isMultiReleaseJar(Path path) {
        try (FileInputStream inputStream = new FileInputStream(path.toFile());){
            String value;
            JarInputStream jarStream;
            block17: {
                Manifest mf;
                block16: {
                    boolean bl;
                    jarStream = new JarInputStream(inputStream);
                    try {
                        mf = jarStream.getManifest();
                        if (mf != null) break block16;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        try {
                            jarStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    jarStream.close();
                    return bl;
                }
                Attributes attributes = mf.getMainAttributes();
                value = attributes.getValue("Multi-Release");
                if (value != null) break block17;
                boolean bl = false;
                jarStream.close();
                return bl;
            }
            boolean bl = Boolean.parseBoolean(value);
            jarStream.close();
            return bl;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Manifest file not found.", e);
        }
    }

    @Override
    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.bodyInterceptors;
    }

    protected static List<Integer> getLanguageVersions(@Nonnull Path path) {
        List list;
        block10: {
            FileSystem fs;
            try {
                fs = (FileSystem)fileSystemCache.get((Object)path);
            }
            catch (ExecutionException e) {
                throw new IllegalArgumentException("Could not open filesystemcache.", e);
            }
            Path archiveRoot = fs.getPath("/", new String[0]);
            Path versionedRoot = archiveRoot.getFileSystem().getPath("/META-INF/versions/", new String[0]);
            Stream<Path> list2 = Files.list(versionedRoot);
            try {
                list = list2.map(dir -> {
                    String versionDirName = dir.getFileName().toString();
                    return versionDirName.substring(0, versionDirName.length() - 1);
                }).map(Integer::new).sorted().collect(Collectors.toCollection(ArrayList::new));
                if (list2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (list2 != null) {
                        try {
                            list2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can not index the given file.", e);
                }
            }
            list2.close();
        }
        return list;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiReleaseJarAnalysisInputLocation)) {
            return false;
        }
        return this.path.equals(((MultiReleaseJarAnalysisInputLocation)o).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

