/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.inputlocation;

import com.google.common.base.Preconditions;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.core.IdentifierFactory;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.bytecode.frontend.inputlocation.ModuleFinder;
import sootup.java.core.JavaModuleIdentifierFactory;
import sootup.java.core.JavaModuleInfo;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.ModuleInfoAnalysisInputLocation;
import sootup.java.core.signatures.ModulePackageName;
import sootup.java.core.signatures.ModuleSignature;
import sootup.java.core.types.JavaClassType;

public class JavaModulePathAnalysisInputLocation
implements ModuleInfoAnalysisInputLocation {
    @Nonnull
    private final ModuleFinder moduleFinder;
    @Nonnull
    private final SourceType sourcetype;
    @Nonnull
    private final List<BodyInterceptor> bodyInterceptors;

    public JavaModulePathAnalysisInputLocation(@Nonnull Path modulePath) {
        this(modulePath, SourceType.Application);
    }

    public JavaModulePathAnalysisInputLocation(@Nonnull Path modulePath, @Nonnull SourceType sourcetype) {
        this(modulePath, FileSystems.getDefault(), sourcetype);
    }

    public JavaModulePathAnalysisInputLocation(@Nonnull Path modulePath, @Nonnull FileSystem fileSystem, @Nonnull SourceType sourcetype) {
        this(modulePath, fileSystem, sourcetype, new ArrayList<BodyInterceptor>());
    }

    public JavaModulePathAnalysisInputLocation(@Nonnull Path modulePath, @Nonnull FileSystem fileSystem, @Nonnull SourceType sourcetype, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this.sourcetype = sourcetype;
        this.bodyInterceptors = bodyInterceptors;
        this.moduleFinder = new ModuleFinder(modulePath, fileSystem, sourcetype, bodyInterceptors);
    }

    @Nonnull
    public Optional<JavaModuleInfo> getModuleInfo(ModuleSignature sig, View view) {
        return this.moduleFinder.getModuleInfo(sig);
    }

    @Nonnull
    public Set<ModuleSignature> getModules(View view) {
        return this.moduleFinder.getModules();
    }

    @Nonnull
    public Stream<JavaSootClassSource> getClassSources(@Nonnull View view) {
        IdentifierFactory identifierFactory = view.getIdentifierFactory();
        Preconditions.checkArgument((boolean)(identifierFactory instanceof JavaModuleIdentifierFactory), (Object)"Factory must be a JavaModuleSignatureFactory");
        Collection<ModuleSignature> allModules = this.moduleFinder.getAllModules();
        return allModules.stream().flatMap(sig -> this.getClassSourcesInternal((ModuleSignature)sig, view));
    }

    @Nonnull
    public SourceType getSourceType() {
        return this.sourcetype;
    }

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.bodyInterceptors;
    }

    @Nonnull
    public Stream<JavaSootClassSource> getModulesClassSources(@Nonnull ModuleSignature moduleSignature, @Nonnull View view) {
        IdentifierFactory identifierFactory = view.getIdentifierFactory();
        Preconditions.checkArgument((boolean)(identifierFactory instanceof JavaModuleIdentifierFactory), (Object)"Factory must be a JavaModuleSignatureFactory");
        return this.getClassSourcesInternal(moduleSignature, view);
    }

    protected Stream<JavaSootClassSource> getClassSourcesInternal(@Nonnull ModuleSignature moduleSignature, @Nonnull View view) {
        AnalysisInputLocation inputLocation = this.moduleFinder.getModule(moduleSignature);
        if (inputLocation == null) {
            return Stream.empty();
        }
        return inputLocation.getClassSources(view).map(src -> (JavaSootClassSource)src);
    }

    @Nonnull
    public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType classType, @Nonnull View view) {
        JavaClassType klassType = (JavaClassType)classType;
        ModuleSignature modulename = ((ModulePackageName)klassType.getPackageName()).getModuleSignature();
        AnalysisInputLocation inputLocation = this.moduleFinder.getModule(modulename);
        if (inputLocation == null) {
            return Optional.empty();
        }
        return inputLocation.getClassSource((ClassType)klassType, view).map(src -> (JavaSootClassSource)src);
    }

    public int hashCode() {
        return this.moduleFinder.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaModulePathAnalysisInputLocation)) {
            return false;
        }
        return this.moduleFinder.equals(((JavaModulePathAnalysisInputLocation)o).moduleFinder);
    }
}

