/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.conversion;

import com.google.common.collect.Streams;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import sootup.core.IdentifierFactory;
import sootup.core.frontend.BodySource;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.model.ClassModifier;
import sootup.core.model.FieldModifier;
import sootup.core.model.Position;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.core.util.Modifiers;
import sootup.java.bytecode.frontend.conversion.AsmMethodSource;
import sootup.java.bytecode.frontend.conversion.AsmUtil;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.JavaSootField;
import sootup.java.core.JavaSootMethod;
import sootup.java.core.types.JavaClassType;

class AsmClassSource
extends JavaSootClassSource {
    @Nonnull
    private final ClassNode classNode;

    public AsmClassSource(AnalysisInputLocation inputLocation, Path sourcePath, JavaClassType javaClassType, @Nonnull ClassNode classNode) {
        super(inputLocation, (ClassType)javaClassType, sourcePath);
        this.classNode = classNode;
    }

    private static Set<JavaSootField> resolveFields(List<FieldNode> fieldNodes, IdentifierFactory signatureFactory, ClassType classSignature) {
        return fieldNodes.stream().map(fieldNode -> {
            String fieldName = fieldNode.name;
            Type fieldType = AsmUtil.toJimpleType(fieldNode.desc);
            FieldSignature fieldSignature = signatureFactory.getFieldSignature(fieldName, classSignature, fieldType);
            EnumSet<FieldModifier> modifiers = AsmUtil.getFieldModifiers(fieldNode.access);
            return new JavaSootField(fieldSignature, modifiers, (Iterable)Streams.concat((Stream[])new Stream[]{AsmClassSource.convertAnnotation(fieldNode.visibleAnnotations), AsmClassSource.convertAnnotation(fieldNode.invisibleAnnotations)}).collect(Collectors.toList()), (Position)NoPositionInformation.getInstance());
        }).collect(Collectors.toSet());
    }

    protected static Stream<AnnotationUsage> convertAnnotation(List<? extends AnnotationNode> nodes) {
        if (nodes == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(AsmUtil.createAnnotationUsage(nodes).spliterator(), false);
    }

    protected Iterable<AnnotationUsage> resolveAnnotations() {
        Stream annotations = Streams.concat((Stream[])new Stream[]{AsmClassSource.convertAnnotation(this.classNode.visibleAnnotations), AsmClassSource.convertAnnotation(this.classNode.invisibleAnnotations), AsmClassSource.convertAnnotation(this.classNode.visibleTypeAnnotations), AsmClassSource.convertAnnotation(this.classNode.invisibleTypeAnnotations)});
        return annotations.collect(Collectors.toList());
    }

    @Nonnull
    public Collection<JavaSootMethod> resolveMethods() throws ResolveException {
        JavaIdentifierFactory identifierFactory = JavaIdentifierFactory.getInstance();
        return this.classNode.methods.stream().map(arg_0 -> this.lambda$resolveMethods$1((IdentifierFactory)identifierFactory, arg_0)).collect(Collectors.toSet());
    }

    @Nonnull
    public Collection<JavaSootField> resolveFields() throws ResolveException {
        JavaIdentifierFactory identifierFactory = JavaIdentifierFactory.getInstance();
        return AsmClassSource.resolveFields(this.classNode.fields, (IdentifierFactory)identifierFactory, this.classSignature);
    }

    @Nonnull
    public EnumSet<ClassModifier> resolveModifiers() {
        return Modifiers.getClassModifiers((int)this.classNode.access);
    }

    @Nonnull
    public Set<JavaClassType> resolveInterfaces() {
        return new HashSet<JavaClassType>(AsmUtil.asmIdToSignature(this.classNode.interfaces));
    }

    @Nonnull
    public Optional<JavaClassType> resolveSuperclass() {
        if (this.classNode.superName == null) {
            return Optional.empty();
        }
        return Optional.of(AsmUtil.toJimpleClassType(this.classNode.superName));
    }

    @Nonnull
    public Optional<JavaClassType> resolveOuterClass() {
        if (this.classNode.outerClass == null) {
            return Optional.empty();
        }
        return Optional.of(AsmUtil.toJimpleClassType(this.classNode.outerClass));
    }

    @Nonnull
    public Position resolvePosition() {
        return NoPositionInformation.getInstance();
    }

    public String toString() {
        return this.getSourcePath().toString();
    }

    private /* synthetic */ JavaSootMethod lambda$resolveMethods$1(IdentifierFactory identifierFactory, MethodNode methodSource) {
        AsmMethodSource asmClassClassSourceContent = (AsmMethodSource)methodSource;
        asmClassClassSourceContent.setDeclaringClass(this.classSignature);
        ArrayList<JavaClassType> exceptions = new ArrayList<JavaClassType>(AsmUtil.asmIdToSignature(methodSource.exceptions));
        String methodName = methodSource.name;
        EnumSet modifiers = Modifiers.getMethodModifiers((int)methodSource.access);
        List<Type> sigTypes = AsmUtil.toJimpleSignatureDesc(methodSource.desc);
        Type retType = sigTypes.remove(sigTypes.size() - 1);
        MethodSignature methodSignature = identifierFactory.getMethodSignature(this.classSignature, methodName, retType, sigTypes);
        return new JavaSootMethod((BodySource)asmClassClassSourceContent, methodSignature, (Iterable)modifiers, exceptions, (Iterable)Streams.concat((Stream[])new Stream[]{AsmClassSource.convertAnnotation(methodSource.visibleAnnotations), AsmClassSource.convertAnnotation(methodSource.invisibleAnnotations)}).collect(Collectors.toList()), (Position)NoPositionInformation.getInstance());
    }
}

