/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors.typeresolving;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.stmt.FallsThroughStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.Visitor;
import sootup.core.model.Body;
import sootup.core.types.Type;
import sootup.interceptors.typeresolving.AugEvalFunction;
import sootup.interceptors.typeresolving.BytecodeHierarchy;
import sootup.interceptors.typeresolving.TypeChecker;
import sootup.interceptors.typeresolving.Typing;

public class CastCounter
extends TypeChecker {
    private final Map<Stmt, Set<JAssignStmt>> tempAssignments = new HashMap<Stmt, Set<JAssignStmt>>();
    private final Map<Stmt, Stmt> stmt2NewStmt = new HashMap<Stmt, Stmt>();
    private final Map<Local, Type> tempLocalTypes = new HashMap<Local, Type>();
    private int castCount = 0;
    private int newLocalsCount = 0;

    public CastCounter(@Nonnull Body.BodyBuilder builder, @Nonnull AugEvalFunction evalFunction, @Nonnull BytecodeHierarchy hierarchy, @Nonnull Typing typing) {
        super(builder, evalFunction, hierarchy);
        this.setTyping(typing);
        for (Stmt stmt : this.graph.getNodes()) {
            stmt.accept((Visitor)this);
        }
    }

    public int getCastCount() {
        return this.castCount;
    }

    public void insertCastStmts() {
        for (Map.Entry<Local, Type> entry : this.tempLocalTypes.entrySet()) {
            this.builder.addLocal(entry.getKey());
            this.getTyping().set(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.tempAssignments.entrySet()) {
            for (JAssignStmt cast : (Set)entry.getValue()) {
                this.graph.insertBefore((Stmt)entry.getKey(), (FallsThroughStmt)cast);
            }
        }
        for (Map.Entry<Object, Object> entry : this.stmt2NewStmt.entrySet()) {
            this.graph.replaceNode((Stmt)entry.getKey(), (Stmt)entry.getValue());
        }
    }

    @Override
    public void visit(@Nonnull Value value, @Nonnull Type stdType, @Nonnull Stmt stmt) {
        if (!(value instanceof Immediate)) {
            return;
        }
        if (stmt.getUses().noneMatch(v -> v == value)) {
            return;
        }
        Stmt currentStmt = this.stmt2NewStmt.getOrDefault(stmt, stmt);
        Type evaType = this.getFuntion().evaluate(this.getTyping(), value, currentStmt, (StmtGraph<?>)this.graph);
        if (evaType == null || this.getHierarchy().isAncestor(stdType, evaType)) {
            return;
        }
        JCastExpr cast = Jimple.newCastExpr((Immediate)((Immediate)value), (Type)stdType);
        Stmt newStmt = currentStmt.withNewUse(value, (Value)cast);
        if (newStmt == null || newStmt == currentStmt) {
            Local tempLocal = this.generateTempLocal(stdType);
            this.tempLocalTypes.put(tempLocal, stdType);
            JAssignStmt assignStmt = Jimple.newAssignStmt((LValue)tempLocal, (Value)cast, (StmtPositionInfo)stmt.getPositionInfo());
            this.tempAssignments.computeIfAbsent(stmt, _x -> new HashSet()).add(assignStmt);
            newStmt = currentStmt.withNewUse(value, (Value)tempLocal);
        }
        if (currentStmt == newStmt) {
            return;
        }
        ++this.castCount;
        this.stmt2NewStmt.put(stmt, newStmt);
    }

    private Local generateTempLocal(@Nonnull Type type) {
        String name = "#l" + this.newLocalsCount++;
        return Jimple.newLocal((String)name, (Type)type);
    }
}

