/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.DominanceFinder;
import sootup.core.graph.DominanceTree;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.JPhiExpr;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.FallsThroughStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.views.View;

public class StaticSingleAssignmentFormer
implements BodyInterceptor {
    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        LinkedHashSet<Local> newLocals = new LinkedHashSet<Local>(builder.getLocals());
        int nextFreeIdx = 0;
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        HashMap blockToDefs = new HashMap();
        HashMap localToBlocks = new HashMap();
        for (BasicBlock block : stmtGraph.getBlocks()) {
            HashSet<Local> defs = new HashSet<Local>();
            for (Object stmt : block.getStmts()) {
                Optional defOpt = stmt.getDef();
                if (!defOpt.isPresent() || !(defOpt.get() instanceof Local)) continue;
                Local local = (Local)defOpt.get();
                defs.add(local);
                if (localToBlocks.containsKey(local)) {
                    ((Set)localToBlocks.get(local)).add(block);
                    continue;
                }
                HashSet<BasicBlock> bs = new HashSet<BasicBlock>();
                bs.add(block);
                localToBlocks.put(local, bs);
            }
            blockToDefs.put(block, defs);
        }
        DominanceFinder dominanceFinder = new DominanceFinder((StmtGraph)stmtGraph);
        Map<BasicBlock<?>, Set<FallsThroughStmt>> blockToPhiStmts = this.decideBlockToPhiStmts(builder, dominanceFinder, blockToDefs, localToBlocks);
        this.addPhiStmts(blockToPhiStmts, stmtGraph, blockToDefs);
        DominanceTree tree = new DominanceTree(new DominanceFinder((StmtGraph)stmtGraph));
        HashMap localToNameStack = new HashMap();
        for (Local local : builder.getLocals()) {
            localToNameStack.put(local, new Stack());
        }
        List treeNodes = tree.getAllNodesDFS();
        ArrayList<BasicBlock> blockStack = new ArrayList<BasicBlock>();
        HashSet visited = new HashSet();
        block3: for (BasicBlock block : treeNodes) {
            Object stmt22;
            HashSet<Object> newPhiStmts = new HashSet();
            for (Object stmt22 : block.getStmts()) {
                Optional defOpt;
                Stmt newStmt;
                List uses = stmt22.getUses().collect(Collectors.toList());
                if (!uses.isEmpty() && !this.containsPhiExpr((Stmt)stmt22)) {
                    for (Value use : uses) {
                        if (!(use instanceof Local)) continue;
                        Local local = (Local)((Stack)localToNameStack.get(use)).peek();
                        newStmt = stmt22.withNewUse(use, (Value)local);
                        stmtGraph.replaceNode((Stmt)stmt22, newStmt);
                        stmt22 = newStmt;
                    }
                }
                if (!(defOpt = stmt22.getDef()).isPresent() || !(defOpt.get() instanceof Local)) continue;
                Local def = (Local)defOpt.get();
                Local local = def.withName(def.getName() + "#" + nextFreeIdx);
                newLocals.add(local);
                ++nextFreeIdx;
                ((Stack)localToNameStack.get(def)).push(local);
                newStmt = ((AbstractDefinitionStmt)stmt22).withNewDef(local);
                stmtGraph.replaceNode((Stmt)stmt22, newStmt);
                if (!this.containsPhiExpr(newStmt)) continue;
                newPhiStmts.add(newStmt);
            }
            visited.add(block);
            blockStack.add(block);
            if (blockToPhiStmts.containsKey(block)) {
                blockToPhiStmts.put(block, newPhiStmts);
            }
            ArrayList succs = new ArrayList(block.getSuccessors());
            succs.addAll(block.getExceptionalSuccessors().values());
            stmt22 = succs.iterator();
            while (stmt22.hasNext()) {
                BasicBlock succ = (BasicBlock)stmt22.next();
                if (!blockToPhiStmts.containsKey(succ)) continue;
                Set<FallsThroughStmt> phiStmts = blockToPhiStmts.get(succ);
                newPhiStmts = new HashSet<FallsThroughStmt>(phiStmts);
                for (Stmt stmt : phiStmts) {
                    Local def = (Local)stmt.getDef().get();
                    Local oriDef = this.getOriginalLocal(def, localToNameStack.keySet());
                    if (((Stack)localToNameStack.get(oriDef)).isEmpty()) continue;
                    Local arg = (Local)((Stack)localToNameStack.get(oriDef)).peek();
                    FallsThroughStmt newPhiStmt = this.addNewArgToPhi(stmt, arg, block);
                    newPhiStmts.remove(stmt);
                    newPhiStmts.add(newPhiStmt);
                    stmtGraph.replaceNode(stmt, (Stmt)newPhiStmt);
                }
                blockToPhiStmts.put(succ, newPhiStmts);
            }
            BasicBlock top = (BasicBlock)blockStack.get(blockStack.size() - 1);
            List children = tree.getChildren(top);
            while (this.containsAllChildren(visited, children)) {
                blockStack.remove(blockStack.size() - 1);
                for (Stmt stmt3 : top.getStmts()) {
                    Local local;
                    Local oriDef;
                    if (!stmt3.getDef().isPresent() || !(stmt3.getDef().get() instanceof Local) || ((Stack)localToNameStack.get(oriDef = this.getOriginalLocal(local = (Local)stmt3.getDef().get(), localToNameStack.keySet()))).isEmpty()) continue;
                    ((Stack)localToNameStack.get(oriDef)).pop();
                }
                if (blockStack.isEmpty()) continue block3;
                top = (BasicBlock)blockStack.get(blockStack.size() - 1);
                children = tree.getChildren(top);
            }
        }
        builder.setLocals(newLocals);
    }

    private Map<BasicBlock<?>, Set<FallsThroughStmt>> decideBlockToPhiStmts(Body.BodyBuilder builder, DominanceFinder dominanceFinder, Map<BasicBlock<?>, Set<Local>> blockToDefs, Map<Local, Set<BasicBlock<?>>> localToBlocks) {
        HashMap blockToPhiStmts = new HashMap();
        HashMap blockToPhiLocals = new HashMap();
        HashMap localToPhiBlocks = new HashMap();
        for (Local local : builder.getLocals()) {
            localToPhiBlocks.put(local, new HashSet());
            ArrayDeque<BasicBlock> blocks = new ArrayDeque<BasicBlock>((Collection)localToBlocks.get(local));
            while (!blocks.isEmpty()) {
                BasicBlock block = (BasicBlock)blocks.removeFirst();
                Set dfs = dominanceFinder.getDominanceFrontiers(block);
                for (BasicBlock df : dfs) {
                    Set basicBlocks = (Set)localToPhiBlocks.get(local);
                    if (basicBlocks.contains(df)) continue;
                    basicBlocks.add(df);
                    JAssignStmt phiStmt = this.createEmptyPhiStmt(local);
                    if (!blockToPhiStmts.containsKey(df)) {
                        LinkedHashSet phiStmts = new LinkedHashSet();
                        blockToPhiStmts.put(df, phiStmts);
                        HashSet phiLocals = new HashSet();
                        blockToPhiLocals.put(df, phiLocals);
                    }
                    ((Set)blockToPhiStmts.get(df)).add(phiStmt);
                    ((Set)blockToPhiLocals.get(df)).add(local);
                    if (blockToDefs.get(df).contains(local)) continue;
                    blocks.add(df);
                }
            }
        }
        for (BasicBlock block : blockToPhiLocals.keySet()) {
            blockToDefs.get(block).addAll((Collection)blockToPhiLocals.get(block));
        }
        return blockToPhiStmts;
    }

    private void addPhiStmts(Map<BasicBlock<?>, Set<FallsThroughStmt>> blockToPhiStmts, MutableStmtGraph blockGraph, Map<BasicBlock<?>, Set<Local>> blockToDefs) {
        Set<FallsThroughStmt> phis;
        HashMap<Stmt, Integer> phiToNum = new HashMap<Stmt, Integer>();
        for (BasicBlock block : blockGraph.getBlocks()) {
            ArrayList succs = new ArrayList(block.getSuccessors());
            succs.addAll(block.getExceptionalSuccessors().values());
            for (BasicBlock succ : succs) {
                if (!blockToPhiStmts.containsKey(succ)) continue;
                for (Stmt stmt : blockToPhiStmts.get(succ)) {
                    Local local = (Local)stmt.getDef().get();
                    if (!blockToDefs.get(block).contains(local)) continue;
                    if (phiToNum.containsKey(stmt)) {
                        int num = (Integer)phiToNum.get(stmt);
                        phiToNum.replace(stmt, num + 1);
                        continue;
                    }
                    phiToNum.put(stmt, 1);
                }
            }
        }
        HashMap old2UpdatedBlock = new HashMap();
        for (BasicBlock<?> block : blockToPhiStmts.keySet()) {
            phis = blockToPhiStmts.get(block);
            HashSet checkedPhis = new HashSet(blockToPhiStmts.get(block));
            for (FallsThroughStmt fallsThroughStmt : checkedPhis) {
                if (phiToNum.containsKey(fallsThroughStmt) && (Integer)phiToNum.get(fallsThroughStmt) >= 2) continue;
                phis.remove(fallsThroughStmt);
            }
            for (FallsThroughStmt fallsThroughStmt : phis) {
                BasicBlock updatedBlock = blockGraph.insertBefore(block.getHead(), fallsThroughStmt);
                if (updatedBlock.equals(block)) continue;
                old2UpdatedBlock.put(block, updatedBlock);
            }
        }
        if (!old2UpdatedBlock.isEmpty()) {
            for (BasicBlock oldB : old2UpdatedBlock.keySet()) {
                phis = blockToPhiStmts.get(oldB);
                blockToPhiStmts.remove(oldB);
                blockToPhiStmts.put((BasicBlock)old2UpdatedBlock.get(oldB), phis);
            }
        }
    }

    private boolean containsAllChildren(Set<BasicBlock<?>> blockSet, List<BasicBlock<?>> children) {
        for (BasicBlock<?> child : children) {
            if (blockSet.contains(child)) continue;
            return false;
        }
        return true;
    }

    private boolean containsPhiExpr(Stmt stmt) {
        if (stmt instanceof JAssignStmt) {
            Iterator iterator = stmt.getUses().iterator();
            while (iterator.hasNext()) {
                Value use = (Value)iterator.next();
                if (!(use instanceof JPhiExpr)) continue;
                return true;
            }
        }
        return false;
    }

    private JAssignStmt createEmptyPhiStmt(Local local) {
        JPhiExpr phi = new JPhiExpr(Collections.emptyList(), Collections.emptyMap());
        return new JAssignStmt((LValue)local, (Value)phi, StmtPositionInfo.getNoStmtPositionInfo());
    }

    private Local getOriginalLocal(Local local, Set<Local> oriLocals) {
        if (oriLocals.contains(local)) {
            return local;
        }
        int hashPos = local.getName().indexOf(35);
        String oriName = local.getName().substring(0, hashPos);
        for (Local oriLocal : oriLocals) {
            if (!oriLocal.getName().equals(oriName)) continue;
            return oriLocal;
        }
        throw new RuntimeException(local + " has no original local!");
    }

    private FallsThroughStmt addNewArgToPhi(Stmt phiStmt, Local arg, BasicBlock<?> block) {
        JAssignStmt newPhiStmt = null;
        Iterator iterator = phiStmt.getUses().iterator();
        while (iterator.hasNext()) {
            Value use = (Value)iterator.next();
            if (!(use instanceof JPhiExpr)) continue;
            JPhiExpr newPhiExpr = (JPhiExpr)use;
            List args = ((JPhiExpr)use).getArgs();
            Map argToBlock = ((JPhiExpr)use).getArgToBlockMap();
            args.add(arg);
            argToBlock.put(arg, block);
            newPhiExpr = newPhiExpr.withArgs(args);
            newPhiExpr = newPhiExpr.withArgToBlockMap(argToBlock);
            newPhiStmt = ((JAssignStmt)phiStmt).withRValue((Value)newPhiExpr);
            break;
        }
        return newPhiStmt;
    }
}

