/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.validation.ValidationException;
import sootup.core.views.View;

public abstract class JimpleSemanticsChecker
implements BodyInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(JimpleSemanticsChecker.class);

    protected List<ValidationException> validate(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        throw new UnsupportedOperationException("List of Validators is not incorporated yet.");
    }

    public abstract void interceptBody(@Nonnull Body.BodyBuilder var1, @Nonnull View var2);

    public static class ThrowingJimpleChecker
    extends LoggingJimpleChecker {
        @Override
        public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
            super.interceptBody(builder, view);
            throw new IllegalStateException("There are semantic errors in the Jimple - see warn log.");
        }
    }

    public static class LoggingJimpleChecker
    extends JimpleSemanticsChecker {
        @Override
        public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
            List<ValidationException> exceptions = this.validate(builder, view);
            for (ValidationException validationException : exceptions) {
                logger.warn(validationException.getMessage());
            }
        }
    }
}

