/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.constant.NumericConstant;
import sootup.core.jimple.common.constant.StringConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.views.View;
import sootup.interceptors.Evaluator;

public class ConstantPropagatorAndFolder
implements BodyInterceptor {
    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        ArrayList<Object> defs = new ArrayList<Object>();
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        for (Stmt stmt : Lists.newArrayList((Iterable)stmtGraph)) {
            if (stmt instanceof JAssignStmt) {
                Value rhs = ((AbstractDefinitionStmt)stmt).getRightOp();
                if (rhs instanceof AbstractBinopExpr) {
                    Immediate op1 = ((AbstractBinopExpr)rhs).getOp1();
                    Immediate op2 = ((AbstractBinopExpr)rhs).getOp2();
                    if (op1 instanceof NumericConstant && op2 instanceof NumericConstant) {
                        defs.add(stmt);
                    }
                }
                BiConsumer<Constant, Stmt> constantStmtBiConsumer = (evaluatedValue, foldingStmt) -> {
                    JAssignStmt assignStmt = ((JAssignStmt)foldingStmt).withRValue((Value)evaluatedValue);
                    stmtGraph.replaceNode(foldingStmt, (Stmt)assignStmt);
                    defs.remove(foldingStmt);
                    defs.add(assignStmt);
                };
                ConstantPropagatorAndFolder.fold(stmt, constantStmtBiConsumer);
                continue;
            }
            if (!(stmt instanceof JReturnStmt)) continue;
            Iterator iterator = stmt.getUses().iterator();
            while (iterator.hasNext()) {
                AbstractDefinitionStmt definitionStmt;
                Value rhs;
                List defsOfUse;
                Value value = (Value)iterator.next();
                if (!(value instanceof Local) || (defsOfUse = ((Local)value).getDefs(defs)).size() != 1 || !((rhs = (definitionStmt = (AbstractDefinitionStmt)defsOfUse.get(0)).getRightOp()) instanceof NumericConstant) && !(rhs instanceof StringConstant) && !(rhs instanceof NullConstant)) continue;
                JReturnStmt returnStmt = ((JReturnStmt)stmt).withReturnValue((Immediate)rhs);
                stmtGraph.replaceNode(stmt, (Stmt)returnStmt);
                stmt = returnStmt;
                defs.add(returnStmt);
            }
            BiConsumer<Constant, Stmt> constantStmtBiConsumer = (evaluatedValue, foldingStmt) -> {
                JReturnStmt returnStmt = ((JReturnStmt)foldingStmt).withReturnValue((Immediate)evaluatedValue);
                stmtGraph.replaceNode(foldingStmt, (Stmt)returnStmt);
            };
            ConstantPropagatorAndFolder.fold(stmt, constantStmtBiConsumer);
        }
    }

    private static void fold(Stmt stmt, BiConsumer<Constant, Stmt> constantStmtBiConsumer) {
        Iterator iterator = stmt.getUses().iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            Constant evaluatedValue = Evaluator.getConstantValueOf(value);
            if (evaluatedValue == null || evaluatedValue == value) continue;
            constantStmtBiConsumer.accept(evaluatedValue, stmt);
        }
    }
}

