/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import com.google.common.collect.Lists;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.stmt.FallsThroughStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.Type;
import sootup.core.views.View;

public class CastAndReturnInliner
implements BodyInterceptor {
    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph graph = builder.getStmtGraph();
        Set locals = builder.getLocals();
        for (Stmt stmt : Lists.newArrayList((Iterable)graph.getNodes())) {
            Local localCandidate;
            JReturnStmt retStmt;
            Stmt nextStmt;
            JAssignStmt assign;
            JGotoStmt gotoStmt;
            Stmt successorOfGoto;
            if (!(stmt instanceof JGotoStmt) || !((successorOfGoto = (Stmt)graph.successors((Stmt)(gotoStmt = (JGotoStmt)stmt)).get(0)) instanceof JAssignStmt) || !((assign = (JAssignStmt)successorOfGoto).getRightOp() instanceof JCastExpr) || !((nextStmt = (Stmt)graph.successors((Stmt)assign).get(0)) instanceof JReturnStmt) || (retStmt = (JReturnStmt)nextStmt).getOp() != assign.getLeftOp()) continue;
            JCastExpr ce = (JCastExpr)assign.getRightOp();
            int i = 0;
            while (locals.contains(localCandidate = Jimple.newLocal((String)(ce.getOp() + "_ret" + i++), (Type)ce.getType()))) {
            }
            JAssignStmt newAssignStmt = Jimple.newAssignStmt((LValue)localCandidate, (Value)ce, (StmtPositionInfo)assign.getPositionInfo());
            JReturnStmt newReturnStmt = retStmt.withReturnValue((Immediate)localCandidate);
            graph.replaceNode((Stmt)gotoStmt, (Stmt)newReturnStmt);
            graph.insertBefore((Stmt)newReturnStmt, (FallsThroughStmt)newAssignStmt);
            builder.addLocal(localCandidate);
            boolean removeExistingCastReturn = graph.predecessors((Stmt)assign).isEmpty();
            if (!removeExistingCastReturn) continue;
            graph.removeNode((Stmt)assign, false);
            if (!graph.predecessors((Stmt)retStmt).isEmpty()) continue;
            graph.removeNode((Stmt)retStmt, false);
            builder.removeDefLocalsOf((Stmt)assign);
        }
    }
}

