/*
 * Decompiled with CFR 0.152.
 */
package sootup.codepropertygraph.propertygraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sootup.codepropertygraph.propertygraph.PropertyGraph;
import sootup.codepropertygraph.propertygraph.edges.PropertyGraphEdge;
import sootup.codepropertygraph.propertygraph.nodes.PropertyGraphNode;
import sootup.codepropertygraph.propertygraph.util.PropertyGraphToDotConverter;

public final class AstPropertyGraph
implements PropertyGraph {
    private final String name;
    private final List<PropertyGraphNode> nodes;
    private final List<PropertyGraphEdge> edges;

    private AstPropertyGraph(String name, List<PropertyGraphNode> nodes, List<PropertyGraphEdge> edges) {
        this.name = name;
        this.nodes = Collections.unmodifiableList(nodes);
        this.edges = Collections.unmodifiableList(edges);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<PropertyGraphNode> getNodes() {
        return this.nodes;
    }

    @Override
    public List<PropertyGraphEdge> getEdges() {
        return this.edges;
    }

    @Override
    public String toDotGraph() {
        return PropertyGraphToDotConverter.convert(this);
    }

    public static class Builder
    implements PropertyGraph.Builder {
        private final List<PropertyGraphNode> nodes = new ArrayList<PropertyGraphNode>();
        private final List<PropertyGraphEdge> edges = new ArrayList<PropertyGraphEdge>();
        private String name;

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder addNode(PropertyGraphNode node) {
            if (!this.nodes.contains(node)) {
                this.nodes.add(node);
            }
            return this;
        }

        @Override
        public Builder addEdge(PropertyGraphEdge edge) {
            this.addNode(edge.getSource());
            this.addNode(edge.getDestination());
            if (!this.edges.contains(edge)) {
                this.edges.add(edge);
            }
            return this;
        }

        @Override
        public PropertyGraph build() {
            return new AstPropertyGraph(this.name, this.nodes, this.edges);
        }
    }
}

