/*
 * Decompiled with CFR 0.152.
 */
package sootup.codepropertygraph.ddg;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import sootup.analysis.intraprocedural.reachingdefs.ReachingDefs;
import sootup.codepropertygraph.propertygraph.PropertyGraph;
import sootup.codepropertygraph.propertygraph.StmtMethodPropertyGraph;
import sootup.codepropertygraph.propertygraph.edges.DdgEdge;
import sootup.codepropertygraph.propertygraph.nodes.StmtGraphNode;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;

public class DdgCreator {
    public PropertyGraph createGraph(SootMethod method) {
        StmtMethodPropertyGraph.Builder graphBuilder = new StmtMethodPropertyGraph.Builder();
        graphBuilder.setName("ddg_" + method.getName());
        if (method.isAbstract() || method.isNative()) {
            return graphBuilder.build();
        }
        StmtGraph stmtGraph = method.getBody().getStmtGraph();
        Map reachingDefs = new ReachingDefs(stmtGraph).getReachingDefs();
        Comparator<Stmt> stmtComparator = Comparator.comparing(Stmt::toString);
        reachingDefs.keySet().stream().sorted(stmtComparator).forEach(key -> {
            StmtGraphNode destinationNode = new StmtGraphNode((Stmt)key);
            List values = (List)reachingDefs.get(key);
            values.stream().sorted(stmtComparator).forEach(value -> {
                StmtGraphNode sourceNode = new StmtGraphNode((Stmt)value);
                graphBuilder.addEdge(new DdgEdge(sourceNode, destinationNode));
            });
        });
        return graphBuilder.build();
    }
}

