/*
 * Decompiled with CFR 0.152.
 */
package sootup.codepropertygraph.ast;

import java.util.List;
import java.util.Set;
import sootup.codepropertygraph.ast.AstStmtVisitor;
import sootup.codepropertygraph.propertygraph.AstPropertyGraph;
import sootup.codepropertygraph.propertygraph.PropertyGraph;
import sootup.codepropertygraph.propertygraph.edges.ModifierAstEdge;
import sootup.codepropertygraph.propertygraph.edges.ParameterAstEdge;
import sootup.codepropertygraph.propertygraph.edges.ReturnTypeAstEdge;
import sootup.codepropertygraph.propertygraph.edges.StmtAstEdge;
import sootup.codepropertygraph.propertygraph.nodes.AggregateGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.MethodGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.ModifierGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.PropertyGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.TypeGraphNode;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.Visitor;
import sootup.core.model.MethodModifier;
import sootup.core.model.SootMethod;
import sootup.core.types.Type;

public class AstCreator {
    private static void addModifierEdges(PropertyGraph.Builder graphBuilder, PropertyGraphNode parentNode, Set<MethodModifier> modifiers) {
        for (MethodModifier modifier : modifiers) {
            graphBuilder.addEdge(new ModifierAstEdge(parentNode, new ModifierGraphNode(modifier)));
        }
    }

    private static void addParameterTypeEdges(PropertyGraph.Builder graphBuilder, PropertyGraphNode parentNode, List<Type> parameterTypes) {
        for (Type parameterType : parameterTypes) {
            graphBuilder.addEdge(new ParameterAstEdge(parentNode, new TypeGraphNode(parameterType)));
        }
    }

    private static void addBodyStmtEdges(PropertyGraph.Builder graphBuilder, PropertyGraphNode parentNode, List<Stmt> bodyStmts) {
        for (Stmt stmt : bodyStmts) {
            AstStmtVisitor visitor = new AstStmtVisitor(graphBuilder, parentNode);
            stmt.accept((Visitor)visitor);
        }
    }

    private static void addReturnStmtEdge(PropertyGraph.Builder graphBuilder, PropertyGraphNode parentNode, Type returnType) {
        graphBuilder.addEdge(new ReturnTypeAstEdge(parentNode, new TypeGraphNode(returnType)));
    }

    public PropertyGraph createGraph(SootMethod method) {
        AstPropertyGraph.Builder graphBuilder = new AstPropertyGraph.Builder();
        graphBuilder.setName("ast_" + method.getName());
        if (method.isAbstract() || method.isNative()) {
            return graphBuilder.build();
        }
        MethodGraphNode rootNode = new MethodGraphNode(method);
        AggregateGraphNode modifiersNode = new AggregateGraphNode("Modifiers");
        AggregateGraphNode parametersTypesNode = new AggregateGraphNode("Parameters");
        AggregateGraphNode bodyStmtsNode = new AggregateGraphNode("Body");
        graphBuilder.addEdge(new ModifierAstEdge(rootNode, modifiersNode));
        graphBuilder.addEdge(new ParameterAstEdge(rootNode, parametersTypesNode));
        graphBuilder.addEdge(new StmtAstEdge(rootNode, bodyStmtsNode));
        AstCreator.addModifierEdges(graphBuilder, modifiersNode, method.getModifiers());
        AstCreator.addParameterTypeEdges(graphBuilder, parametersTypesNode, method.getParameterTypes());
        AstCreator.addBodyStmtEdges(graphBuilder, bodyStmtsNode, method.getBody().getStmts());
        AstCreator.addReturnStmtEdge(graphBuilder, rootNode, method.getReturnType());
        return graphBuilder.build();
    }
}

