/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.callgraph.AbstractCallGraphAlgorithm;
import sootup.callgraph.CallGraph;
import sootup.callgraph.MutableCallGraph;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.stmt.InvokableStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.model.MethodModifier;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public class RapidTypeAnalysisAlgorithm
extends AbstractCallGraphAlgorithm {
    @Nonnull
    protected Set<ClassType> instantiatedClasses = Collections.emptySet();
    @Nonnull
    protected ArrayListMultimap<ClassType, CallGraph.Call> ignoredCalls = ArrayListMultimap.create();

    public RapidTypeAnalysisAlgorithm(@Nonnull View view) {
        super(view);
    }

    @Override
    @Nonnull
    public CallGraph initialize() {
        List<MethodSignature> entryPoints = Collections.singletonList(this.findMainMethod());
        return this.initialize(entryPoints);
    }

    @Override
    @Nonnull
    public CallGraph initialize(@Nonnull List<MethodSignature> entryPoints) {
        this.instantiatedClasses = new HashSet<ClassType>();
        this.ignoredCalls = ArrayListMultimap.create();
        CallGraph cg = this.constructCompleteCallGraph(entryPoints);
        this.instantiatedClasses = Collections.emptySet();
        this.ignoredCalls = ArrayListMultimap.create();
        return cg;
    }

    protected List<ClassType> collectInstantiatedClassesInMethod(SootMethod method) {
        if (method == null || method.isAbstract() || method.isNative()) {
            return Collections.emptyList();
        }
        Set instantiated = method.getBody().getStmts().stream().filter(stmt -> stmt instanceof JAssignStmt).map(stmt -> ((JAssignStmt)stmt).getRightOp()).filter(value -> value instanceof JNewExpr).map(value -> ((JNewExpr)value).getType()).collect(Collectors.toSet());
        List<ClassType> newInstantiatedClassTypes = instantiated.stream().filter(classType -> !this.instantiatedClasses.contains(classType)).collect(Collectors.toList());
        this.instantiatedClasses.addAll(instantiated);
        return newInstantiatedClassTypes;
    }

    @Override
    @Nonnull
    protected Stream<MethodSignature> resolveCall(SootMethod sourceMethod, InvokableStmt invokableStmt) {
        Optional optInvokeExpr = invokableStmt.getInvokeExpr();
        if (!optInvokeExpr.isPresent()) {
            return Stream.empty();
        }
        AbstractInvokeExpr invokeExpr = (AbstractInvokeExpr)optInvokeExpr.get();
        MethodSignature resolveBaseMethodSignature = invokeExpr.getMethodSignature();
        Stream<MethodSignature> result = Stream.of(resolveBaseMethodSignature);
        SootMethod concreteBaseMethod = RapidTypeAnalysisAlgorithm.findConcreteMethod(this.view, resolveBaseMethodSignature).orElse(null);
        if (concreteBaseMethod == null || MethodModifier.isStatic((Set)concreteBaseMethod.getModifiers()) || invokeExpr instanceof JSpecialInvokeExpr) {
            return result;
        }
        if (this.instantiatedClasses.contains(resolveBaseMethodSignature.getDeclClassType())) {
            return Stream.concat(Stream.of((MethodSignature)concreteBaseMethod.getSignature()), this.resolveAllCallTargets((MethodSignature)sourceMethod.getSignature(), resolveBaseMethodSignature, invokableStmt));
        }
        this.saveIgnoredCall((MethodSignature)sourceMethod.getSignature(), resolveBaseMethodSignature, invokableStmt);
        return this.resolveAllCallTargets((MethodSignature)sourceMethod.getSignature(), resolveBaseMethodSignature, invokableStmt);
    }

    private Stream<MethodSignature> resolveAllCallTargets(MethodSignature source, MethodSignature resolveBaseMethodSignature, InvokableStmt invokableStmt) {
        return this.view.getTypeHierarchy().subtypesOf(resolveBaseMethodSignature.getDeclClassType()).map(classType -> {
            MethodSignature method = this.view.getIdentifierFactory().getMethodSignature(classType, (MethodSubSignature)resolveBaseMethodSignature.getSubSignature());
            if (this.instantiatedClasses.contains(classType)) {
                return RapidTypeAnalysisAlgorithm.resolveConcreteDispatch(this.view, method);
            }
            this.saveIgnoredCall(source, method, invokableStmt);
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get);
    }

    private void saveIgnoredCall(MethodSignature source, MethodSignature target, InvokableStmt invokableStmt) {
        ClassType notInstantiatedClass = target.getDeclClassType();
        CallGraph.Call ignoredCall = new CallGraph.Call(source, target, invokableStmt);
        this.ignoredCalls.put((Object)notInstantiatedClass, (Object)ignoredCall);
    }

    @Override
    protected void preProcessingMethod(MethodSignature sourceMethod, @Nonnull Deque<MethodSignature> workList, @Nonnull MutableCallGraph cg) {
        SootMethod method = this.view.getClass(sourceMethod.getDeclClassType()).flatMap(c -> c.getMethod((MethodSubSignature)sourceMethod.getSubSignature())).orElse(null);
        if (method == null) {
            return;
        }
        List<ClassType> newInstantiatedClasses = this.collectInstantiatedClassesInMethod(method);
        newInstantiatedClasses.forEach(classType -> this.includeIgnoredCallsToClass((ClassType)classType, cg, workList));
    }

    protected void includeIgnoredCallsToClass(ClassType classType, MutableCallGraph cg, Deque<MethodSignature> workList) {
        List newEdges = this.ignoredCalls.get((Object)classType);
        newEdges.forEach(call -> {
            MethodSignature concreteTarget = RapidTypeAnalysisAlgorithm.resolveConcreteDispatch(this.view, call.getTargetMethodSignature()).orElse(null);
            if (concreteTarget == null) {
                return;
            }
            this.addCallToCG(call.getSourceMethodSignature(), concreteTarget, call.getInvokableStmt(), cg, workList);
        });
        this.ignoredCalls.removeAll((Object)classType);
    }

    @Override
    protected void postProcessingMethod(MethodSignature sourceMethod, @Nonnull Deque<MethodSignature> workList, @Nonnull MutableCallGraph cg) {
    }
}

