/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jgrapht.graph.DirectedPseudograph;
import sootup.callgraph.CallGraph;
import sootup.callgraph.CallGraphDifference;
import sootup.callgraph.MutableCallGraph;
import sootup.core.jimple.common.stmt.InvokableStmt;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.SootClassMemberSignature;

public class GraphBasedCallGraph
implements MutableCallGraph {
    @Nonnull
    private final DirectedPseudograph<Vertex, CallGraph.Call> graph;
    @Nonnull
    private final Map<MethodSignature, Vertex> signatureToVertex;
    @Nonnull
    private final List<MethodSignature> entryMethods;

    public GraphBasedCallGraph(List<MethodSignature> entryMethods) {
        this((DirectedPseudograph<Vertex, CallGraph.Call>)new DirectedPseudograph(null, null, false), new HashMap<MethodSignature, Vertex>(), entryMethods);
    }

    protected GraphBasedCallGraph(@Nonnull DirectedPseudograph<Vertex, CallGraph.Call> graph, @Nonnull Map<MethodSignature, Vertex> signatureToVertex, @Nonnull List<MethodSignature> entryMethods) {
        this.graph = graph;
        this.signatureToVertex = signatureToVertex;
        this.entryMethods = entryMethods;
    }

    @Override
    public void addMethod(@Nonnull MethodSignature calledMethod) {
        Vertex v = new Vertex(calledMethod);
        this.addMethod(calledMethod, v);
    }

    protected void addMethod(@Nonnull MethodSignature calledMethod, Vertex vertex) {
        if (this.containsMethod(calledMethod)) {
            return;
        }
        this.graph.addVertex((Object)vertex);
        this.signatureToVertex.put(calledMethod, vertex);
    }

    @Override
    public void addCall(@Nonnull MethodSignature sourceMethod, @Nonnull MethodSignature targetMethod, @Nonnull InvokableStmt invokableStmt) {
        this.addCall(new CallGraph.Call(sourceMethod, targetMethod, invokableStmt));
    }

    @Override
    public void addCall(@Nonnull CallGraph.Call call) {
        if (!this.containsMethod(call.getSourceMethodSignature())) {
            this.addMethod(call.getSourceMethodSignature());
        }
        Vertex source = this.vertexOf(call.getSourceMethodSignature());
        if (!this.containsMethod(call.getTargetMethodSignature())) {
            this.addMethod(call.getTargetMethodSignature());
        }
        Vertex target = this.vertexOf(call.getTargetMethodSignature());
        this.graph.addEdge((Object)source, (Object)target, (Object)call);
    }

    @Override
    @Nonnull
    public Set<MethodSignature> getMethodSignatures() {
        return this.signatureToVertex.keySet();
    }

    @Override
    @Nonnull
    public Set<MethodSignature> callTargetsFrom(@Nonnull MethodSignature sourceMethod) {
        return this.callsFrom(sourceMethod).stream().map(CallGraph.Call::getTargetMethodSignature).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Set<MethodSignature> callSourcesTo(@Nonnull MethodSignature targetMethod) {
        return this.callsTo(targetMethod).stream().map(CallGraph.Call::getSourceMethodSignature).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Set<CallGraph.Call> callsFrom(@Nonnull MethodSignature sourceMethod) {
        return this.graph.outgoingEdgesOf((Object)this.vertexOf(sourceMethod));
    }

    @Override
    @Nonnull
    public Set<CallGraph.Call> callsTo(@Nonnull MethodSignature targetMethod) {
        return this.graph.incomingEdgesOf((Object)this.vertexOf(targetMethod));
    }

    @Override
    public boolean containsMethod(@Nonnull MethodSignature method) {
        return this.signatureToVertex.containsKey(method);
    }

    @Override
    public boolean containsCall(@Nonnull MethodSignature sourceMethod, @Nonnull MethodSignature targetMethod, @Nonnull InvokableStmt invokableStmt) {
        if (!this.containsMethod(sourceMethod) || !this.containsMethod(targetMethod)) {
            return false;
        }
        return this.containsCall(new CallGraph.Call(sourceMethod, targetMethod, invokableStmt));
    }

    @Override
    public boolean containsCall(@Nonnull CallGraph.Call call) {
        return this.graph.containsEdge((Object)call);
    }

    @Override
    public int callCount() {
        return this.graph.edgeSet().size();
    }

    @Override
    public String exportAsDot() {
        StringBuilder dotFormatBuilder = new StringBuilder();
        this.graph.edgeSet().stream().sorted(Comparator.comparing(call -> {
            Vertex edgeSource = (Vertex)this.graph.getEdgeSource(call);
            return edgeSource.methodSignature.getDeclClassType().getFullyQualifiedName();
        }).thenComparing(call -> {
            Vertex edgeSource = (Vertex)this.graph.getEdgeSource(call);
            return edgeSource.methodSignature.getName();
        }).thenComparing(call -> {
            Vertex edgeSource = (Vertex)this.graph.getEdgeSource(call);
            return edgeSource.methodSignature.getParameterTypes().toString();
        }).thenComparing(call -> {
            Vertex edgeTarget = (Vertex)this.graph.getEdgeTarget(call);
            return edgeTarget.methodSignature.getDeclClassType().getClassName();
        }).thenComparing(call -> {
            Vertex edgeTarget = (Vertex)this.graph.getEdgeTarget(call);
            return edgeTarget.methodSignature.getName();
        }).thenComparing(call -> {
            Vertex edgeTarget = (Vertex)this.graph.getEdgeTarget(call);
            return edgeTarget.methodSignature.getParameterTypes().toString();
        })).forEach(edge -> dotFormatBuilder.append("\t").append(this.toDotEdge((CallGraph.Call)edge)).append("\n"));
        return "strict digraph ObjectGraph {\n" + dotFormatBuilder + "}";
    }

    protected String toDotEdge(CallGraph.Call call) {
        Vertex sourceVertex = (Vertex)this.graph.getEdgeSource((Object)call);
        Vertex targetVertex = (Vertex)this.graph.getEdgeTarget((Object)call);
        return "\"" + sourceVertex.methodSignature + "\" -> \"" + targetVertex.methodSignature + "\";";
    }

    @Override
    @Nonnull
    public MutableCallGraph copy() {
        return new GraphBasedCallGraph((DirectedPseudograph<Vertex, CallGraph.Call>)((DirectedPseudograph)this.graph.clone()), new HashMap<MethodSignature, Vertex>(this.signatureToVertex), new ArrayList<MethodSignature>(this.entryMethods));
    }

    @Override
    @Nonnull
    public CallGraphDifference diff(@Nonnull CallGraph callGraph) {
        return new CallGraphDifference(this, callGraph);
    }

    @Nonnull
    protected Vertex vertexOf(@Nonnull MethodSignature method) {
        Vertex methodVertex = this.signatureToVertex.get(method);
        if (methodVertex == null) {
            throw new IllegalArgumentException("Vertex of Method signature " + method + " not found");
        }
        return methodVertex;
    }

    @Nonnull
    protected CallGraph.Call edgeOf(@Nonnull MethodSignature source, @Nonnull MethodSignature target, @Nonnull InvokableStmt invokableStmt) {
        Vertex sourceVertexOpt = this.vertexOf(source);
        Vertex targetVertexOpt = this.vertexOf(target);
        return this.graph.getAllEdges((Object)sourceVertexOpt, (Object)targetVertexOpt).stream().filter(call -> call.getInvokableStmt() == invokableStmt).findFirst().orElseThrow(() -> new IllegalArgumentException("Edge of source:" + source + " target:" + target + " stmt:" + invokableStmt + " not found"));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName() + "(" + this.callCount() + ")");
        Set<MethodSignature> signatures = this.getMethodSignatures();
        if (signatures.isEmpty()) {
            stringBuilder.append(" is empty");
        } else {
            stringBuilder.append(":\n");
            signatures.stream().sorted(Comparator.comparing(o -> o.getDeclClassType().toString()).thenComparing(SootClassMemberSignature::getName).thenComparing(o -> o.getParameterTypes().toString())).forEach(method -> {
                stringBuilder.append(method).append(":\n");
                this.callsFrom((MethodSignature)method).stream().sorted(Comparator.comparing(call -> call.getTargetMethodSignature().getDeclClassType().toString()).thenComparing(call -> call.getTargetMethodSignature().getName()).thenComparing(call -> call.getTargetMethodSignature().getParameterTypes().toString())).forEach(c -> stringBuilder.append("\tto ").append(this.printCalledMethods((CallGraph.Call)c)).append("\n"));
                this.callsTo((MethodSignature)method).stream().sorted(Comparator.comparing(call -> call.getSourceMethodSignature().getDeclClassType().toString()).thenComparing(call -> call.getSourceMethodSignature().getName()).thenComparing(call -> call.getSourceMethodSignature().getParameterTypes().toString())).forEach(call -> stringBuilder.append("\tfrom ").append(this.printCallingMethods((CallGraph.Call)call)).append("\n"));
                stringBuilder.append("\n");
            });
        }
        return stringBuilder.toString();
    }

    protected String printCallingMethods(CallGraph.Call call) {
        return call.getSourceMethodSignature().toString();
    }

    protected String printCalledMethods(CallGraph.Call call) {
        return call.getTargetMethodSignature().toString();
    }

    @Override
    @Nonnull
    public List<MethodSignature> getEntryMethods() {
        return this.entryMethods;
    }

    protected static class Vertex {
        @Nonnull
        final MethodSignature methodSignature;

        protected Vertex(@Nonnull MethodSignature methodSignature) {
            this.methodSignature = methodSignature;
        }

        @Nonnull
        protected MethodSignature getMethodSignature() {
            return this.methodSignature;
        }
    }
}

