/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.callgraph.AbstractCallGraphAlgorithm;
import sootup.callgraph.CallGraph;
import sootup.callgraph.MutableCallGraph;
import sootup.core.IdentifierFactory;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JDynamicInvokeExpr;
import sootup.core.jimple.common.expr.JInterfaceInvokeExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.stmt.InvokableStmt;
import sootup.core.model.MethodModifier;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public class ClassHierarchyAnalysisAlgorithm
extends AbstractCallGraphAlgorithm {
    public ClassHierarchyAnalysisAlgorithm(@Nonnull View view) {
        super(view);
    }

    @Override
    @Nonnull
    public CallGraph initialize() {
        return this.constructCompleteCallGraph(Collections.singletonList(this.findMainMethod()));
    }

    @Override
    @Nonnull
    public CallGraph initialize(@Nonnull List<MethodSignature> entryPoints) {
        return this.constructCompleteCallGraph(entryPoints);
    }

    @Override
    @Nonnull
    protected Stream<MethodSignature> resolveCall(SootMethod method, InvokableStmt invokableStmt) {
        Optional optInvokeExpr = invokableStmt.getInvokeExpr();
        if (!optInvokeExpr.isPresent()) {
            return Stream.empty();
        }
        AbstractInvokeExpr invokeExpr = (AbstractInvokeExpr)optInvokeExpr.get();
        MethodSignature targetMethodSignature = invokeExpr.getMethodSignature();
        if (invokeExpr instanceof JDynamicInvokeExpr) {
            return Stream.empty();
        }
        SootMethod targetMethod = ClassHierarchyAnalysisAlgorithm.findConcreteMethod(this.view, targetMethodSignature).orElse(null);
        if (targetMethod == null || MethodModifier.isStatic((Set)targetMethod.getModifiers()) || invokeExpr instanceof JSpecialInvokeExpr) {
            return Stream.of(targetMethodSignature);
        }
        ArrayList<ClassType> noImplementedMethod = new ArrayList<ClassType>();
        List<MethodSignature> targets = this.resolveAllCallTargets(targetMethodSignature, noImplementedMethod);
        if (!targetMethod.isAbstract()) {
            targets.add((MethodSignature)targetMethod.getSignature());
        }
        if (invokeExpr instanceof JInterfaceInvokeExpr) {
            IdentifierFactory factory = this.view.getIdentifierFactory();
            noImplementedMethod.stream().map(classType -> ClassHierarchyAnalysisAlgorithm.resolveConcreteDispatch(this.view, factory.getMethodSignature(classType, (MethodSubSignature)targetMethodSignature.getSubSignature()))).filter(Optional::isPresent).map(Optional::get).forEach(targets::add);
        }
        return targets.stream();
    }

    private List<MethodSignature> resolveAllCallTargets(MethodSignature targetMethodSignature, ArrayList<ClassType> noImplementedMethod) {
        ArrayList<MethodSignature> targets = new ArrayList<MethodSignature>();
        this.view.getTypeHierarchy().subtypesOf(targetMethodSignature.getDeclClassType()).forEach(classType -> {
            SootClass clazz = this.view.getClass(classType).orElse(null);
            if (clazz == null) {
                return;
            }
            SootMethod method = clazz.getMethod((MethodSubSignature)targetMethodSignature.getSubSignature()).orElse(null);
            if (method != null && !method.isAbstract()) {
                targets.add((MethodSignature)method.getSignature());
            }
            if (method == null && !clazz.isInterface()) {
                noImplementedMethod.add((ClassType)classType);
            }
            clazz.getInterfaces().forEach(interfaceType -> {
                SootMethod defaultMethod = this.view.getMethod(this.view.getIdentifierFactory().getMethodSignature(interfaceType, (MethodSubSignature)targetMethodSignature.getSubSignature())).orElse(null);
                if (defaultMethod != null && !defaultMethod.isAbstract()) {
                    targets.add((MethodSignature)defaultMethod.getSignature());
                }
            });
        });
        return targets;
    }

    @Override
    protected void postProcessingMethod(MethodSignature sourceMethod, @Nonnull Deque<MethodSignature> workList, @Nonnull MutableCallGraph cg) {
    }

    @Override
    protected void preProcessingMethod(MethodSignature sourceMethod, @Nonnull Deque<MethodSignature> workList, @Nonnull MutableCallGraph cg) {
    }
}

