/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.callgraph.CallGraph;
import sootup.callgraph.CallGraphAlgorithm;
import sootup.callgraph.GraphBasedCallGraph;
import sootup.callgraph.InstantiateClassValueVisitor;
import sootup.callgraph.MutableCallGraph;
import sootup.core.IdentifierFactory;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.stmt.InvokableStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.ValueVisitor;
import sootup.core.model.Method;
import sootup.core.model.SootClass;
import sootup.core.model.SootClassMember;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.signatures.SootClassMemberSignature;
import sootup.core.typehierarchy.HierarchyComparator;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public abstract class AbstractCallGraphAlgorithm
implements CallGraphAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCallGraphAlgorithm.class);
    @Nonnull
    protected final View view;

    protected AbstractCallGraphAlgorithm(@Nonnull View view) {
        this.view = view;
    }

    @Nonnull
    final CallGraph constructCompleteCallGraph(List<MethodSignature> entryPoints) {
        ArrayDeque<MethodSignature> workList = new ArrayDeque<MethodSignature>(entryPoints);
        HashSet<MethodSignature> processed = new HashSet<MethodSignature>();
        List<MethodSignature> clinits = this.getClinitFromEntryPoints(entryPoints);
        workList.addAll(clinits);
        MutableCallGraph cg = this.initializeCallGraph(entryPoints, clinits);
        this.processWorkList(workList, processed, cg);
        return cg;
    }

    protected MutableCallGraph initializeCallGraph(List<MethodSignature> entryPoints, List<MethodSignature> clinits) {
        ArrayList<MethodSignature> rootSignatures = new ArrayList<MethodSignature>(entryPoints);
        rootSignatures.addAll(clinits);
        return new GraphBasedCallGraph(rootSignatures);
    }

    protected List<MethodSignature> getClinitFromEntryPoints(List<MethodSignature> entryPoints) {
        return entryPoints.stream().map(methodSignature -> this.getSignatureOfImplementedStaticInitializer(methodSignature.getDeclClassType())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<MethodSignature> getSignatureOfImplementedStaticInitializer(ClassType classType) {
        return this.view.getMethod(this.view.getIdentifierFactory().getStaticInitializerSignature(classType)).map(SootClassMember::getSignature);
    }

    final void processWorkList(Deque<MethodSignature> workList, Set<MethodSignature> processed, MutableCallGraph cg) {
        while (!workList.isEmpty()) {
            SootClass currentClass;
            MethodSignature currentMethodSignature = workList.pop();
            if (processed.contains(currentMethodSignature) || (currentClass = (SootClass)this.view.getClass(currentMethodSignature.getDeclClassType()).orElse(null)) == null || currentClass.isLibraryClass()) continue;
            this.preProcessingMethod(currentMethodSignature, workList, cg);
            if (!cg.containsMethod(currentMethodSignature)) {
                cg.addMethod(currentMethodSignature);
            }
            SootMethod currentMethod = currentClass.getMethod((MethodSubSignature)currentMethodSignature.getSubSignature()).orElse(null);
            this.resolveAllCallsFromSourceMethod(currentMethod, cg, workList);
            this.resolveAllImplicitCallsFromSourceMethod(currentMethod, cg, workList);
            processed.add(currentMethodSignature);
            this.postProcessingMethod(currentMethodSignature, workList, cg);
        }
    }

    protected void addCallToCG(@Nonnull MethodSignature source, @Nonnull MethodSignature target, @Nonnull InvokableStmt invokeStmt, @Nonnull MutableCallGraph cg, @Nonnull Deque<MethodSignature> workList) {
        if (!cg.containsMethod(source)) {
            cg.addMethod(source);
            workList.push(source);
        }
        if (!cg.containsMethod(target)) {
            cg.addMethod(target);
            workList.push(target);
        }
        if (!cg.containsCall(source, target, invokeStmt)) {
            cg.addCall(source, target, invokeStmt);
        }
    }

    protected void resolveAllCallsFromSourceMethod(SootMethod sourceMethod, MutableCallGraph cg, Deque<MethodSignature> workList) {
        if (sourceMethod == null || !sourceMethod.hasBody()) {
            return;
        }
        sourceMethod.getBody().getStmts().stream().filter(Stmt::isInvokableStmt).map(Stmt::asInvokableStmt).forEach(stmt -> this.resolveCall(sourceMethod, (InvokableStmt)stmt).forEach(targetMethod -> this.addCallToCG((MethodSignature)sourceMethod.getSignature(), (MethodSignature)targetMethod, (InvokableStmt)stmt, cg, workList)));
    }

    protected void resolveAllImplicitCallsFromSourceMethod(SootMethod sourceMethod, MutableCallGraph cg, Deque<MethodSignature> workList) {
        if (sourceMethod == null || !sourceMethod.hasBody()) {
            return;
        }
        this.resolveAllStaticInitializerCalls(sourceMethod, cg, workList);
    }

    protected void resolveAllStaticInitializerCalls(SootMethod sourceMethod, MutableCallGraph cg, Deque<MethodSignature> workList) {
        if (sourceMethod == null || !sourceMethod.hasBody()) {
            return;
        }
        InstantiateClassValueVisitor instantiateVisitor = new InstantiateClassValueVisitor();
        sourceMethod.getBody().getStmts().stream().filter(Stmt::isInvokableStmt).map(Stmt::asInvokableStmt).forEach(invokableStmt -> {
            ClassType targetClass = null;
            if (invokableStmt.containsFieldRef() && invokableStmt.getFieldRef() instanceof JStaticFieldRef) {
                targetClass = invokableStmt.getFieldRef().getFieldSignature().getDeclClassType();
                this.addStaticInitializerCalls((MethodSignature)sourceMethod.getSignature(), targetClass, (InvokableStmt)invokableStmt, cg, workList);
            }
            if (invokableStmt.containsInvokeExpr()) {
                ClassType newTargetClass;
                Optional exprOptional = invokableStmt.getInvokeExpr();
                if (!exprOptional.isPresent()) {
                    return;
                }
                AbstractInvokeExpr expr = (AbstractInvokeExpr)exprOptional.get();
                if (expr instanceof JStaticInvokeExpr && !(newTargetClass = expr.getMethodSignature().getDeclClassType()).equals((Object)targetClass)) {
                    this.addStaticInitializerCalls((MethodSignature)sourceMethod.getSignature(), newTargetClass, (InvokableStmt)invokableStmt, cg, workList);
                }
            } else if (invokableStmt instanceof JAssignStmt) {
                Value rightOp = ((JAssignStmt)invokableStmt).getRightOp();
                instantiateVisitor.init();
                rightOp.accept((ValueVisitor)instantiateVisitor);
                ClassType newTargetClass = instantiateVisitor.getResult();
                if (newTargetClass != null && !newTargetClass.equals((Object)targetClass)) {
                    this.addStaticInitializerCalls((MethodSignature)sourceMethod.getSignature(), newTargetClass, (InvokableStmt)invokableStmt, cg, workList);
                }
            }
        });
    }

    private void addStaticInitializerCalls(MethodSignature sourceSig, ClassType targetClass, InvokableStmt invokableStmt, MutableCallGraph cg, Deque<MethodSignature> workList) {
        this.view.getMethod(this.view.getIdentifierFactory().getStaticInitializerSignature(targetClass)).ifPresent(targetSig -> this.addCallToCG(sourceSig, (MethodSignature)targetSig.getSignature(), invokableStmt, cg, workList));
        this.view.getTypeHierarchy().superClassesOf(targetClass).map(classType -> this.view.getMethod(this.view.getIdentifierFactory().getStaticInitializerSignature(classType))).filter(Optional::isPresent).map(Optional::get).forEach(targetSig -> this.addCallToCG(sourceSig, (MethodSignature)targetSig.getSignature(), invokableStmt, cg, workList));
    }

    protected abstract void preProcessingMethod(MethodSignature var1, @Nonnull Deque<MethodSignature> var2, @Nonnull MutableCallGraph var3);

    protected abstract void postProcessingMethod(MethodSignature var1, @Nonnull Deque<MethodSignature> var2, @Nonnull MutableCallGraph var3);

    @Override
    @Nonnull
    public CallGraph addClass(@Nonnull CallGraph oldCallGraph, @Nonnull ClassType classType) {
        SootClass clazz = this.view.getClassOrThrow(classType);
        Set newMethodSignatures = clazz.getMethods().stream().map(Method::getSignature).filter(methodSig -> !oldCallGraph.containsMethod((MethodSignature)methodSig)).collect(Collectors.toSet());
        if (newMethodSignatures.isEmpty()) {
            return oldCallGraph;
        }
        MutableCallGraph updated = oldCallGraph.copy();
        ArrayDeque<MethodSignature> workList = new ArrayDeque<MethodSignature>(newMethodSignatures);
        HashSet<MethodSignature> processed = new HashSet<MethodSignature>(oldCallGraph.getMethodSignatures());
        this.processWorkList(workList, processed, updated);
        Stream superClasses = this.view.getTypeHierarchy().superClassesOf(classType);
        Stream implementedInterfaces = this.view.getTypeHierarchy().implementedInterfacesOf(classType);
        Stream<ClassType> superTypes = Stream.concat(superClasses, implementedInterfaces);
        Set newMethodSubSigs = newMethodSignatures.stream().map(SootClassMemberSignature::getSubSignature).collect(Collectors.toSet());
        superTypes.map(arg_0 -> ((View)this.view).getClass(arg_0)).filter(Optional::isPresent).map(Optional::get).flatMap(superType -> superType.getMethods().stream()).map(Method::getSignature).filter(superTypeMethodSig -> newMethodSubSigs.contains(superTypeMethodSig.getSubSignature())).forEach(overriddenMethodSig -> {
            MethodSignature overridingMethodSig = (MethodSignature)((SootMethod)clazz.getMethod((MethodSubSignature)overriddenMethodSig.getSubSignature()).get()).getSignature();
            if (updated.containsMethod((MethodSignature)overriddenMethodSig)) {
                for (CallGraph.Call calls : updated.callsTo((MethodSignature)overriddenMethodSig)) {
                    updated.addCall(calls.getSourceMethodSignature(), overridingMethodSig, calls.getInvokableStmt());
                }
            }
        });
        return updated;
    }

    public MethodSignature findMainMethod() {
        Collection mainMethods = this.view.getClasses().filter(aClass -> !aClass.isLibraryClass()).flatMap(aClass -> aClass.getMethods().stream()).filter(method -> method.isStatic() && method.isMain(this.view.getIdentifierFactory())).collect(Collectors.toSet());
        if (mainMethods.size() > 1) {
            throw new RuntimeException("There are more than 1 main method present.\n Below main methods are found: \n" + mainMethods + "\n initialize() method can be used if only one main method exists. \n You can specify these main methods as entry points by passing them as parameter to initialize method.");
        }
        if (mainMethods.isEmpty()) {
            throw new RuntimeException("No main method is present in the input programs. initialize() method can be used if only one main method exists in the input program and that should be used as entry point for call graph. \n Please specify entry point as a parameter to initialize method.");
        }
        return (MethodSignature)((SootMethod)mainMethods.stream().findFirst().get()).getSignature();
    }

    @Nonnull
    protected abstract Stream<MethodSignature> resolveCall(SootMethod var1, InvokableStmt var2);

    @Nonnull
    public static Optional<MethodSignature> resolveConcreteDispatch(View view, MethodSignature m) {
        Optional<SootMethod> methodOp = AbstractCallGraphAlgorithm.findConcreteMethod(view, m);
        if (methodOp.isPresent()) {
            SootMethod method = methodOp.get();
            if (method.isAbstract()) {
                return Optional.empty();
            }
            return Optional.of((MethodSignature)method.getSignature());
        }
        return Optional.empty();
    }

    public static Optional<SootMethod> findConcreteMethod(@Nonnull View view, @Nonnull MethodSignature sig) {
        IdentifierFactory identifierFactory = view.getIdentifierFactory();
        SootClass startclass = view.getClass(sig.getDeclClassType()).orElse(null);
        if (startclass == null) {
            logger.warn("Could not find \"" + sig.getDeclClassType() + "\" of method" + sig + " to resolve the concrete method");
            return Optional.empty();
        }
        Optional<SootMethod> startMethod = startclass.getMethod((MethodSubSignature)sig.getSubSignature()).map(method -> method);
        if (startMethod.isPresent()) {
            return startMethod;
        }
        TypeHierarchy typeHierarchy = view.getTypeHierarchy();
        Stream superClasses = typeHierarchy.superClassesOf(sig.getDeclClassType());
        Iterator iterator = superClasses.iterator();
        while (iterator.hasNext()) {
            ClassType superClassType = (ClassType)iterator.next();
            Optional<SootMethod> method2 = view.getMethod(identifierFactory.getMethodSignature(superClassType, (MethodSubSignature)sig.getSubSignature())).map(sm -> sm);
            if (!method2.isPresent()) continue;
            return method2;
        }
        HierarchyComparator hierarchyComparator = new HierarchyComparator(view.getTypeHierarchy());
        Optional<SootMethod> defaultMethod = typeHierarchy.implementedInterfacesOf(sig.getDeclClassType()).map(classType -> view.getMethod(identifierFactory.getMethodSignature(classType, (MethodSubSignature)sig.getSubSignature()))).filter(Optional::isPresent).map(Optional::get).min((m1, m2) -> hierarchyComparator.compare(m1.getDeclaringClassType(), m2.getDeclaringClassType())).map(method -> method);
        if (defaultMethod.isPresent()) {
            return defaultMethod;
        }
        logger.warn("Could not find \"" + sig.getSubSignature() + "\" in " + sig.getDeclClassType().getClassName() + " and in its superclasses and interfaces");
        return Optional.empty();
    }
}

