/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.interprocedural.icfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.DontSynchronize;
import heros.SynchronizedBy;
import heros.ThreadSafe;
import heros.solver.IDESolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.analysis.interprocedural.icfg.AbstractJimpleBasedICFG;
import sootup.analysis.interprocedural.icfg.CGEdgeUtil;
import sootup.analysis.interprocedural.icfg.CalleeMethodSignature;
import sootup.analysis.interprocedural.icfg.ICFGDotExporter;
import sootup.callgraph.CallGraph;
import sootup.callgraph.ClassHierarchyAnalysisAlgorithm;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.views.View;

@ThreadSafe
public class JimpleBasedInterproceduralCFG
extends AbstractJimpleBasedICFG {
    protected static final Logger logger = LoggerFactory.getLogger(JimpleBasedInterproceduralCFG.class);
    private final MethodSignature mainMethodSignature;
    protected boolean includeReflectiveCalls;
    @DontSynchronize(value="readonly")
    protected final CallGraph cg;
    protected CacheLoader<Stmt, Collection<SootMethod>> loaderUnitToCallees = new CacheLoader<Stmt, Collection<SootMethod>>(){

        @Nonnull
        public Collection<SootMethod> load(Stmt stmt) {
            ArrayList<SootMethod> res = new ArrayList<SootMethod>();
            MethodSignature methodSignature = stmt.getInvokeExpr().getMethodSignature();
            Optional smOpt = JimpleBasedInterproceduralCFG.this.view.getMethod(methodSignature);
            if (smOpt.isPresent()) {
                SootMethod sm = (SootMethod)smOpt.get();
                if (sm.hasBody()) {
                    res.add(sm);
                } else {
                    logger.error("Method {} is referenced but has no body!", (Object)sm.getSignature(), (Object)new Exception());
                }
            }
            res.trimToSize();
            return res;
        }
    };
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<Stmt, Collection<SootMethod>> stmtToCallees = IDESolver.DEFAULT_CACHE_BUILDER.build(this.loaderUnitToCallees);
    protected CacheLoader<SootMethod, Collection<Stmt>> loaderMethodToCallers = new CacheLoader<SootMethod, Collection<Stmt>>(){

        @Nonnull
        public Collection<Stmt> load(SootMethod method) {
            ArrayList<Stmt> res = new ArrayList<Stmt>();
            Set callsToMethod = JimpleBasedInterproceduralCFG.this.cg.callsTo((MethodSignature)method.getSignature());
            for (MethodSignature methodSignature : callsToMethod) {
                Stmt stmt = this.filterEdgeAndGetCallerStmt(methodSignature);
                if (stmt == null) continue;
                res.add(stmt);
            }
            res.trimToSize();
            return res;
        }

        @Nullable
        private Stmt filterEdgeAndGetCallerStmt(@Nonnull MethodSignature methodSignature) {
            Set<Pair<MethodSignature, CalleeMethodSignature>> callEdges = CGEdgeUtil.getCallEdges(JimpleBasedInterproceduralCFG.this.view, JimpleBasedInterproceduralCFG.this.cg);
            for (Pair<MethodSignature, CalleeMethodSignature> callEdge : callEdges) {
                CGEdgeUtil.CallGraphEdgeType edgeType;
                CalleeMethodSignature callee = (CalleeMethodSignature)callEdge.getValue();
                if (!callee.getMethodSignature().equals((Object)methodSignature) || !(edgeType = callee.getEdgeType()).isExplicit() && !edgeType.isFake() && !edgeType.isClinit() && (!JimpleBasedInterproceduralCFG.this.includeReflectiveCalls || !edgeType.isReflection())) continue;
                return callee.getSourceStmt();
            }
            return null;
        }
    };
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<SootMethod, Collection<Stmt>> methodToCallers = IDESolver.DEFAULT_CACHE_BUILDER.build(this.loaderMethodToCallers);

    public JimpleBasedInterproceduralCFG(View view, MethodSignature mainMethodSignature, boolean enableExceptions, boolean includeReflectiveCalls) {
        super(enableExceptions);
        this.includeReflectiveCalls = includeReflectiveCalls;
        this.view = view;
        this.mainMethodSignature = mainMethodSignature;
        this.cg = this.initCallGraph();
        this.initializeStmtToOwner();
    }

    public String buildICFGGraph(CallGraph callGraph) {
        LinkedHashMap signatureToStmtGraph = new LinkedHashMap();
        this.computeAllCalls(this.mainMethodSignature, signatureToStmtGraph, callGraph);
        return ICFGDotExporter.buildICFGGraph(signatureToStmtGraph, this.view, callGraph);
    }

    public void computeAllCalls(MethodSignature methodSignature, Map<MethodSignature, StmtGraph<?>> signatureToStmtGraph, CallGraph callGraph) {
        ArrayList<MethodSignature> visitedMethods = new ArrayList<MethodSignature>();
        this.computeAllCalls(methodSignature, signatureToStmtGraph, callGraph, visitedMethods);
    }

    private void computeAllCalls(MethodSignature methodSignature, Map<MethodSignature, StmtGraph<?>> signatureToStmtGraph, CallGraph callGraph, List<MethodSignature> visitedMethods) {
        SootMethod sootMethod;
        visitedMethods.add(methodSignature);
        Optional methodOpt = this.view.getMethod(methodSignature);
        if (signatureToStmtGraph.containsKey(methodSignature)) {
            return;
        }
        if (methodOpt.isPresent() && (sootMethod = (SootMethod)methodOpt.get()).hasBody()) {
            StmtGraph stmtGraph = sootMethod.getBody().getStmtGraph();
            signatureToStmtGraph.put(methodSignature, stmtGraph);
        }
        callGraph.callsFrom(methodSignature).stream().filter(methodSignature1 -> !visitedMethods.contains(methodSignature1)).forEach(nextMethodSignature -> this.computeAllCalls((MethodSignature)nextMethodSignature, signatureToStmtGraph, callGraph, visitedMethods));
    }

    private CallGraph initCallGraph() {
        ClassHierarchyAnalysisAlgorithm cga = new ClassHierarchyAnalysisAlgorithm(this.view);
        return cga.initialize(Collections.singletonList(this.mainMethodSignature));
    }

    protected void initializeStmtToOwner() {
        for (MethodSignature methodSignature : this.cg.getMethodSignatures()) {
            Optional methodOpt = this.view.getMethod(methodSignature);
            methodOpt.ifPresent(this::initializeStmtToOwner);
        }
    }

    public Collection<SootMethod> getCalleesOfCallAt(@Nonnull Stmt u) {
        return (Collection)this.stmtToCallees.getUnchecked((Object)u);
    }

    public Collection<Stmt> getCallersOf(@Nonnull SootMethod m) {
        return (Collection)this.methodToCallers.getUnchecked((Object)m);
    }

    public static Set<Pair<MethodSignature, CalleeMethodSignature>> getCallEdges(@Nonnull View view, @Nonnull CallGraph cg) {
        Set methodSigs = cg.getMethodSignatures();
        HashSet<Pair<MethodSignature, CalleeMethodSignature>> callEdges = new HashSet<Pair<MethodSignature, CalleeMethodSignature>>();
        for (MethodSignature caller : methodSigs) {
            SootMethod method;
            Optional methodOpt = view.getMethod(caller);
            if (!methodOpt.isPresent() || !(method = (SootMethod)methodOpt.get()).hasBody()) continue;
            for (Stmt s : method.getBody().getStmtGraph().getNodes()) {
                if (!s.containsInvokeExpr()) continue;
                CalleeMethodSignature callee = new CalleeMethodSignature(s.getInvokeExpr().getMethodSignature(), CGEdgeUtil.findCallGraphEdgeType(s.getInvokeExpr()), s);
                callEdges.add((Pair<MethodSignature, CalleeMethodSignature>)new ImmutablePair((Object)caller, (Object)callee));
            }
        }
        return callEdges;
    }
}

