/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.intraprocedural.reachingdefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.analysis.intraprocedural.ForwardFlowAnalysis;
import sootup.analysis.intraprocedural.reachingdefs.VariableDefinition;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;

public class ReachingDefs {
    private final Map<Stmt, List<Stmt>> reachingDefs = new HashMap<Stmt, List<Stmt>>();

    public ReachingDefs(StmtGraph<? extends BasicBlock<?>> graph) {
        ReachingDefsAnalysis analysis = new ReachingDefsAnalysis(graph);
        for (Stmt stmt : graph.getStmts()) {
            if (!stmt.getUses().findAny().isPresent()) continue;
            Set inset = (Set)analysis.getFlowBefore(stmt);
            this.reachingDefs.put(stmt, new ArrayList());
            for (VariableDefinition def : inset) {
                Value definedVar = def.getValue();
                Optional<Stmt> definingStmt = def.getStmt();
                stmt.getUses().filter(usedVar -> definedVar.equivTo(usedVar) && definingStmt.isPresent() && definingStmt.get() != stmt).forEach(usedVar -> this.reachingDefs.get(stmt).add((Stmt)definingStmt.get()));
            }
        }
    }

    public Map<Stmt, List<Stmt>> getReachingDefs() {
        return this.reachingDefs;
    }

    static class ReachingDefsAnalysis
    extends ForwardFlowAnalysis<Set<VariableDefinition>> {
        <B extends BasicBlock<B>> ReachingDefsAnalysis(StmtGraph<B> graph) {
            super(graph);
            this.execute();
        }

        @Override
        @Nonnull
        protected Set<VariableDefinition> newInitialFlow() {
            HashSet<VariableDefinition> initialValues = new HashSet<VariableDefinition>();
            this.graph.getNodes().stream().map(Stmt::getDef).filter(Optional::isPresent).map(Optional::get).forEach(def -> initialValues.add(new VariableDefinition((Value)def, null)));
            return initialValues;
        }

        @Override
        protected void merge(@Nonnull Set<VariableDefinition> in1, @Nonnull Set<VariableDefinition> in2, @Nonnull Set<VariableDefinition> out) {
            out.clear();
            out.addAll(in1);
            out.addAll(in2);
        }

        @Override
        protected void copy(@Nonnull Set<VariableDefinition> source, @Nonnull Set<VariableDefinition> dest) {
            dest.clear();
            dest.addAll(source);
        }

        @Override
        protected void flowThrough(@Nonnull Set<VariableDefinition> in, Stmt d, @Nonnull Set<VariableDefinition> out) {
            out.clear();
            out.addAll(in);
            this.kill(d).forEach(out::remove);
            this.gen(d).forEach(out::add);
        }

        private Stream<VariableDefinition> kill(Stmt d) {
            if (!(d instanceof JAssignStmt)) {
                return Stream.empty();
            }
            return d.getDef().map(definedValue -> {
                ArrayList<VariableDefinition> output = new ArrayList<VariableDefinition>();
                output.add(new VariableDefinition((Value)definedValue, null));
                this.graph.getNodes().stream().filter(stmt -> stmt.getDef().isPresent() && ((LValue)stmt.getDef().get()).equals(definedValue)).forEach(stmt -> output.add(new VariableDefinition((Value)definedValue, (Stmt)stmt)));
                return output.stream();
            }).orElseGet(Stream::empty);
        }

        private Stream<VariableDefinition> gen(Stmt d) {
            return d.getDef().map(def -> Stream.of(new VariableDefinition((Value)def, d))).orElseGet(Stream::empty);
        }
    }
}

