/*
 * Decompiled with CFR 0.152.
 */
package sootup.analysis.intraprocedural;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.common.stmt.Stmt;

public abstract class AbstractFlowAnalysis<F> {
    protected final StmtGraph<? extends BasicBlock<?>> graph;
    protected final Map<Stmt, F> stmtToBeforeFlow;

    public AbstractFlowAnalysis(StmtGraph<? extends BasicBlock<?>> graph) {
        this.graph = graph;
        this.stmtToBeforeFlow = new IdentityHashMap<Stmt, F>(graph.getNodes().size() * 2 + 1);
    }

    @Nonnull
    protected abstract F newInitialFlow();

    protected F entryInitialFlow() {
        return this.newInitialFlow();
    }

    protected boolean treatTrapHandlersAsEntries() {
        return false;
    }

    protected abstract boolean isForward();

    protected abstract void merge(@Nonnull F var1, @Nonnull F var2, @Nonnull F var3);

    protected void merge(@Nonnull Stmt succNode, @Nonnull F in1, @Nonnull F in2, @Nonnull F out) {
        this.merge(in1, in2, out);
    }

    protected abstract void copy(@Nonnull F var1, @Nonnull F var2);

    protected abstract void execute();

    @Nonnull
    public F getFlowBefore(@Nonnull Stmt s) {
        return this.stmtToBeforeFlow.get(s);
    }

    protected void mergeInto(@Nonnull Stmt succNode, @Nonnull F inout, @Nonnull F in) {
        F tmp = this.newInitialFlow();
        this.merge(succNode, inout, in, tmp);
        this.copy(tmp, inout);
    }
}

