package soot.tagkit;

/*-
 * #%L
 * Soot - a J*va Optimization Framework
 * %%
 * Copyright (C) 2020 Manuel Benz
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 * #L%
 */

/**
 * Used to tag entities (class, method, variable, etc.) as artificially generated by Soot itself, i.e. entities that do not
 * exist in the original bytecode. This can, for instance, be used to exclude such entities from being written out or
 * processed by clients.
 *
 * @author Manuel Benz at 02.03.20
 */
public class ArtificialEntityTag implements Tag {

  public static final String NAME = "ArtificialEntityTag";

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public byte[] getValue() throws AttributeValueException {
    throw new RuntimeException("ArtificialEntityTag has no value for bytecode");
  }
}
