/* This file was generated by SableCC (http://www.sablecc.org/). */

package soot.jimple.parser.lexer;

import java.io.*;
import soot.jimple.parser.node.*;

@SuppressWarnings("nls")
public class Lexer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    @SuppressWarnings("unused")
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    public Lexer(@SuppressWarnings("hiding") PushbackReader in)
    {
        this.in = in;
    }
 
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        return this.token;
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        @SuppressWarnings("hiding") int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        @SuppressWarnings("hiding") int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        // int middle = (low + high) / 2;
                        int middle = (low + high) >>> 1;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            @SuppressWarnings("hiding") Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            @SuppressWarnings("hiding") Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            @SuppressWarnings("hiding") Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            @SuppressWarnings("hiding") Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            @SuppressWarnings("hiding") Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            @SuppressWarnings("hiding") Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            @SuppressWarnings("hiding") Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            @SuppressWarnings("hiding") Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            @SuppressWarnings("hiding") Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            @SuppressWarnings("hiding") Token token = new9(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            @SuppressWarnings("hiding") Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            @SuppressWarnings("hiding") Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            @SuppressWarnings("hiding") Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            @SuppressWarnings("hiding") Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            @SuppressWarnings("hiding") Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            @SuppressWarnings("hiding") Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            @SuppressWarnings("hiding") Token token = new16(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            @SuppressWarnings("hiding") Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            @SuppressWarnings("hiding") Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            @SuppressWarnings("hiding") Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                            @SuppressWarnings("hiding") Token token = new20(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                            @SuppressWarnings("hiding") Token token = new21(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                            @SuppressWarnings("hiding") Token token = new22(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                            @SuppressWarnings("hiding") Token token = new23(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                            @SuppressWarnings("hiding") Token token = new24(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                            @SuppressWarnings("hiding") Token token = new25(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                            @SuppressWarnings("hiding") Token token = new26(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                            @SuppressWarnings("hiding") Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                            @SuppressWarnings("hiding") Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                            @SuppressWarnings("hiding") Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                            @SuppressWarnings("hiding") Token token = new30(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                            @SuppressWarnings("hiding") Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                            @SuppressWarnings("hiding") Token token = new32(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                            @SuppressWarnings("hiding") Token token = new33(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                            @SuppressWarnings("hiding") Token token = new34(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                            @SuppressWarnings("hiding") Token token = new35(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                            @SuppressWarnings("hiding") Token token = new36(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                            @SuppressWarnings("hiding") Token token = new37(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                            @SuppressWarnings("hiding") Token token = new38(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                            @SuppressWarnings("hiding") Token token = new39(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                            @SuppressWarnings("hiding") Token token = new40(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                            @SuppressWarnings("hiding") Token token = new41(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                            @SuppressWarnings("hiding") Token token = new42(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                            @SuppressWarnings("hiding") Token token = new43(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                            @SuppressWarnings("hiding") Token token = new44(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                            @SuppressWarnings("hiding") Token token = new45(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                            @SuppressWarnings("hiding") Token token = new46(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                            @SuppressWarnings("hiding") Token token = new47(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                            @SuppressWarnings("hiding") Token token = new48(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                            @SuppressWarnings("hiding") Token token = new49(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                            @SuppressWarnings("hiding") Token token = new50(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                            @SuppressWarnings("hiding") Token token = new51(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                            @SuppressWarnings("hiding") Token token = new52(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                            @SuppressWarnings("hiding") Token token = new53(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                            @SuppressWarnings("hiding") Token token = new54(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                            @SuppressWarnings("hiding") Token token = new55(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                            @SuppressWarnings("hiding") Token token = new56(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                            @SuppressWarnings("hiding") Token token = new57(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                            @SuppressWarnings("hiding") Token token = new58(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 59:
                        {
                            @SuppressWarnings("hiding") Token token = new59(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 60:
                        {
                            @SuppressWarnings("hiding") Token token = new60(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 61:
                        {
                            @SuppressWarnings("hiding") Token token = new61(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 62:
                        {
                            @SuppressWarnings("hiding") Token token = new62(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 63:
                        {
                            @SuppressWarnings("hiding") Token token = new63(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 64:
                        {
                            @SuppressWarnings("hiding") Token token = new64(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 65:
                        {
                            @SuppressWarnings("hiding") Token token = new65(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 66:
                        {
                            @SuppressWarnings("hiding") Token token = new66(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 67:
                        {
                            @SuppressWarnings("hiding") Token token = new67(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 68:
                        {
                            @SuppressWarnings("hiding") Token token = new68(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 69:
                        {
                            @SuppressWarnings("hiding") Token token = new69(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 70:
                        {
                            @SuppressWarnings("hiding") Token token = new70(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 71:
                        {
                            @SuppressWarnings("hiding") Token token = new71(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 72:
                        {
                            @SuppressWarnings("hiding") Token token = new72(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 73:
                        {
                            @SuppressWarnings("hiding") Token token = new73(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 74:
                        {
                            @SuppressWarnings("hiding") Token token = new74(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 75:
                        {
                            @SuppressWarnings("hiding") Token token = new75(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 76:
                        {
                            @SuppressWarnings("hiding") Token token = new76(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 77:
                        {
                            @SuppressWarnings("hiding") Token token = new77(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 78:
                        {
                            @SuppressWarnings("hiding") Token token = new78(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 79:
                        {
                            @SuppressWarnings("hiding") Token token = new79(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 80:
                        {
                            @SuppressWarnings("hiding") Token token = new80(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 81:
                        {
                            @SuppressWarnings("hiding") Token token = new81(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 82:
                        {
                            @SuppressWarnings("hiding") Token token = new82(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 83:
                        {
                            @SuppressWarnings("hiding") Token token = new83(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 84:
                        {
                            @SuppressWarnings("hiding") Token token = new84(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 85:
                        {
                            @SuppressWarnings("hiding") Token token = new85(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 86:
                        {
                            @SuppressWarnings("hiding") Token token = new86(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 87:
                        {
                            @SuppressWarnings("hiding") Token token = new87(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 88:
                        {
                            @SuppressWarnings("hiding") Token token = new88(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 89:
                        {
                            @SuppressWarnings("hiding") Token token = new89(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 90:
                        {
                            @SuppressWarnings("hiding") Token token = new90(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 91:
                        {
                            @SuppressWarnings("hiding") Token token = new91(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 92:
                        {
                            @SuppressWarnings("hiding") Token token = new92(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 93:
                        {
                            @SuppressWarnings("hiding") Token token = new93(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 94:
                        {
                            @SuppressWarnings("hiding") Token token = new94(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 95:
                        {
                            @SuppressWarnings("hiding") Token token = new95(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 96:
                        {
                            @SuppressWarnings("hiding") Token token = new96(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 97:
                        {
                            @SuppressWarnings("hiding") Token token = new97(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 98:
                        {
                            @SuppressWarnings("hiding") Token token = new98(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 99:
                        {
                            @SuppressWarnings("hiding") Token token = new99(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 100:
                        {
                            @SuppressWarnings("hiding") Token token = new100(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                    @SuppressWarnings("hiding") EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIgnored(text, line, pos); }
    Token new1(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAbstract(line, pos); }
    Token new2(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFinal(line, pos); }
    Token new3(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNative(line, pos); }
    Token new4(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPublic(line, pos); }
    Token new5(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TProtected(line, pos); }
    Token new6(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPrivate(line, pos); }
    Token new7(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStatic(line, pos); }
    Token new8(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSynchronized(line, pos); }
    Token new9(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTransient(line, pos); }
    Token new10(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TVolatile(line, pos); }
    Token new11(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStrictfp(line, pos); }
    Token new12(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEnum(line, pos); }
    Token new13(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAnnotation(line, pos); }
    Token new14(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TClass(line, pos); }
    Token new15(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInterface(line, pos); }
    Token new16(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TVoid(line, pos); }
    Token new17(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBoolean(line, pos); }
    Token new18(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TByte(line, pos); }
    Token new19(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TShort(line, pos); }
    Token new20(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TChar(line, pos); }
    Token new21(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInt(line, pos); }
    Token new22(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLong(line, pos); }
    Token new23(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFloat(line, pos); }
    Token new24(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDouble(line, pos); }
    Token new25(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNullType(line, pos); }
    Token new26(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TUnknown(line, pos); }
    Token new27(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TExtends(line, pos); }
    Token new28(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TImplements(line, pos); }
    Token new29(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBreakpoint(line, pos); }
    Token new30(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCase(line, pos); }
    Token new31(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCatch(line, pos); }
    Token new32(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmp(line, pos); }
    Token new33(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpg(line, pos); }
    Token new34(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpl(line, pos); }
    Token new35(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDefault(line, pos); }
    Token new36(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEntermonitor(line, pos); }
    Token new37(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TExitmonitor(line, pos); }
    Token new38(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TGoto(line, pos); }
    Token new39(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIf(line, pos); }
    Token new40(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInstanceof(line, pos); }
    Token new41(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TInterfaceinvoke(line, pos); }
    Token new42(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLengthof(line, pos); }
    Token new43(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLookupswitch(line, pos); }
    Token new44(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNeg(line, pos); }
    Token new45(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNew(line, pos); }
    Token new46(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNewarray(line, pos); }
    Token new47(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNewmultiarray(line, pos); }
    Token new48(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNop(line, pos); }
    Token new49(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRet(line, pos); }
    Token new50(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TReturn(line, pos); }
    Token new51(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSpecialinvoke(line, pos); }
    Token new52(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStaticinvoke(line, pos); }
    Token new53(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDynamicinvoke(line, pos); }
    Token new54(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTableswitch(line, pos); }
    Token new55(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TThrow(line, pos); }
    Token new56(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TThrows(line, pos); }
    Token new57(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TVirtualinvoke(line, pos); }
    Token new58(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNull(line, pos); }
    Token new59(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFrom(line, pos); }
    Token new60(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTo(line, pos); }
    Token new61(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TWith(line, pos); }
    Token new62(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCls(line, pos); }
    Token new63(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComma(line, pos); }
    Token new64(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLBrace(line, pos); }
    Token new65(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRBrace(line, pos); }
    Token new66(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSemicolon(line, pos); }
    Token new67(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLBracket(line, pos); }
    Token new68(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRBracket(line, pos); }
    Token new69(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLParen(line, pos); }
    Token new70(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRParen(line, pos); }
    Token new71(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TColon(line, pos); }
    Token new72(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDot(line, pos); }
    Token new73(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TQuote(line, pos); }
    Token new74(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TColonEquals(line, pos); }
    Token new75(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEquals(line, pos); }
    Token new76(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAnd(line, pos); }
    Token new77(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOr(line, pos); }
    Token new78(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TXor(line, pos); }
    Token new79(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMod(line, pos); }
    Token new80(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpeq(line, pos); }
    Token new81(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpne(line, pos); }
    Token new82(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpgt(line, pos); }
    Token new83(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmpge(line, pos); }
    Token new84(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmplt(line, pos); }
    Token new85(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCmple(line, pos); }
    Token new86(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TShl(line, pos); }
    Token new87(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TShr(line, pos); }
    Token new88(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TUshr(line, pos); }
    Token new89(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPlus(line, pos); }
    Token new90(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMinus(line, pos); }
    Token new91(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMult(line, pos); }
    Token new92(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDiv(line, pos); }
    Token new93(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TQuotedName(text, line, pos); }
    Token new94(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFullIdentifier(text, line, pos); }
    Token new95(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIdentifier(text, line, pos); }
    Token new96(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAtIdentifier(text, line, pos); }
    Token new97(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBoolConstant(text, line, pos); }
    Token new98(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIntegerConstant(text, line, pos); }
    Token new99(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFloatConstant(text, line, pos); }
    Token new100(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStringConstant(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(@SuppressWarnings("hiding") Token token) throws IOException
    {
        @SuppressWarnings("hiding") String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {33, 33, 5}, {34, 34, 6}, {35, 35, 7}, {36, 36, 8}, {37, 37, 9}, {38, 38, 10}, {39, 39, 11}, {40, 40, 12}, {41, 41, 13}, {42, 42, 14}, {43, 43, 15}, {44, 44, 16}, {45, 45, 17}, {46, 46, 18}, {47, 47, 19}, {48, 48, 20}, {49, 57, 21}, {58, 58, 22}, {59, 59, 23}, {60, 60, 24}, {61, 61, 25}, {62, 62, 26}, {64, 64, 27}, {65, 90, 28}, {91, 91, 29}, {92, 92, 30}, {93, 93, 31}, {94, 94, 32}, {95, 95, 33}, {97, 97, 34}, {98, 98, 35}, {99, 99, 36}, {100, 100, 37}, {101, 101, 38}, {102, 102, 39}, {103, 103, 40}, {104, 104, 41}, {105, 105, 42}, {106, 107, 41}, {108, 108, 43}, {109, 109, 41}, {110, 110, 44}, {111, 111, 41}, {112, 112, 45}, {113, 113, 41}, {114, 114, 46}, {115, 115, 47}, {116, 116, 48}, {117, 117, 49}, {118, 118, 50}, {119, 119, 51}, {120, 122, 41}, {123, 123, 52}, {124, 124, 53}, {125, 125, 54}, },
            {{9, 32, -2}, {47, 47, 55}, },
            {{9, 47, -3}, },
            {{9, 47, -3}, },
            {{9, 47, -3}, },
            {{61, 61, 56}, },
            {{0, 33, 57}, {34, 34, 58}, {35, 91, 59}, {92, 92, 60}, {93, 127, 61}, },
            {{45, 45, 62}, {73, 73, 63}, {78, 78, 64}, },
            {{36, 36, 65}, {39, 39, 66}, {45, 45, 67}, {46, 46, 68}, {48, 57, 69}, {65, 90, 70}, {92, 92, 71}, {95, 95, 72}, {97, 122, 73}, },
            {},
            {},
            {{0, 9, 74}, {11, 12, 74}, {14, 35, 74}, {36, 36, 75}, {37, 38, 74}, {39, 39, 66}, {40, 44, 74}, {45, 45, 76}, {46, 46, 77}, {47, 47, 74}, {48, 57, 78}, {58, 64, 74}, {65, 90, 79}, {91, 91, 74}, {92, 92, 80}, {93, 94, 74}, {95, 95, 81}, {96, 96, 74}, {97, 122, 82}, {123, 65535, 74}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{42, 42, 83}, {47, 47, 84}, },
            {{46, 46, 85}, {48, 55, 86}, {56, 57, 21}, {76, 76, 87}, {88, 88, 88}, {120, 120, 89}, },
            {{46, 46, 85}, {48, 57, 21}, {76, 76, 87}, },
            {{61, 61, 90}, },
            {},
            {{60, 60, 91}, {61, 61, 92}, {99, 99, 93}, {105, 105, 94}, },
            {{61, 61, 95}, },
            {{61, 61, 96}, {62, 62, 97}, },
            {{99, 99, 98}, {112, 112, 99}, {116, 116, 100}, },
            {{36, 122, -10}, },
            {},
            {{32, 32, 101}, {34, 34, 102}, {35, 35, 103}, {39, 39, 104}, {46, 46, 105}, {92, 92, 106}, {98, 98, 107}, {102, 102, 108}, {110, 110, 109}, {114, 114, 110}, {116, 116, 111}, {117, 117, 112}, },
            {},
            {},
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 73}, {98, 98, 113}, {99, 109, 73}, {110, 110, 114}, {111, 122, 73}, },
            {{36, 95, -10}, {97, 110, 73}, {111, 111, 115}, {112, 113, 73}, {114, 114, 116}, {115, 120, 73}, {121, 121, 117}, {122, 122, 73}, },
            {{36, 95, -10}, {97, 97, 118}, {98, 103, 73}, {104, 104, 119}, {105, 107, 73}, {108, 108, 120}, {109, 109, 121}, {110, 122, 73}, },
            {{36, 95, -10}, {97, 100, 73}, {101, 101, 122}, {102, 110, 73}, {111, 111, 123}, {112, 120, 73}, {121, 121, 124}, {122, 122, 73}, },
            {{36, 95, -10}, {97, 109, 73}, {110, 110, 125}, {111, 119, 73}, {120, 120, 126}, {121, 122, 73}, },
            {{36, 95, -10}, {97, 97, 127}, {98, 104, 73}, {105, 105, 128}, {106, 107, 73}, {108, 108, 129}, {109, 113, 73}, {114, 114, 130}, {115, 122, 73}, },
            {{36, 110, -37}, {111, 111, 131}, {112, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 101, 73}, {102, 102, 132}, {103, 108, 73}, {109, 109, 133}, {110, 110, 134}, {111, 122, 73}, },
            {{36, 100, -39}, {101, 101, 135}, {102, 110, 73}, {111, 111, 136}, {112, 122, 73}, },
            {{36, 95, -10}, {97, 97, 137}, {98, 100, 73}, {101, 101, 138}, {102, 110, 73}, {111, 111, 139}, {112, 116, 73}, {117, 117, 140}, {118, 122, 73}, },
            {{36, 95, -10}, {97, 113, 73}, {114, 114, 141}, {115, 116, 73}, {117, 117, 142}, {118, 122, 73}, },
            {{36, 100, -39}, {101, 101, 143}, {102, 122, 73}, },
            {{36, 95, -10}, {97, 103, 73}, {104, 104, 144}, {105, 111, 73}, {112, 112, 145}, {113, 115, 73}, {116, 116, 146}, {117, 120, 73}, {121, 121, 147}, {122, 122, 73}, },
            {{36, 95, -10}, {97, 97, 148}, {98, 103, 73}, {104, 104, 149}, {105, 110, 73}, {111, 111, 150}, {112, 113, 73}, {114, 114, 151}, {115, 122, 73}, },
            {{36, 109, -40}, {110, 110, 152}, {111, 122, 73}, },
            {{36, 95, -10}, {97, 104, 73}, {105, 105, 153}, {106, 110, 73}, {111, 111, 154}, {112, 122, 73}, },
            {{36, 104, -52}, {105, 105, 155}, {106, 122, 73}, },
            {},
            {},
            {},
            {{42, 47, -21}, },
            {},
            {{0, 127, -8}, },
            {},
            {{0, 127, -8}, },
            {{32, 32, 156}, {34, 34, 157}, {35, 35, 158}, {39, 39, 159}, {46, 46, 160}, {92, 92, 161}, {98, 98, 162}, {102, 102, 163}, {110, 110, 164}, {114, 114, 165}, {116, 116, 166}, {117, 117, 167}, },
            {{0, 127, -8}, },
            {{73, 73, 63}, },
            {{110, 110, 168}, },
            {{97, 97, 169}, },
            {{36, 122, -10}, },
            {{46, 46, 68}, },
            {{36, 122, -10}, },
            {{36, 36, 170}, {39, 39, 171}, {65, 90, 172}, {92, 92, 173}, {95, 95, 174}, {97, 122, 175}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{32, 32, 176}, {34, 34, 177}, {35, 35, 178}, {39, 39, 179}, {46, 46, 180}, {92, 92, 181}, {98, 98, 182}, {102, 102, 183}, {110, 110, 184}, {114, 114, 185}, {116, 116, 186}, {117, 117, 187}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{0, 12, -13}, {14, 38, 74}, {39, 39, 188}, {40, 65535, 74}, },
            {{0, 38, -13}, {39, 39, 189}, {40, 65535, -13}, },
            {{0, 65535, -77}, },
            {{0, 35, -13}, {36, 36, 190}, {37, 38, 74}, {39, 39, 191}, {40, 64, 74}, {65, 90, 192}, {91, 91, 74}, {92, 92, 193}, {93, 94, 74}, {95, 95, 194}, {96, 96, 74}, {97, 122, 195}, {123, 65535, 74}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 12, -13}, {14, 31, 74}, {32, 32, 196}, {33, 33, 74}, {34, 34, 197}, {35, 35, 198}, {36, 38, 74}, {39, 39, 199}, {40, 45, 74}, {46, 46, 200}, {47, 91, 74}, {92, 92, 201}, {93, 97, 74}, {98, 98, 202}, {99, 101, 74}, {102, 102, 203}, {103, 109, 74}, {110, 110, 204}, {111, 113, 74}, {114, 114, 205}, {115, 115, 74}, {116, 116, 206}, {117, 117, 207}, {118, 65535, 74}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 41, 208}, {42, 42, 209}, {43, 65535, 208}, },
            {{0, 8, 210}, {9, 9, 211}, {10, 10, 2}, {11, 12, 210}, {13, 13, 3}, {14, 31, 210}, {32, 32, 212}, {33, 46, 210}, {47, 47, 213}, {48, 65535, 210}, },
            {{48, 57, 214}, },
            {{46, 76, -22}, },
            {},
            {{48, 57, 215}, {65, 70, 216}, {97, 102, 217}, },
            {{48, 102, -90}, },
            {},
            {},
            {},
            {{108, 108, 218}, },
            {{110, 110, 219}, },
            {},
            {},
            {{62, 62, 220}, },
            {{97, 97, 221}, },
            {{97, 97, 222}, },
            {{104, 104, 223}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{48, 57, 224}, {65, 70, 225}, {97, 102, 226}, },
            {{36, 95, -10}, {97, 114, 73}, {115, 115, 227}, {116, 122, 73}, },
            {{36, 109, -40}, {110, 110, 228}, {111, 122, 73}, },
            {{36, 110, -37}, {111, 111, 229}, {112, 122, 73}, },
            {{36, 100, -39}, {101, 101, 230}, {102, 122, 73}, },
            {{36, 95, -10}, {97, 115, 73}, {116, 116, 231}, {117, 122, 73}, },
            {{36, 114, -115}, {115, 115, 232}, {116, 116, 233}, {117, 122, 73}, },
            {{36, 95, -10}, {97, 97, 234}, {98, 122, 73}, },
            {{36, 95, -10}, {97, 97, 235}, {98, 114, 73}, {115, 115, 236}, {116, 122, 73}, },
            {{36, 95, -10}, {97, 111, 73}, {112, 112, 237}, {113, 122, 73}, },
            {{36, 101, -44}, {102, 102, 238}, {103, 122, 73}, },
            {{36, 95, -10}, {97, 116, 73}, {117, 117, 239}, {118, 122, 73}, },
            {{36, 109, -40}, {110, 110, 240}, {111, 122, 73}, },
            {{36, 115, -119}, {116, 116, 241}, {117, 117, 242}, {118, 122, 73}, },
            {{36, 104, -52}, {105, 105, 243}, {106, 115, 73}, {116, 116, 244}, {117, 122, 73}, },
            {{36, 95, -10}, {97, 107, 73}, {108, 108, 245}, {109, 122, 73}, },
            {{36, 109, -40}, {110, 110, 246}, {111, 122, 73}, },
            {{36, 110, -37}, {111, 111, 247}, {112, 122, 73}, },
            {{36, 110, -37}, {111, 111, 248}, {112, 122, 73}, },
            {{36, 115, -119}, {116, 116, 249}, {117, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 111, -123}, {112, 112, 250}, {113, 122, 73}, },
            {{36, 114, -115}, {115, 115, 251}, {116, 116, 252}, {117, 122, 73}, },
            {{36, 109, -40}, {110, 110, 253}, {111, 122, 73}, },
            {{36, 109, -40}, {110, 110, 254}, {111, 111, 255}, {112, 122, 73}, },
            {{36, 115, -119}, {116, 116, 256}, {117, 122, 73}, },
            {{36, 95, -10}, {97, 102, 73}, {103, 103, 257}, {104, 118, 73}, {119, 119, 258}, {120, 122, 73}, },
            {{36, 111, -123}, {112, 112, 259}, {113, 122, 73}, },
            {{36, 107, -129}, {108, 108, 260}, {109, 122, 73}, },
            {{36, 104, -52}, {105, 105, 261}, {106, 110, 73}, {111, 111, 262}, {112, 122, 73}, },
            {{36, 97, -36}, {98, 98, 263}, {99, 122, 73}, },
            {{36, 115, -119}, {116, 116, 264}, {117, 122, 73}, },
            {{36, 110, -37}, {111, 111, 265}, {112, 122, 73}, },
            {{36, 100, -39}, {101, 101, 266}, {102, 122, 73}, },
            {{36, 95, -10}, {97, 97, 267}, {98, 113, 73}, {114, 114, 268}, {115, 122, 73}, },
            {{36, 109, -40}, {110, 110, 269}, {111, 122, 73}, },
            {{36, 97, -36}, {98, 98, 270}, {99, 122, 73}, },
            {{36, 113, -47}, {114, 114, 271}, {115, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 272}, {98, 116, 73}, {117, 117, 273}, {118, 122, 73}, },
            {{36, 95, -10}, {97, 106, 73}, {107, 107, 274}, {108, 122, 73}, },
            {{36, 113, -47}, {114, 114, 275}, {115, 122, 73}, },
            {{36, 104, -52}, {105, 105, 276}, {106, 107, 73}, {108, 108, 277}, {109, 122, 73}, },
            {{36, 115, -119}, {116, 116, 278}, {117, 122, 73}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{48, 57, 279}, {65, 70, 280}, {97, 102, 281}, },
            {{102, 102, 282}, },
            {{78, 78, 283}, },
            {{36, 36, 284}, {39, 39, 285}, {45, 45, 286}, {46, 46, 68}, {48, 57, 287}, {65, 90, 288}, {92, 92, 289}, {95, 95, 290}, {97, 122, 291}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{32, 32, 292}, {34, 34, 293}, {35, 35, 294}, {39, 39, 295}, {46, 46, 296}, {92, 92, 297}, {98, 98, 298}, {102, 102, 299}, {110, 110, 300}, {114, 114, 301}, {116, 116, 302}, {117, 117, 303}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{48, 57, 304}, {65, 70, 305}, {97, 102, 306}, },
            {},
            {{46, 46, 68}, },
            {{0, 35, -13}, {36, 36, 307}, {37, 38, 74}, {39, 39, 308}, {40, 44, 74}, {45, 45, 309}, {46, 47, -13}, {48, 57, 310}, {58, 64, 74}, {65, 90, 311}, {91, 91, 74}, {92, 92, 312}, {93, 94, 74}, {95, 95, 313}, {96, 96, 74}, {97, 122, 314}, {123, 65535, 74}, },
            {{36, 122, -172}, },
            {{0, 65535, -192}, },
            {{0, 31, -82}, {32, 32, 315}, {33, 33, 74}, {34, 34, 316}, {35, 35, 317}, {36, 38, 74}, {39, 39, 318}, {40, 45, 74}, {46, 46, 319}, {47, 91, 74}, {92, 92, 320}, {93, 97, 74}, {98, 98, 321}, {99, 101, 74}, {102, 102, 322}, {103, 109, 74}, {110, 110, 323}, {111, 113, 74}, {114, 114, 324}, {115, 115, 74}, {116, 116, 325}, {117, 117, 326}, {118, 65535, 74}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{36, 36, 327}, {39, 39, 66}, {45, 45, 328}, {46, 46, 68}, {48, 57, 329}, {65, 90, 330}, {92, 92, 331}, {95, 95, 332}, {97, 122, 333}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 39, -76}, {40, 47, 74}, {48, 57, 334}, {58, 64, 74}, {65, 70, 335}, {71, 96, 74}, {97, 102, 336}, {103, 65535, 74}, },
            {{0, 65535, -85}, },
            {{0, 41, 337}, {42, 42, 209}, {43, 46, 337}, {47, 47, 338}, {48, 65535, 337}, },
            {{0, 65535, -86}, },
            {{0, 65535, -86}, },
            {{0, 65535, -86}, },
            {{0, 32, -86}, {33, 41, 210}, {42, 42, 339}, {43, 46, 210}, {47, 47, 340}, {48, 65535, 210}, },
            {{48, 57, 214}, {69, 69, 341}, {70, 70, 342}, {101, 101, 343}, {102, 102, 344}, },
            {{48, 70, -90}, {76, 76, 87}, {97, 102, 217}, },
            {{48, 102, -217}, },
            {{48, 102, -217}, },
            {{105, 105, 345}, },
            {{105, 105, 346}, },
            {},
            {{117, 117, 347}, },
            {{114, 114, 348}, },
            {{105, 105, 349}, },
            {{48, 57, 350}, {65, 70, 351}, {97, 102, 352}, },
            {{48, 102, -226}, },
            {{48, 102, -226}, },
            {{36, 115, -119}, {116, 116, 353}, {117, 122, 73}, },
            {{36, 110, -37}, {111, 111, 354}, {112, 122, 73}, },
            {{36, 107, -129}, {108, 108, 355}, {109, 122, 73}, },
            {{36, 95, -10}, {97, 97, 356}, {98, 122, 73}, },
            {{36, 100, -39}, {101, 101, 357}, {102, 122, 73}, },
            {{36, 100, -39}, {101, 101, 358}, {102, 122, 73}, },
            {{36, 95, -10}, {97, 98, 73}, {99, 99, 359}, {100, 122, 73}, },
            {{36, 113, -47}, {114, 114, 360}, {115, 122, 73}, },
            {{36, 114, -115}, {115, 115, 361}, {116, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 102, -140}, {103, 103, 362}, {104, 107, 73}, {108, 108, 363}, {109, 122, 73}, },
            {{36, 95, -10}, {97, 97, 364}, {98, 122, 73}, },
            {{36, 97, -36}, {98, 98, 365}, {99, 122, 73}, },
            {{36, 95, -10}, {97, 97, 366}, {98, 122, 73}, },
            {{36, 100, -39}, {101, 101, 367}, {102, 122, 73}, },
            {{36, 95, -10}, {97, 108, 73}, {109, 109, 368}, {110, 122, 73}, },
            {{36, 115, -119}, {116, 116, 369}, {117, 122, 73}, },
            {{36, 100, -39}, {101, 101, 370}, {102, 122, 73}, },
            {{36, 114, -115}, {115, 115, 371}, {116, 122, 73}, },
            {{36, 95, -10}, {97, 97, 372}, {98, 122, 73}, },
            {{36, 95, -10}, {97, 97, 373}, {98, 122, 73}, },
            {{36, 108, -244}, {109, 109, 374}, {110, 122, 73}, },
            {{36, 110, -37}, {111, 111, 375}, {112, 122, 73}, },
            {{36, 107, -129}, {108, 108, 376}, {109, 122, 73}, },
            {{36, 115, -119}, {116, 116, 377}, {117, 122, 73}, },
            {{36, 100, -39}, {101, 101, 378}, {102, 122, 73}, },
            {{36, 102, -140}, {103, 103, 379}, {104, 122, 73}, },
            {{36, 102, -140}, {103, 103, 380}, {104, 122, 73}, },
            {{36, 106, -154}, {107, 107, 381}, {108, 122, 73}, },
            {{36, 104, -52}, {105, 105, 382}, {106, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 383}, {98, 108, 73}, {109, 109, 384}, {110, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 107, -129}, {108, 108, 385}, {109, 122, 73}, },
            {{36, 95, -10}, {97, 117, 73}, {118, 118, 386}, {119, 122, 73}, },
            {{36, 115, -119}, {116, 116, 387}, {117, 122, 73}, },
            {{36, 107, -129}, {108, 108, 388}, {109, 122, 73}, },
            {{36, 116, -125}, {117, 117, 389}, {118, 122, 73}, },
            {{36, 113, -47}, {114, 114, 390}, {115, 122, 73}, },
            {{36, 98, -235}, {99, 99, 391}, {100, 122, 73}, },
            {{36, 115, -119}, {116, 116, 392}, {117, 122, 73}, },
            {{36, 104, -52}, {105, 105, 393}, {106, 122, 73}, },
            {{36, 98, -235}, {99, 99, 394}, {100, 122, 73}, },
            {{36, 107, -129}, {108, 108, 395}, {109, 122, 73}, },
            {{36, 110, -37}, {111, 111, 396}, {112, 122, 73}, },
            {{36, 109, -40}, {110, 110, 397}, {111, 122, 73}, },
            {{36, 100, -39}, {101, 101, 398}, {102, 122, 73}, },
            {{36, 109, -40}, {110, 110, 399}, {111, 122, 73}, },
            {{36, 115, -119}, {116, 116, 400}, {117, 122, 73}, },
            {{36, 95, -10}, {97, 99, 73}, {100, 100, 401}, {101, 122, 73}, },
            {{36, 95, -10}, {97, 97, 402}, {98, 122, 73}, },
            {{36, 103, -49}, {104, 104, 403}, {105, 122, 73}, },
            {{48, 57, 404}, {65, 70, 405}, {97, 102, 406}, },
            {{48, 102, -281}, },
            {{48, 102, -281}, },
            {{105, 105, 407}, },
            {{70, 70, 408}, {102, 102, 409}, },
            {{36, 122, -172}, },
            {{46, 46, 68}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{32, 32, 410}, {34, 34, 411}, {35, 35, 412}, {39, 39, 413}, {46, 46, 414}, {92, 92, 415}, {98, 98, 416}, {102, 102, 417}, {110, 110, 418}, {114, 114, 419}, {116, 116, 420}, {117, 117, 421}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{48, 57, 422}, {65, 70, 423}, {97, 102, 424}, },
            {{48, 57, 425}, {65, 70, 426}, {97, 102, 427}, },
            {{48, 102, -306}, },
            {{48, 102, -306}, },
            {{0, 65535, -192}, },
            {{46, 46, 68}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 31, -82}, {32, 32, 428}, {33, 33, 74}, {34, 34, 429}, {35, 35, 430}, {36, 38, 74}, {39, 39, 431}, {40, 45, 74}, {46, 46, 432}, {47, 91, 74}, {92, 92, 433}, {93, 97, 74}, {98, 98, 434}, {99, 101, 74}, {102, 102, 435}, {103, 109, 74}, {110, 110, 436}, {111, 113, 74}, {114, 114, 437}, {115, 115, 74}, {116, 116, 438}, {117, 117, 439}, {118, 65535, 74}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{36, 122, -172}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 47, -209}, {48, 57, 440}, {58, 64, 74}, {65, 70, 441}, {71, 96, 74}, {97, 102, 442}, {103, 65535, 74}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{32, 32, 443}, {34, 34, 444}, {35, 35, 445}, {39, 39, 446}, {46, 46, 447}, {92, 92, 448}, {98, 98, 449}, {102, 102, 450}, {110, 110, 451}, {114, 114, 452}, {116, 116, 453}, {117, 117, 454}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{0, 47, -209}, {48, 57, 455}, {58, 64, 74}, {65, 70, 456}, {71, 96, 74}, {97, 102, 457}, {103, 65535, 74}, },
            {{0, 65535, -336}, },
            {{0, 65535, -336}, },
            {{0, 41, 458}, {42, 42, 459}, {43, 65535, 458}, },
            {{9, 47, -3}, },
            {{0, 8, 460}, {9, 9, 461}, {10, 10, 462}, {11, 12, 460}, {13, 13, 463}, {14, 31, 460}, {32, 32, 464}, {33, 41, 460}, {42, 42, 465}, {43, 46, 460}, {47, 47, 466}, {48, 65535, 460}, },
            {{0, 65535, -215}, },
            {{43, 43, 467}, {45, 45, 468}, {48, 57, 469}, },
            {},
            {{43, 57, -343}, },
            {},
            {{110, 110, 470}, },
            {{116, 116, 471}, },
            {{103, 103, 472}, },
            {{97, 97, 473}, },
            {{115, 115, 474}, },
            {{48, 57, 475}, {65, 70, 476}, {97, 102, 477}, },
            {{48, 102, -352}, },
            {{48, 102, -352}, },
            {{36, 113, -47}, {114, 114, 478}, {115, 122, 73}, },
            {{36, 115, -119}, {116, 116, 479}, {117, 122, 73}, },
            {{36, 100, -39}, {101, 101, 480}, {102, 122, 73}, },
            {{36, 106, -154}, {107, 107, 481}, {108, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 103, -49}, {104, 104, 482}, {105, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 114, -115}, {115, 115, 483}, {116, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 116, -125}, {117, 117, 484}, {118, 122, 73}, },
            {{36, 107, -129}, {108, 108, 485}, {109, 122, 73}, },
            {{36, 108, -244}, {109, 109, 486}, {110, 122, 73}, },
            {{36, 113, -47}, {114, 114, 487}, {115, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 108, -244}, {109, 109, 488}, {110, 122, 73}, },
            {{36, 109, -40}, {110, 110, 489}, {111, 122, 73}, },
            {{36, 100, -39}, {101, 101, 490}, {102, 122, 73}, },
            {{36, 107, -129}, {108, 108, 491}, {109, 122, 73}, },
            {{36, 115, -119}, {116, 116, 492}, {117, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 493}, {102, 122, 73}, },
            {{36, 95, -10}, {97, 97, 494}, {98, 122, 73}, },
            {{36, 113, -47}, {114, 114, 495}, {115, 122, 73}, },
            {{36, 115, -119}, {116, 116, 496}, {117, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 116, -125}, {117, 117, 497}, {118, 122, 73}, },
            {{36, 117, -263}, {118, 118, 498}, {119, 122, 73}, },
            {{36, 113, -47}, {114, 114, 499}, {115, 122, 73}, },
            {{36, 116, -125}, {117, 117, 500}, {118, 122, 73}, },
            {{36, 92, -10}, {95, 95, 501}, {97, 122, 73}, },
            {{36, 95, -10}, {97, 97, 502}, {98, 122, 73}, },
            {{36, 100, -39}, {101, 101, 503}, {102, 122, 73}, },
            {{36, 104, -52}, {105, 105, 504}, {106, 122, 73}, },
            {{36, 113, -47}, {114, 114, 505}, {115, 122, 73}, },
            {{36, 115, -119}, {116, 116, 506}, {117, 122, 73}, },
            {{36, 104, -52}, {105, 105, 507}, {106, 122, 73}, },
            {{36, 104, -52}, {105, 105, 508}, {106, 122, 73}, },
            {{36, 98, -235}, {99, 99, 509}, {100, 122, 73}, },
            {{36, 103, -49}, {104, 104, 510}, {105, 122, 73}, },
            {{36, 100, -39}, {101, 101, 511}, {102, 122, 73}, },
            {{36, 95, -10}, {97, 118, 73}, {119, 119, 512}, {120, 122, 73}, },
            {{36, 114, -115}, {115, 115, 513}, {116, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 514}, {112, 122, 73}, },
            {{36, 116, -125}, {117, 117, 515}, {118, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 115, -119}, {116, 116, 516}, {117, 122, 73}, },
            {{36, 122, -10}, },
            {{48, 57, 517}, {65, 70, 518}, {97, 102, 519}, },
            {{48, 102, -406}, },
            {{48, 102, -406}, },
            {{110, 110, 520}, },
            {},
            {},
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{48, 57, 521}, {65, 70, 522}, {97, 102, 523}, },
            {{48, 57, 524}, {65, 70, 525}, {97, 102, 526}, },
            {{48, 102, -424}, },
            {{48, 102, -424}, },
            {{48, 57, 527}, {65, 70, 528}, {97, 102, 529}, },
            {{48, 102, -427}, },
            {{48, 102, -427}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{36, 122, -172}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 47, -209}, {48, 57, 530}, {58, 64, 74}, {65, 70, 531}, {71, 96, 74}, {97, 102, 532}, {103, 65535, 74}, },
            {{0, 47, -209}, {48, 57, 533}, {58, 64, 74}, {65, 70, 534}, {71, 96, 74}, {97, 102, 535}, {103, 65535, 74}, },
            {{0, 65535, -442}, },
            {{0, 65535, -442}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{48, 57, 536}, {65, 70, 537}, {97, 102, 538}, },
            {{0, 47, -209}, {48, 57, 539}, {58, 64, 74}, {65, 70, 540}, {71, 96, 74}, {97, 102, 541}, {103, 65535, 74}, },
            {{0, 65535, -457}, },
            {{0, 65535, -457}, },
            {{0, 65535, -339}, },
            {{0, 41, 337}, {42, 42, 459}, {43, 65535, -211}, },
            {{0, 65535, -341}, },
            {{0, 65535, -341}, },
            {{0, 8, 208}, {9, 9, 542}, {10, 10, 462}, {11, 12, 208}, {13, 13, 463}, {14, 31, 208}, {32, 32, 543}, {33, 41, 208}, {42, 42, 209}, {43, 46, 208}, {47, 47, 544}, {48, 65535, 208}, },
            {{0, 65535, -464}, },
            {{0, 65535, -341}, },
            {{0, 8, 545}, {9, 9, 546}, {10, 10, 547}, {11, 12, 545}, {13, 13, 548}, {14, 31, 545}, {32, 32, 549}, {33, 41, 545}, {42, 42, 465}, {43, 46, 545}, {47, 47, 550}, {48, 65535, 545}, },
            {{0, 41, -341}, {42, 42, 551}, {43, 46, 460}, {47, 47, 552}, {48, 65535, 460}, },
            {{48, 57, 469}, },
            {{48, 57, 469}, },
            {{48, 57, 469}, {70, 70, 342}, {102, 102, 344}, },
            {{105, 105, 553}, },
            {{62, 62, 554}, },
            {{104, 104, 555}, },
            {{109, 109, 556}, },
            {{58, 58, 557}, },
            {{48, 57, 558}, {65, 70, 559}, {97, 102, 560}, },
            {{48, 102, -477}, },
            {{48, 102, -477}, },
            {{36, 95, -10}, {97, 97, 561}, {98, 122, 73}, },
            {{36, 95, -10}, {97, 97, 562}, {98, 122, 73}, },
            {{36, 95, -10}, {97, 97, 563}, {98, 122, 73}, },
            {{36, 111, -123}, {112, 112, 564}, {113, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 107, -129}, {108, 108, 565}, {109, 122, 73}, },
            {{36, 100, -39}, {101, 101, 566}, {102, 122, 73}, },
            {{36, 104, -52}, {105, 105, 567}, {106, 122, 73}, },
            {{36, 108, -244}, {109, 109, 568}, {110, 122, 73}, },
            {{36, 110, -37}, {111, 111, 569}, {112, 122, 73}, },
            {{36, 99, -278}, {100, 100, 570}, {101, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 108, -244}, {109, 109, 571}, {110, 122, 73}, },
            {{36, 109, -40}, {110, 110, 572}, {111, 122, 73}, },
            {{36, 101, -44}, {102, 102, 573}, {103, 122, 73}, },
            {{36, 103, -49}, {104, 104, 574}, {105, 122, 73}, },
            {{36, 111, -123}, {112, 112, 575}, {113, 122, 73}, },
            {{36, 100, -39}, {101, 101, 576}, {102, 122, 73}, },
            {{36, 113, -47}, {114, 114, 577}, {115, 122, 73}, },
            {{36, 107, -129}, {108, 108, 578}, {109, 122, 73}, },
            {{36, 115, -119}, {116, 116, 579}, {117, 122, 73}, },
            {{36, 115, -119}, {116, 116, 580}, {117, 122, 73}, },
            {{36, 98, -235}, {99, 99, 581}, {100, 122, 73}, },
            {{36, 98, -235}, {99, 99, 582}, {100, 122, 73}, },
            {{36, 109, -40}, {110, 110, 583}, {111, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 584}, {98, 122, 73}, },
            {{36, 98, -235}, {99, 99, 585}, {100, 122, 73}, },
            {{36, 115, -119}, {116, 116, 586}, {117, 122, 73}, },
            {{36, 113, -47}, {114, 114, 587}, {115, 122, 73}, },
            {{36, 114, -115}, {115, 115, 588}, {116, 122, 73}, },
            {{36, 114, -115}, {115, 115, 589}, {116, 122, 73}, },
            {{36, 104, -52}, {105, 105, 590}, {106, 122, 73}, },
            {{36, 118, -398}, {119, 119, 591}, {120, 122, 73}, },
            {{36, 95, -10}, {97, 97, 592}, {98, 122, 73}, },
            {{36, 104, -52}, {105, 105, 593}, {106, 122, 73}, },
            {{48, 57, 594}, {65, 70, 595}, {97, 102, 596}, },
            {{48, 102, -519}, },
            {{48, 102, -519}, },
            {{105, 105, 597}, },
            {{48, 57, 598}, {65, 70, 599}, {97, 102, 600}, },
            {{48, 102, -523}, },
            {{48, 102, -523}, },
            {{48, 57, 601}, {65, 70, 602}, {97, 102, 603}, },
            {{48, 102, -526}, },
            {{48, 102, -526}, },
            {{48, 57, 604}, {65, 70, 605}, {97, 102, 606}, },
            {{48, 102, -529}, },
            {{48, 102, -529}, },
            {{0, 47, -209}, {48, 57, 607}, {58, 64, 74}, {65, 70, 608}, {71, 96, 74}, {97, 102, 609}, {103, 65535, 74}, },
            {{0, 65535, -532}, },
            {{0, 65535, -532}, },
            {{0, 47, -209}, {48, 57, 610}, {58, 64, 74}, {65, 70, 611}, {71, 96, 74}, {97, 102, 612}, {103, 65535, 74}, },
            {{0, 65535, -535}, },
            {{0, 65535, -535}, },
            {{48, 57, 613}, {65, 70, 614}, {97, 102, 615}, },
            {{48, 102, -538}, },
            {{48, 102, -538}, },
            {{0, 47, -209}, {48, 57, 616}, {58, 64, 74}, {65, 70, 617}, {71, 96, 74}, {97, 102, 618}, {103, 65535, 74}, },
            {{0, 65535, -541}, },
            {{0, 65535, -541}, },
            {{0, 65535, -464}, },
            {{0, 65535, -464}, },
            {{0, 41, 208}, {42, 42, 619}, {43, 46, 208}, {47, 47, 620}, {48, 65535, 208}, },
            {{0, 8, 621}, {9, 9, 622}, {10, 10, 623}, {11, 12, 621}, {13, 13, 624}, {14, 31, 621}, {32, 32, 625}, {33, 41, 621}, {42, 42, 626}, {43, 46, 621}, {47, 47, 627}, {48, 65535, 621}, },
            {{0, 65535, -547}, },
            {{0, 8, 458}, {9, 9, 628}, {10, 10, 623}, {11, 12, 458}, {13, 13, 624}, {14, 31, 458}, {32, 32, 629}, {33, 41, 458}, {42, 42, 459}, {43, 46, 458}, {47, 47, 630}, {48, 65535, 458}, },
            {{0, 65535, -549}, },
            {{0, 65535, -547}, },
            {{0, 65535, -215}, },
            {{0, 8, 631}, {9, 9, 632}, {10, 10, 633}, {11, 12, 631}, {13, 13, 634}, {14, 31, 631}, {32, 32, 635}, {33, 41, 631}, {42, 42, 465}, {43, 46, 631}, {47, 47, 636}, {48, 65535, 631}, },
            {{0, 65535, -468}, },
            {{116, 116, 637}, },
            {},
            {{116, 116, 638}, },
            {{101, 101, 639}, },
            {},
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 98, -235}, {99, 99, 640}, {100, 122, 73}, },
            {{36, 115, -119}, {116, 116, 641}, {117, 122, 73}, },
            {{36, 109, -40}, {110, 110, 642}, {111, 122, 73}, },
            {{36, 110, -37}, {111, 111, 643}, {112, 122, 73}, },
            {{36, 115, -119}, {116, 116, 644}, {117, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 98, -235}, {99, 99, 645}, {100, 122, 73}, },
            {{36, 110, -37}, {111, 111, 646}, {112, 122, 73}, },
            {{36, 109, -40}, {110, 110, 647}, {111, 122, 73}, },
            {{36, 114, -115}, {115, 115, 648}, {116, 122, 73}, },
            {{36, 100, -39}, {101, 101, 649}, {102, 122, 73}, },
            {{36, 98, -235}, {99, 99, 650}, {100, 122, 73}, },
            {{36, 95, -10}, {97, 97, 651}, {98, 122, 73}, },
            {{36, 110, -37}, {111, 111, 652}, {112, 122, 73}, },
            {{36, 114, -115}, {115, 115, 653}, {116, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 654}, {98, 122, 73}, },
            {{36, 115, -119}, {116, 116, 655}, {117, 122, 73}, },
            {{36, 95, -10}, {97, 120, 73}, {121, 121, 656}, {122, 122, 73}, },
            {{36, 100, -39}, {101, 101, 657}, {102, 122, 73}, },
            {{36, 115, -119}, {116, 116, 658}, {117, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 107, -129}, {108, 108, 659}, {109, 122, 73}, },
            {{36, 104, -52}, {105, 105, 660}, {106, 122, 73}, },
            {{36, 101, -44}, {102, 102, 661}, {103, 122, 73}, },
            {{36, 110, -37}, {111, 111, 662}, {112, 122, 73}, },
            {{36, 118, -398}, {119, 119, 663}, {120, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 664}, {102, 122, 73}, },
            {{36, 109, -40}, {110, 110, 665}, {111, 122, 73}, },
            {{36, 107, -129}, {108, 108, 666}, {109, 122, 73}, },
            {{36, 107, -129}, {108, 108, 667}, {109, 122, 73}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{116, 116, 668}, },
            {{48, 57, 669}, {65, 70, 670}, {97, 102, 671}, },
            {{48, 102, -600}, },
            {{48, 102, -600}, },
            {{48, 57, 672}, {65, 70, 673}, {97, 102, 674}, },
            {{48, 102, -603}, },
            {{48, 102, -603}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{0, 47, -209}, {48, 57, 675}, {58, 64, 74}, {65, 70, 676}, {71, 96, 74}, {97, 102, 677}, {103, 65535, 74}, },
            {{0, 65535, -609}, },
            {{0, 65535, -609}, },
            {{0, 47, -209}, {48, 57, 678}, {58, 64, 74}, {65, 70, 679}, {71, 96, 74}, {97, 102, 680}, {103, 65535, 74}, },
            {{0, 65535, -612}, },
            {{0, 65535, -612}, },
            {{48, 57, 681}, {65, 70, 682}, {97, 102, 683}, },
            {{48, 102, -615}, },
            {{48, 102, -615}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 65535, -77}, },
            {{0, 41, 684}, {42, 42, 209}, {43, 46, 684}, {47, 47, 685}, {48, 65535, 684}, },
            {{0, 65535, -341}, },
            {{0, 65535, -547}, },
            {{0, 65535, -547}, },
            {{0, 65535, -549}, },
            {{0, 65535, -549}, },
            {{0, 65535, -547}, },
            {{0, 41, -467}, {42, 42, 626}, {43, 65535, -467}, },
            {{0, 41, -547}, {42, 42, 686}, {43, 46, 621}, {47, 47, 687}, {48, 65535, 621}, },
            {{0, 65535, -549}, },
            {{0, 65535, -549}, },
            {{0, 41, 458}, {42, 42, 688}, {43, 46, 458}, {47, 47, 689}, {48, 65535, 458}, },
            {{0, 8, 690}, {9, 9, 691}, {10, 10, 692}, {11, 12, 690}, {13, 13, 693}, {14, 31, 690}, {32, 32, 694}, {33, 41, 690}, {42, 42, 695}, {43, 46, 690}, {47, 47, 696}, {48, 65535, 690}, },
            {{0, 65535, -633}, },
            {{0, 8, 697}, {9, 9, 698}, {10, 10, 692}, {11, 12, 697}, {13, 13, 693}, {14, 31, 697}, {32, 32, 699}, {33, 41, 697}, {42, 42, 700}, {43, 46, 697}, {47, 47, 701}, {48, 65535, 697}, },
            {{0, 65535, -635}, },
            {{0, 65535, -633}, },
            {{0, 65535, -468}, },
            {{62, 62, 702}, },
            {{101, 101, 703}, },
            {{116, 116, 704}, },
            {{36, 115, -119}, {116, 116, 705}, {117, 122, 73}, },
            {{36, 104, -52}, {105, 105, 706}, {106, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 707}, {106, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 708}, {106, 122, 73}, },
            {{36, 109, -40}, {110, 110, 709}, {111, 122, 73}, },
            {{36, 104, -52}, {105, 105, 710}, {106, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 109, -40}, {110, 110, 711}, {111, 122, 73}, },
            {{36, 100, -39}, {101, 101, 712}, {102, 122, 73}, },
            {{36, 98, -235}, {99, 99, 713}, {100, 122, 73}, },
            {{36, 101, -44}, {102, 102, 714}, {103, 122, 73}, },
            {{36, 118, -398}, {119, 119, 715}, {120, 122, 73}, },
            {{36, 120, -581}, {121, 121, 716}, {122, 122, 73}, },
            {{36, 104, -52}, {105, 105, 717}, {106, 122, 73}, },
            {{36, 111, -123}, {112, 112, 718}, {113, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 719}, {102, 122, 73}, },
            {{36, 104, -52}, {105, 105, 720}, {106, 122, 73}, },
            {{36, 109, -40}, {110, 110, 721}, {111, 122, 73}, },
            {{36, 111, -123}, {112, 112, 722}, {113, 122, 73}, },
            {{36, 109, -40}, {110, 110, 723}, {111, 122, 73}, },
            {{36, 104, -52}, {105, 105, 724}, {106, 122, 73}, },
            {{36, 109, -40}, {110, 110, 725}, {111, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 726}, {106, 122, 73}, },
            {{36, 100, -39}, {101, 101, 727}, {102, 122, 73}, },
            {{121, 121, 728}, },
            {{48, 57, 729}, {65, 70, 730}, {97, 102, 731}, },
            {{48, 102, -671}, },
            {{48, 102, -671}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{0, 47, -209}, {48, 57, 732}, {58, 64, 74}, {65, 70, 733}, {71, 96, 74}, {97, 102, 734}, {103, 65535, 74}, },
            {{0, 65535, -677}, },
            {{0, 65535, -677}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{48, 57, 735}, {65, 70, 736}, {97, 102, 737}, },
            {{48, 102, -683}, },
            {{48, 102, -683}, },
            {{0, 41, 697}, {42, 42, 700}, {43, 65535, 697}, },
            {{0, 65535, -464}, },
            {{0, 41, -553}, {42, 42, 695}, {43, 65535, -553}, },
            {{0, 65535, -629}, },
            {{0, 41, 684}, {42, 42, 700}, {43, 65535, -621}, },
            {{0, 65535, -547}, },
            {{0, 65535, -633}, },
            {{0, 65535, -633}, },
            {{0, 65535, -635}, },
            {{0, 65535, -635}, },
            {{0, 65535, -633}, },
            {{0, 41, -467}, {42, 42, 695}, {43, 65535, -467}, },
            {{0, 41, -633}, {42, 42, 738}, {43, 46, 690}, {47, 47, 739}, {48, 65535, 690}, },
            {{0, 65535, -686}, },
            {{0, 65535, -635}, },
            {{0, 65535, -635}, },
            {{0, 41, 337}, {42, 42, 700}, {43, 65535, -211}, },
            {{0, 41, 697}, {42, 42, 740}, {43, 46, 697}, {47, 47, 741}, {48, 65535, 697}, },
            {},
            {{120, 120, 742}, },
            {{101, 101, 743}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 744}, {112, 122, 73}, },
            {{36, 109, -40}, {110, 110, 745}, {111, 122, 73}, },
            {{36, 109, -40}, {110, 110, 746}, {111, 122, 73}, },
            {{36, 104, -52}, {105, 105, 747}, {106, 122, 73}, },
            {{36, 115, -119}, {116, 116, 748}, {117, 122, 73}, },
            {{36, 115, -119}, {116, 116, 749}, {117, 122, 73}, },
            {{36, 110, -37}, {111, 111, 750}, {112, 122, 73}, },
            {{36, 100, -39}, {101, 101, 751}, {102, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 752}, {106, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 753}, {98, 122, 73}, },
            {{36, 100, -39}, {101, 101, 754}, {102, 122, 73}, },
            {{36, 99, -278}, {100, 100, 755}, {101, 122, 73}, },
            {{36, 109, -40}, {110, 110, 756}, {111, 122, 73}, },
            {{36, 117, -263}, {118, 118, 757}, {119, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 758}, {106, 122, 73}, },
            {{36, 115, -119}, {116, 116, 759}, {117, 122, 73}, },
            {{36, 115, -119}, {116, 116, 760}, {117, 122, 73}, },
            {{36, 109, -40}, {110, 110, 761}, {111, 122, 73}, },
            {{36, 122, -10}, },
            {{70, 102, -285}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{36, 122, -172}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{0, 65535, -192}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{36, 122, -201}, },
            {{0, 65535, -688}, },
            {{0, 65535, -698}, },
            {{0, 65535, -690}, },
            {{0, 65535, -633}, },
            {{99, 99, 762}, },
            {{114, 114, 763}, },
            {{36, 109, -40}, {110, 110, 764}, {111, 122, 73}, },
            {{36, 115, -119}, {116, 116, 765}, {117, 122, 73}, },
            {{36, 117, -263}, {118, 118, 766}, {119, 122, 73}, },
            {{36, 115, -119}, {116, 116, 767}, {117, 122, 73}, },
            {{36, 110, -37}, {111, 111, 768}, {112, 122, 73}, },
            {{36, 114, -115}, {115, 115, 769}, {116, 122, 73}, },
            {{36, 101, -44}, {102, 102, 770}, {103, 122, 73}, },
            {{36, 104, -52}, {105, 105, 771}, {106, 122, 73}, },
            {{36, 115, -119}, {116, 116, 772}, {117, 122, 73}, },
            {{36, 113, -47}, {114, 114, 773}, {115, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 117, -263}, {118, 118, 774}, {119, 122, 73}, },
            {{36, 110, -37}, {111, 111, 775}, {112, 122, 73}, },
            {{36, 95, -10}, {97, 121, 73}, {122, 122, 776}, },
            {{36, 98, -235}, {99, 99, 777}, {100, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 117, -263}, {118, 118, 778}, {119, 122, 73}, },
            {{101, 101, 779}, },
            {{48, 57, 780}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 781}, {112, 122, 73}, },
            {{36, 110, -37}, {111, 111, 782}, {112, 122, 73}, },
            {{36, 113, -47}, {114, 114, 783}, {115, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 109, -40}, {110, 110, 784}, {111, 122, 73}, },
            {{36, 98, -235}, {99, 99, 785}, {100, 122, 73}, },
            {{36, 113, -47}, {114, 114, 786}, {115, 122, 73}, },
            {{36, 110, -37}, {111, 111, 787}, {112, 122, 73}, },
            {{36, 106, -154}, {107, 107, 788}, {108, 122, 73}, },
            {{36, 100, -39}, {101, 101, 789}, {102, 122, 73}, },
            {{36, 103, -49}, {104, 104, 790}, {105, 122, 73}, },
            {{36, 110, -37}, {111, 111, 791}, {112, 122, 73}, },
            {{112, 112, 792}, },
            {{48, 57, 780}, {58, 58, 793}, },
            {{36, 106, -154}, {107, 107, 794}, {108, 122, 73}, },
            {{36, 113, -47}, {114, 114, 795}, {115, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 117, -263}, {118, 118, 796}, {119, 122, 73}, },
            {{36, 103, -49}, {104, 104, 797}, {105, 122, 73}, },
            {{36, 95, -10}, {97, 97, 798}, {98, 122, 73}, },
            {{36, 106, -154}, {107, 107, 799}, {108, 122, 73}, },
            {{36, 100, -39}, {101, 101, 800}, {102, 122, 73}, },
            {{36, 99, -278}, {100, 100, 801}, {101, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 106, -154}, {107, 107, 802}, {108, 122, 73}, },
            {{116, 116, 803}, },
            {},
            {{36, 100, -39}, {101, 101, 804}, {102, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 805}, {112, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 120, -581}, {121, 121, 806}, {122, 122, 73}, },
            {{36, 100, -39}, {101, 101, 807}, {102, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 808}, {102, 122, 73}, },
            {{105, 105, 809}, },
            {{36, 122, -10}, },
            {{36, 106, -154}, {107, 107, 810}, {108, 122, 73}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{111, 111, 811}, },
            {{36, 100, -39}, {101, 101, 812}, {102, 122, 73}, },
            {{110, 110, 813}, },
            {{36, 122, -10}, },
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {-1, 0, 0, 0, 0, -1, -1, -1, 95, 79, 76, 73, 69, 70, 91, 89, 63, 90, 72, 92, 98, 98, 71, 66, 84, 75, 82, -1, 95, 67, -1, 68, 78, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 64, 77, 65, -1, 81, -1, 100, -1, -1, -1, -1, -1, -1, 95, -1, 95, -1, 95, 95, -1, 95, 95, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 98, 98, -1, -1, 74, 86, 85, -1, -1, 80, 83, 87, -1, -1, -1, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, -1, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 39, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 60, 95, 95, 95, 95, 95, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, 94, 94, -1, 94, 94, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, -1, 93, 93, 94, 93, 94, -1, 94, 94, -1, -1, -1, 93, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 99, 98, 98, 98, -1, -1, 88, -1, -1, -1, -1, -1, -1, 95, 95, 95, 95, 95, 95, 95, 95, 95, 62, 32, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 21, 95, 95, 95, 95, 44, 45, 48, 95, 95, 95, 95, 49, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, -1, -1, -1, -1, 99, 94, 94, 94, 94, 94, -1, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, -1, -1, -1, -1, 94, 93, 94, 94, 94, -1, 94, 94, 94, 94, 94, 93, 94, 94, 94, 94, 94, 94, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, 99, -1, 99, -1, -1, -1, -1, -1, -1, -1, -1, 95, 95, 95, 95, 18, 30, 95, 20, 95, 33, 34, 95, 95, 95, 95, 12, 95, 95, 95, 95, 95, 59, 38, 95, 95, 95, 95, 22, 95, 95, 95, 95, 58, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 16, 95, 61, -1, -1, -1, -1, 99, 99, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, -1, -1, -1, -1, -1, -1, -1, 94, 94, 94, 93, 94, 94, 94, 94, 94, 94, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, 99, -1, -1, -1, -1, -1, -1, -1, -1, 95, 95, 95, 95, 31, 14, 95, 95, 95, 95, 95, 95, 95, 2, 23, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 19, 95, 95, 95, 95, 95, 55, 95, 95, 95, 95, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 95, -1, -1, 96, 95, 95, 95, 95, 95, 95, 95, 95, 24, 95, 95, 95, 95, 95, 95, 95, 95, 95, 3, 95, 95, 95, 95, 95, 4, 50, 95, 7, 95, 95, 95, 56, 95, 95, 95, 95, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 95, 95, 95, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, 95, 95, 17, 95, 35, 95, 95, 95, 27, 95, 95, 95, 95, 95, 95, 95, 95, 6, 95, 95, 95, 95, 95, 95, 95, 26, 95, 95, -1, -1, -1, -1, 94, 94, 94, -1, -1, -1, 94, 94, 94, -1, -1, -1, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, -1, 95, -1, -1, 1, 95, 95, 95, 95, 95, 95, 95, 95, 42, 95, 46, 95, 95, 95, 95, 95, 11, 95, 95, 95, 95, 10, 99, 94, 94, 94, 94, 94, 94, -1, -1, -1, 0, 0, -1, 0, -1, -1, 95, 95, 95, 95, 95, 95, 95, 15, 95, 95, 25, 5, 95, 95, 95, 95, 9, 95, -1, -1, 13, 29, 95, 95, 95, 28, 40, 95, 95, 95, 95, 95, 95, 95, 95, -1, -1, 95, 95, 37, 95, 95, 95, 95, 95, 95, 54, 95, -1, 96, 95, 36, 95, 43, 95, 95, 52, 8, 95, -1, 53, 95, 47, 51, 57, -1, 95, -1, 41, 96, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(@SuppressWarnings("hiding") int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("/lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
