/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.ArrayType;
import soot.Body;
import soot.DoubleType;
import soot.FastHierarchy;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum CheckTypesValidator implements BodyValidator
{
    INSTANCE;


    public static CheckTypesValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        String methodSuffix = " in " + body.getMethod();
        for (Unit u : body.getUnits()) {
            Stmt stmt;
            DefinitionStmt astmt;
            String errorSuffix = " at " + u + methodSuffix;
            if (u instanceof DefinitionStmt && !((astmt = (DefinitionStmt)u).getRightOp() instanceof CaughtExceptionRef)) {
                Type leftType = Type.toMachineType(astmt.getLeftOp().getType());
                Type rightType = Type.toMachineType(astmt.getRightOp().getType());
                this.checkCopy(astmt, exception, leftType, rightType, errorSuffix);
            }
            if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr()) continue;
            InvokeExpr iexpr = stmt.getInvokeExpr();
            SootMethodRef called = iexpr.getMethodRef();
            if (iexpr instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iiexpr = (InstanceInvokeExpr)iexpr;
                this.checkCopy(stmt, exception, called.getDeclaringClass().getType(), iiexpr.getBase().getType(), " in receiver of call" + errorSuffix);
            }
            int argCount = iexpr.getArgCount();
            if (called.getParameterTypes().size() != argCount) {
                exception.add(new ValidationException(stmt, "Argument count does not match the signature of the called function", "Warning: Argument count doesn't match up with signature in call" + errorSuffix));
                continue;
            }
            for (int i = 0; i < argCount; ++i) {
                this.checkCopy(stmt, exception, Type.toMachineType(called.getParameterType(i)), Type.toMachineType(iexpr.getArg(i).getType()), " in argument " + i + " of call" + errorSuffix + " (Note: Parameters are zero-indexed)");
            }
        }
    }

    private void checkCopy(Unit stmt, List<ValidationException> exception, Type leftType, Type rightType, String errorSuffix) {
        if (leftType instanceof PrimType || rightType instanceof PrimType) {
            if (leftType instanceof IntType && rightType instanceof IntType || leftType instanceof LongType && rightType instanceof LongType) {
                return;
            }
            if (leftType instanceof FloatType && rightType instanceof FloatType) {
                return;
            }
            if (leftType instanceof DoubleType && rightType instanceof DoubleType) {
                return;
            }
            if (Options.v().src_prec() == 7) {
                FastHierarchy fastHierarchy;
                if (leftType instanceof RefType && ((RefType)leftType).getClassName().equals("System.IntPtr") || rightType instanceof RefType && ((RefType)rightType).getClassName().equals("System.IntPtr")) {
                    return;
                }
                if (leftType instanceof RefType) {
                    fastHierarchy = Scene.v().getFastHierarchy();
                    if (fastHierarchy.canStoreClass(((RefType)leftType).getSootClass(), Scene.v().getSootClass("System.ValueType"))) {
                        return;
                    }
                    if (((RefType)leftType).getSootClass().getName().equals("System.Object")) {
                        return;
                    }
                    if (leftType.equals(RefType.v("System.IComparable")) || leftType.equals(RefType.v("System.IComparable`1")) || leftType.equals(RefType.v("System.IConvertible")) || leftType.equals(RefType.v("System.IEquatable`1")) || leftType.equals(RefType.v("System.IFormattable"))) {
                        return;
                    }
                }
                if (rightType instanceof RefType && (fastHierarchy = Scene.v().getFastHierarchy()).canStoreClass(((RefType)rightType).getSootClass(), Scene.v().getSootClass("System.ValueType"))) {
                    return;
                }
            }
            exception.add(new ValidationException(stmt, "Warning: Bad use of primitive type" + errorSuffix + " - LeftType is " + leftType.getClass().getName() + " and RightType is " + rightType.getClass().getName()));
            return;
        }
        if (rightType instanceof NullType || leftType instanceof RefType && Scene.v().getObjectType().toString().equals(((RefType)leftType).getClassName())) {
            return;
        }
        if (leftType instanceof ArrayType || rightType instanceof ArrayType) {
            if (leftType instanceof ArrayType && rightType instanceof ArrayType) {
                return;
            }
            if (rightType instanceof ArrayType && (leftType.equals(RefType.v("java.io.Serializable")) || leftType.equals(RefType.v("java.lang.Cloneable")) || leftType.equals(Scene.v().getObjectType()) || leftType.equals(RefType.v("System.Array")))) {
                return;
            }
            exception.add(new ValidationException(stmt, "Warning: Bad use of array type" + errorSuffix));
            return;
        }
        if (leftType instanceof RefType && rightType instanceof RefType) {
            SootClass leftClass = ((RefType)leftType).getSootClass();
            SootClass rightClass = ((RefType)rightType).getSootClass();
            if (leftClass.isPhantom() || rightClass.isPhantom()) {
                return;
            }
            if (leftClass.isInterface()) {
                if (rightClass.isInterface() && !leftClass.getName().equals(rightClass.getName()) && !Scene.v().getActiveHierarchy().isInterfaceSubinterfaceOf(rightClass, leftClass)) {
                    exception.add(new ValidationException(stmt, "Warning: Bad use of interface type" + errorSuffix));
                }
            } else if (rightClass.isInterface()) {
                exception.add(new ValidationException(stmt, "Warning: trying to use interface type where non-Object class expected" + errorSuffix));
            } else if (Options.v().src_prec() == 7) {
                FastHierarchy fastHierarchy = Scene.v().getFastHierarchy();
                boolean lTypeIsChild = fastHierarchy.canStoreClass(((RefType)leftType).getSootClass(), Scene.v().getSootClass("System.ValueType"));
                boolean rTypeIsChild = fastHierarchy.canStoreClass(((RefType)rightType).getSootClass(), Scene.v().getSootClass("System.ValueType"));
                if (lTypeIsChild && rTypeIsChild) {
                    return;
                }
            } else if (!Scene.v().getActiveHierarchy().isClassSubclassOfIncluding(rightClass, leftClass)) {
                exception.add(new ValidationException(stmt, "Warning: Bad use of class type" + errorSuffix));
            }
            return;
        }
        exception.add(new ValidationException(stmt, "Warning: Bad types" + errorSuffix));
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

