/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.toolkits.graph.DirectedBodyGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class InitAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<Local>> {
    protected final FlowSet<Local> allLocals;

    public InitAnalysis(DirectedBodyGraph<Unit> g) {
        super(g);
        FlowSet<Local> allLocalsRef = this.allLocals = new ArraySparseSet<Local>();
        for (Local loc : g.getBody().getLocals()) {
            allLocalsRef.add(loc);
        }
        this.doAnalysis();
    }

    @Override
    protected FlowSet<Local> entryInitialFlow() {
        return new ArraySparseSet<Local>();
    }

    @Override
    protected FlowSet<Local> newInitialFlow() {
        ArraySparseSet<Local> ret = new ArraySparseSet<Local>();
        this.allLocals.copy(ret);
        return ret;
    }

    @Override
    protected void flowThrough(FlowSet<Local> in, Unit unit, FlowSet<Local> out) {
        in.copy(out);
        for (ValueBox defBox : unit.getDefBoxes()) {
            Value lhs = defBox.getValue();
            if (!(lhs instanceof Local)) continue;
            out.add((Local)lhs);
        }
    }

    @Override
    protected void merge(FlowSet<Local> in1, FlowSet<Local> in2, FlowSet<Local> out) {
        in1.intersection(in2, out);
    }

    @Override
    protected void copy(FlowSet<Local> source, FlowSet<Local> dest) {
        source.copy(dest);
    }
}

