/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Singletons;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.Orderer;

public class SlowPseudoTopologicalOrderer<N>
implements Orderer<N> {
    private boolean mIsReversed = false;

    public SlowPseudoTopologicalOrderer(Singletons.Global g) {
    }

    public static SlowPseudoTopologicalOrderer v() {
        return G.v().soot_toolkits_graph_SlowPseudoTopologicalOrderer();
    }

    public SlowPseudoTopologicalOrderer() {
    }

    @Override
    public List<N> newList(DirectedGraph<N> g, boolean reverse) {
        this.mIsReversed = reverse;
        return new ForwardOrderBuilder<N>(g, reverse).computeOrder();
    }

    public SlowPseudoTopologicalOrderer(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    @Deprecated
    public List<N> newList(DirectedGraph<N> g) {
        return new ForwardOrderBuilder<N>(g, this.mIsReversed).computeOrder();
    }

    @Deprecated
    public void setReverseOrder(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    @Deprecated
    public boolean isReverseOrder() {
        return this.mIsReversed;
    }

    private static class ReverseOrderBuilder<N>
    extends AbstractOrderBuilder<N> {
        public ReverseOrderBuilder(DirectedGraph<N> graph) {
            super(graph, false);
        }

        @Override
        protected void visitNode(N startStmt) {
            LinkedList<Object> stmtStack = new LinkedList<Object>();
            LinkedList<Integer> indexStack = new LinkedList<Integer>();
            this.stmtToColor.put(startStmt, AbstractOrderBuilder.Color.GRAY);
            stmtStack.addLast(startStmt);
            indexStack.addLast(-1);
            while (!stmtStack.isEmpty()) {
                int toVisitIndex = (Integer)indexStack.removeLast();
                Object toVisitNode = stmtStack.getLast();
                indexStack.addLast(++toVisitIndex);
                if (toVisitIndex >= this.graph.getPredsOf(toVisitNode).size()) {
                    if (this.reverse) {
                        this.order.addLast(toVisitNode);
                    } else {
                        this.order.addFirst(toVisitNode);
                    }
                    this.stmtToColor.put(toVisitNode, AbstractOrderBuilder.Color.BLACK);
                    stmtStack.removeLast();
                    indexStack.removeLast();
                    continue;
                }
                Object childNode = this.graph.getPredsOf(toVisitNode).get(toVisitIndex);
                if (this.stmtToColor.get(childNode) != AbstractOrderBuilder.Color.WHITE) continue;
                this.stmtToColor.put(childNode, AbstractOrderBuilder.Color.GRAY);
                stmtStack.addLast(childNode);
                indexStack.addLast(-1);
            }
        }
    }

    private static class ForwardOrderBuilder<N>
    extends AbstractOrderBuilder<N> {
        private final HashMap<N, List<N>> succsMap = new HashMap();
        private List<N> reverseOrder;

        public ForwardOrderBuilder(DirectedGraph<N> graph, boolean reverse) {
            super(graph, reverse);
        }

        @Override
        public LinkedList<N> computeOrder() {
            this.reverseOrder = new ReverseOrderBuilder(this.graph).computeOrder();
            return super.computeOrder();
        }

        @Override
        protected void visitNode(N startStmt) {
            LinkedList<N> stmtStack = new LinkedList<N>();
            LinkedList<Integer> indexStack = new LinkedList<Integer>();
            this.stmtToColor.put(startStmt, AbstractOrderBuilder.Color.GRAY);
            stmtStack.addLast(startStmt);
            indexStack.addLast(-1);
            while (!stmtStack.isEmpty()) {
                N childNode;
                int toVisitIndex = (Integer)indexStack.removeLast();
                Object toVisitNode = stmtStack.getLast();
                indexStack.addLast(++toVisitIndex);
                if (toVisitIndex >= this.graph.getSuccsOf(toVisitNode).size()) {
                    if (this.reverse) {
                        this.order.addLast(toVisitNode);
                    } else {
                        this.order.addFirst(toVisitNode);
                    }
                    this.stmtToColor.put(toVisitNode, AbstractOrderBuilder.Color.BLACK);
                    stmtStack.removeLast();
                    indexStack.removeLast();
                    continue;
                }
                List<N> orderedSuccs = this.succsMap.get(toVisitNode);
                if (orderedSuccs == null) {
                    orderedSuccs = new LinkedList<N>();
                    this.succsMap.put(toVisitNode, orderedSuccs);
                    List allsuccs = this.graph.getSuccsOf(toVisitNode);
                    for (int i = 0; i < allsuccs.size(); ++i) {
                        int j;
                        Object cur = allsuccs.get(i);
                        for (j = 0; j < orderedSuccs.size(); ++j) {
                            N comp = orderedSuccs.get(j);
                            if (this.reverseOrder.indexOf(cur) < this.reverseOrder.indexOf(comp)) break;
                        }
                        orderedSuccs.add(j, cur);
                    }
                }
                if (this.stmtToColor.get(childNode = orderedSuccs.get(toVisitIndex)) != AbstractOrderBuilder.Color.WHITE) continue;
                this.stmtToColor.put(childNode, AbstractOrderBuilder.Color.GRAY);
                stmtStack.addLast(childNode);
                indexStack.addLast(-1);
            }
        }
    }

    private static abstract class AbstractOrderBuilder<N> {
        protected final Map<N, Color> stmtToColor = new HashMap<N, Color>();
        protected final LinkedList<N> order = new LinkedList();
        protected final DirectedGraph<N> graph;
        protected final boolean reverse;

        protected AbstractOrderBuilder(DirectedGraph<N> g, boolean reverse) {
            this.graph = g;
            this.reverse = reverse;
        }

        protected abstract void visitNode(N var1);

        public LinkedList<N> computeOrder() {
            for (N s : this.graph) {
                this.stmtToColor.put(s, Color.WHITE);
            }
            for (N s : this.graph) {
                if (this.stmtToColor.get(s) != Color.WHITE) continue;
                this.visitNode(s);
            }
            return this.order;
        }

        protected static enum Color {
            WHITE,
            GRAY,
            BLACK;

        }
    }
}

