/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DominanceFrontier;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;

public class CytronDominanceFrontier<N>
implements DominanceFrontier<N> {
    protected DominatorTree<N> dt;
    protected Map<DominatorNode<N>, List<DominatorNode<N>>> nodeToFrontier;

    public CytronDominanceFrontier(DominatorTree<N> dt) {
        this.dt = dt;
        this.nodeToFrontier = new HashMap<DominatorNode<N>, List<DominatorNode<N>>>();
        for (DominatorNode<N> head : dt.getHeads()) {
            this.bottomUpDispatch(head);
        }
        for (DominatorNode<N> gode : dt.graph) {
            DominatorNode<DominatorNode<N>> dode = dt.fetchDode(gode);
            if (dode == null) {
                throw new RuntimeException("dode == null");
            }
            if (this.isFrontierKnown(dode)) continue;
            throw new RuntimeException("Frontier not defined for node: " + dode);
        }
    }

    @Override
    public List<DominatorNode<N>> getDominanceFrontierOf(DominatorNode<N> node) {
        List<DominatorNode<N>> frontier = this.nodeToFrontier.get(node);
        if (frontier == null) {
            throw new RuntimeException("Frontier not defined for node: " + node);
        }
        return Collections.unmodifiableList(frontier);
    }

    protected boolean isFrontierKnown(DominatorNode<N> node) {
        return this.nodeToFrontier.containsKey(node);
    }

    protected void bottomUpDispatch(DominatorNode<N> node) {
        if (this.isFrontierKnown(node)) {
            return;
        }
        for (DominatorNode<N> child : this.dt.getChildrenOf(node)) {
            if (this.isFrontierKnown(child)) continue;
            this.bottomUpDispatch(child);
        }
        this.processNode(node);
    }

    protected void processNode(DominatorNode<N> node) {
        HashSet<DominatorNode<N>> dominanceFrontier = new HashSet<DominatorNode<N>>();
        for (DominatorNode<N> succ : this.dt.getSuccsOf(node)) {
            if (this.dt.isImmediateDominatorOf(node, succ)) continue;
            dominanceFrontier.add(succ);
        }
        for (DominatorNode<N> child : this.dt.getChildrenOf(node)) {
            for (DominatorNode<N> childFront : this.getDominanceFrontierOf(child)) {
                if (this.dt.isImmediateDominatorOf(node, childFront)) continue;
                dominanceFrontier.add(childFront);
            }
        }
        this.nodeToFrontier.put(node, new ArrayList(dominanceFrontier));
    }
}

