/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex.instructions;

import java.util.BitSet;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22s;
import soot.toDex.LabelAssigner;
import soot.toDex.Register;
import soot.toDex.instructions.AbstractInsn;
import soot.toDex.instructions.TwoRegInsn;

public class Insn22s
extends AbstractInsn
implements TwoRegInsn {
    private short litC;

    public Insn22s(Opcode opc, Register regA, Register regB, short litC) {
        super(opc);
        this.regs.add(regA);
        this.regs.add(regB);
        this.litC = litC;
    }

    @Override
    public Register getRegA() {
        return (Register)this.regs.get(0);
    }

    @Override
    public Register getRegB() {
        return (Register)this.regs.get(1);
    }

    public short getLitC() {
        return this.litC;
    }

    @Override
    protected BuilderInstruction getRealInsn0(LabelAssigner assigner) {
        return new BuilderInstruction22s(this.opc, (int)((byte)this.getRegA().getNumber()), (int)((byte)this.getRegB().getNumber()), (int)this.getLitC());
    }

    @Override
    public BitSet getIncompatibleRegs() {
        BitSet incompatRegs = new BitSet(2);
        if (!this.getRegA().fitsByte()) {
            incompatRegs.set(0);
        }
        if (!this.getRegB().fitsByte()) {
            incompatRegs.set(1);
        }
        return incompatRegs;
    }

    @Override
    public String toString() {
        return super.toString() + " lit: " + this.getLitC();
    }
}

