/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import soot.jimple.IntConstant;
import soot.tagkit.ConstantValueTag;

public class IntegerConstantValueTag
extends ConstantValueTag {
    public static final String NAME = "IntegerConstantValueTag";
    private final int value;

    public IntegerConstantValueTag(int value) {
        super(new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)});
        this.value = value;
    }

    public int getIntValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toString() {
        return "ConstantValue: " + Integer.toString(this.value);
    }

    @Override
    public IntConstant getConstant() {
        return IntConstant.v(this.value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerConstantValueTag other = (IntegerConstantValueTag)obj;
        return this.value == other.value;
    }
}

