/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import soot.Local;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.shimple.PiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleFactory;
import soot.shimple.internal.SHashMultiMap;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.DominanceFrontier;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;
import soot.toolkits.graph.ReversibleGraph;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class PiNodeManager {
    protected final ShimpleBody body;
    protected final ShimpleFactory sf;
    protected final boolean trimmed;
    protected ReversibleGraph<Block> cfg;
    protected MultiMap<Local, Block> varToBlocks;

    public PiNodeManager(ShimpleBody body, boolean trimmed, ShimpleFactory sf) {
        this.body = body;
        this.trimmed = trimmed;
        this.sf = sf;
    }

    public void update() {
        ReversibleGraph<Block> oldCfg = this.cfg;
        this.cfg = this.sf.getReverseBlockGraph();
        if (oldCfg != this.cfg) {
            this.varToBlocks = null;
        }
    }

    public boolean insertTrivialPiNodes() {
        this.update();
        this.varToBlocks = new HashMultiMap<Local, Block>();
        SHashMultiMap<Local, Block> localsToUsePoints = new SHashMultiMap<Local, Block>();
        for (Block block : this.cfg) {
            for (Unit unit : block) {
                for (ValueBox next : unit.getUseBoxes()) {
                    Value use = next.getValue();
                    if (!(use instanceof Local)) continue;
                    localsToUsePoints.put((Local)use, block);
                }
                if (!Shimple.isPiNode(unit)) continue;
                this.varToBlocks.put(Shimple.getLhsLocal(unit), block);
            }
        }
        boolean change = false;
        DominatorTree<Block> dt = this.sf.getReverseDominatorTree();
        DominanceFrontier<Block> df = this.sf.getReverseDominanceFrontier();
        int iterCount = 0;
        int[] workFlags = new int[this.cfg.size()];
        int[] hasAlreadyFlags = new int[this.cfg.size()];
        Stack<Block> workList = new Stack<Block>();
        for (Local local : localsToUsePoints.keySet()) {
            ++iterCount;
            for (Block block : localsToUsePoints.get(local)) {
                workFlags[block.getIndexInMethod()] = iterCount;
                workList.push(block);
            }
            while (!workList.empty()) {
                Block block = (Block)workList.pop();
                for (DominatorNode<Block> frontierNode : df.getDominanceFrontierOf(dt.getDode(block))) {
                    Block frontierBlock = frontierNode.getGode();
                    int fBIndex = frontierBlock.getIndexInMethod();
                    if (hasAlreadyFlags[fBIndex] >= iterCount) continue;
                    hasAlreadyFlags[fBIndex] = iterCount;
                    this.insertPiNodes(local, frontierBlock);
                    change = true;
                    if (workFlags[fBIndex] >= iterCount) continue;
                    workFlags[fBIndex] = iterCount;
                    workList.push(frontierBlock);
                }
            }
        }
        if (change) {
            this.sf.clearCache();
        }
        return change;
    }

    public void insertPiNodes(Local local, Block frontierBlock) {
        Unit u;
        block7: {
            if (this.varToBlocks.get(local).contains(frontierBlock.getSuccs().get(0))) {
                return;
            }
            u = frontierBlock.getTail();
            if (this.trimmed) {
                for (ValueBox vb : u.getUseBoxes()) {
                    if (!vb.getValue().equals(local)) continue;
                    break block7;
                }
                return;
            }
        }
        if (u instanceof IfStmt) {
            this.piHandleIfStmt(local, (IfStmt)u);
        } else if (u instanceof LookupSwitchStmt || u instanceof TableSwitchStmt) {
            this.piHandleSwitchStmt(local, u);
        } else {
            throw new RuntimeException("Assertion failed: Unhandled stmt: " + u);
        }
    }

    public void piHandleIfStmt(Local local, IfStmt u) {
        Stmt predOfTarget;
        UnitPatchingChain units = this.body.getUnits();
        Stmt target = u.getTarget();
        AssignStmt addt = Jimple.v().newAssignStmt(local, Shimple.v().newPiExpr(local, u, Boolean.TRUE));
        AssignStmt addf = Jimple.v().newAssignStmt(local, Shimple.v().newPiExpr(local, u, Boolean.FALSE));
        units.insertAfter(addf, u);
        try {
            predOfTarget = units.getPredOf(target);
        }
        catch (NoSuchElementException e) {
            predOfTarget = null;
        }
        if (predOfTarget != null && predOfTarget.fallsThrough()) {
            units.insertAfter(Jimple.v().newGotoStmt(target), predOfTarget);
        }
        units.getNonPatchingChain().insertBefore(addt, target);
        u.setTarget(addt);
    }

    public void piHandleSwitchStmt(Local local, Unit u) {
        ArrayList<UnitBox> targetBoxes = new ArrayList<UnitBox>();
        ArrayList<Object> targetKeys = new ArrayList<Object>();
        if (u instanceof LookupSwitchStmt) {
            LookupSwitchStmt lss = (LookupSwitchStmt)u;
            targetBoxes.add(lss.getDefaultTargetBox());
            targetKeys.add("default");
            int e = lss.getTargetCount();
            for (int i = 0; i < e; ++i) {
                targetBoxes.add(lss.getTargetBox(i));
            }
            targetKeys.addAll(lss.getLookupValues());
        } else if (u instanceof TableSwitchStmt) {
            int i;
            TableSwitchStmt tss = (TableSwitchStmt)u;
            int low = tss.getLowIndex();
            int hi = tss.getHighIndex();
            targetBoxes.add(tss.getDefaultTargetBox());
            targetKeys.add("default");
            int e = hi - low;
            for (i = 0; i <= e; ++i) {
                targetBoxes.add(tss.getTargetBox(i));
            }
            for (i = low; i <= hi; ++i) {
                targetKeys.add(i);
            }
        } else {
            throw new RuntimeException("Assertion failed.");
        }
        int e = targetBoxes.size();
        for (int count = 0; count < e; ++count) {
            Unit predOfTarget;
            UnitBox targetBox = (UnitBox)targetBoxes.get(count);
            Unit target = targetBox.getUnit();
            UnitPatchingChain units = this.body.getUnits();
            try {
                predOfTarget = units.getPredOf(target);
            }
            catch (NoSuchElementException ex) {
                predOfTarget = null;
            }
            if (predOfTarget != null && predOfTarget.fallsThrough()) {
                units.insertAfter(Jimple.v().newGotoStmt(target), predOfTarget);
            }
            AssignStmt add1 = Jimple.v().newAssignStmt(local, Shimple.v().newPiExpr(local, u, targetKeys.get(count)));
            units.getNonPatchingChain().insertBefore(add1, target);
            targetBox.setUnit(add1);
        }
    }

    public void eliminatePiNodes(boolean smart) {
        if (smart) {
            HashMap<Local, Value> newToOld = new HashMap<Local, Value>();
            ArrayList<ValueBox> boxes = new ArrayList<ValueBox>();
            Iterator unitsIt = this.body.getUnits().iterator();
            while (unitsIt.hasNext()) {
                Unit u = (Unit)unitsIt.next();
                PiExpr pe = Shimple.getPiExpr(u);
                if (pe != null) {
                    newToOld.put(Shimple.getLhsLocal(u), pe.getValue());
                    unitsIt.remove();
                    continue;
                }
                boxes.addAll(u.getUseBoxes());
            }
            for (ValueBox box : boxes) {
                Value value = box.getValue();
                Value old = (Value)newToOld.get(value);
                if (old == null) continue;
                box.setValue(old);
            }
            DeadAssignmentEliminator.v().transform(this.body);
            CopyPropagator.v().transform(this.body);
            DeadAssignmentEliminator.v().transform(this.body);
        } else {
            for (Unit u : this.body.getUnits()) {
                PiExpr pe = Shimple.getPiExpr(u);
                if (pe == null) continue;
                ((AssignStmt)u).setRightOp(pe.getValue());
            }
        }
    }

    public static List<ValueBox> getUseBoxesFromBlock(Block block) {
        ArrayList<ValueBox> useBoxesList = new ArrayList<ValueBox>();
        for (Unit next : block) {
            useBoxesList.addAll(next.getUseBoxes());
        }
        return useBoxesList;
    }
}

