/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.ListIterator;
import soot.ArrayType;
import soot.FloatType;
import soot.IntegerType;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.jimple.toolkits.typing.fast.BottomType;
import soot.jimple.toolkits.typing.fast.IHierarchy;
import soot.jimple.toolkits.typing.fast.IntUtils;
import soot.jimple.toolkits.typing.fast.TypeResolver;
import soot.jimple.toolkits.typing.fast.WeakObjectType;

public class BytecodeHierarchy
implements IHierarchy {
    private static Collection<AncestryTreeNode> buildAncestryTree(RefType root) {
        if (root.getSootClass().isPhantom()) {
            return Collections.emptyList();
        }
        LinkedList<AncestryTreeNode> leafs = new LinkedList<AncestryTreeNode>();
        leafs.add(new AncestryTreeNode(null, root));
        LinkedList<AncestryTreeNode> r = new LinkedList<AncestryTreeNode>();
        RefType objectType = Scene.v().getObjectType();
        while (!leafs.isEmpty()) {
            AncestryTreeNode node = (AncestryTreeNode)leafs.remove();
            if (TypeResolver.typesEqual(node.type, objectType)) {
                r.add(node);
                continue;
            }
            SootClass sc = node.type.getSootClass();
            for (SootClass i : sc.getInterfaces()) {
                leafs.add(new AncestryTreeNode(node, i.getType()));
            }
            if (sc.isInterface() && sc.getInterfaceCount() != 0 || sc.isPhantom() || !sc.hasSuperclass()) continue;
            leafs.add(new AncestryTreeNode(node, sc.getSuperclass().getType()));
        }
        return r;
    }

    private static RefType leastCommonNode(AncestryTreeNode a, AncestryTreeNode b) {
        RefType r = null;
        while (a != null && b != null && TypeResolver.typesEqual(a.type, b.type)) {
            r = a.type;
            a = a.next;
            b = b.next;
        }
        return r;
    }

    public static Collection<Type> lcas_(Type a, Type b) {
        return BytecodeHierarchy.lcas_(a, b, false);
    }

    public static Collection<Type> lcas_(Type a, Type b, boolean useWeakObjectType) {
        if (TypeResolver.typesEqual(a, b)) {
            return Collections.singletonList(a);
        }
        if (a instanceof BottomType) {
            return Collections.singletonList(b);
        }
        if (b instanceof BottomType) {
            return Collections.singletonList(a);
        }
        if (a instanceof WeakObjectType && b instanceof RefType) {
            return Collections.singletonList(b);
        }
        if (b instanceof WeakObjectType && a instanceof RefType) {
            return Collections.singletonList(a);
        }
        if (a instanceof IntegerType && b instanceof IntegerType) {
            int m = Math.max(IntUtils.getMaxValue((IntegerType)((Object)a)), IntUtils.getMaxValue((IntegerType)((Object)b)));
            return Collections.singletonList((Type)((Object)IntUtils.getTypeByWidth(m)));
        }
        if (a instanceof IntegerType && b instanceof FloatType) {
            return Collections.singletonList(FloatType.v());
        }
        if (b instanceof IntegerType && a instanceof FloatType) {
            return Collections.singletonList(FloatType.v());
        }
        if (a instanceof PrimType || b instanceof PrimType) {
            return Collections.emptyList();
        }
        if (a instanceof NullType) {
            return Collections.singletonList(b);
        }
        if (b instanceof NullType) {
            return Collections.singletonList(a);
        }
        if (a instanceof ArrayType && b instanceof ArrayType) {
            Type eta = ((ArrayType)a).getElementType();
            Type etb = ((ArrayType)b).getElementType();
            Collection<Object> ts = eta instanceof PrimType || etb instanceof PrimType ? Collections.emptyList() : BytecodeHierarchy.lcas_(eta, etb);
            LinkedList<Type> r = new LinkedList<Type>();
            if (ts.isEmpty()) {
                if (useWeakObjectType) {
                    r.add(new WeakObjectType(Scene.v().getObjectType().toString()));
                } else {
                    r.add(RefType.v(Scene.v().getObjectType().toString()));
                    r.add(RefType.v("java.io.Serializable"));
                    r.add(RefType.v("java.lang.Cloneable"));
                }
            } else {
                for (Type type : ts) {
                    r.add(type.makeArrayType());
                }
            }
            return r;
        }
        if (a instanceof ArrayType || b instanceof ArrayType) {
            Type rt = a instanceof ArrayType ? b : a;
            LinkedList<Type> r = new LinkedList<Type>();
            if (!TypeResolver.typesEqual(Scene.v().getObjectType(), rt)) {
                RefType refCloneable;
                RefType refSerializable = RefType.v("java.io.Serializable");
                if (BytecodeHierarchy.ancestor_(refSerializable, rt)) {
                    r.add(refSerializable);
                }
                if (BytecodeHierarchy.ancestor_(refCloneable = RefType.v("java.lang.Cloneable"), rt)) {
                    r.add(refCloneable);
                }
            }
            if (r.isEmpty()) {
                r.add(Scene.v().getObjectType());
            }
            return r;
        }
        Collection<AncestryTreeNode> treea = BytecodeHierarchy.buildAncestryTree((RefType)a);
        Collection<AncestryTreeNode> treeb = BytecodeHierarchy.buildAncestryTree((RefType)b);
        LinkedList<Type> r = new LinkedList<Type>();
        for (AncestryTreeNode nodea : treea) {
            for (AncestryTreeNode nodeb : treeb) {
                RefType t = BytecodeHierarchy.leastCommonNode(nodea, nodeb);
                boolean least = true;
                ListIterator i = r.listIterator();
                while (i.hasNext()) {
                    Type t_ = (Type)i.next();
                    if (BytecodeHierarchy.ancestor_(t, t_)) {
                        least = false;
                        break;
                    }
                    if (!BytecodeHierarchy.ancestor_(t_, t)) continue;
                    i.remove();
                }
                if (!least) continue;
                r.add(t);
            }
        }
        if (r.isEmpty()) {
            r.add(Scene.v().getObjectType());
        }
        return r;
    }

    public static boolean ancestor_(Type ancestor, Type child) {
        if (TypeResolver.typesEqual(ancestor, child)) {
            return true;
        }
        if (child instanceof BottomType) {
            return true;
        }
        if (ancestor instanceof BottomType) {
            return false;
        }
        if (ancestor instanceof IntegerType && child instanceof IntegerType) {
            return true;
        }
        if (ancestor instanceof PrimType || child instanceof PrimType) {
            return false;
        }
        if (child instanceof NullType) {
            return true;
        }
        if (ancestor instanceof NullType) {
            return false;
        }
        return Scene.v().getOrMakeFastHierarchy().canStoreType(child, ancestor);
    }

    private static Deque<RefType> superclassPath(RefType t, RefType anchor) {
        ArrayDeque<RefType> r = new ArrayDeque<RefType>();
        r.addFirst(t);
        if (TypeResolver.typesEqual(t, anchor)) {
            return r;
        }
        SootClass sc = t.getSootClass();
        while (sc.hasSuperclass()) {
            sc = sc.getSuperclass();
            RefType cur = sc.getType();
            r.addFirst(cur);
            if (!TypeResolver.typesEqual(cur, anchor)) continue;
            break;
        }
        if (!TypeResolver.typesEqual((Type)r.getFirst(), anchor)) {
            r.addFirst(anchor);
        }
        return r;
    }

    public static RefType lcsc(RefType a, RefType b) {
        return BytecodeHierarchy.lcsc(a, b, Scene.v().getObjectType());
    }

    public static RefType lcsc(RefType a, RefType b, RefType anchor) {
        if (a == b) {
            return a;
        }
        Deque<RefType> pathA = BytecodeHierarchy.superclassPath(a, anchor);
        Deque<RefType> pathB = BytecodeHierarchy.superclassPath(b, anchor);
        RefType r = null;
        while (!pathA.isEmpty() && !pathB.isEmpty() && TypeResolver.typesEqual(pathA.getFirst(), pathB.getFirst())) {
            r = pathA.removeFirst();
            pathB.removeFirst();
        }
        return r;
    }

    @Override
    public Collection<Type> lcas(Type a, Type b, boolean useWeakObjectType) {
        return BytecodeHierarchy.lcas_(a, b, useWeakObjectType);
    }

    @Override
    public boolean ancestor(Type ancestor, Type child) {
        return BytecodeHierarchy.ancestor_(ancestor, child);
    }

    private static class AncestryTreeNode {
        public final AncestryTreeNode next;
        public final RefType type;

        public AncestryTreeNode(AncestryTreeNode next, RefType type) {
            this.next = next;
            this.type = type;
        }
    }
}

