/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.Iterator;
import java.util.Map;
import soot.EquivalentValue;
import soot.SideEffectTester;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.FieldRef;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;

public class DownSafetyAnalysis
extends BackwardFlowAnalysis<Unit, FlowSet<EquivalentValue>> {
    private final SideEffectTester sideEffect;
    private final Map<Unit, EquivalentValue> unitToGenerateMap;
    private final BoundedFlowSet<EquivalentValue> set;

    @Deprecated
    public DownSafetyAnalysis(DirectedGraph<Unit> dg) {
        super(dg);
        throw new RuntimeException("Don't use this Constructor!");
    }

    public DownSafetyAnalysis(DirectedGraph<Unit> dg, Map<Unit, EquivalentValue> unitToGen, SideEffectTester sideEffect) {
        this(dg, unitToGen, sideEffect, new ArrayPackedSet<EquivalentValue>(new CollectionFlowUniverse<EquivalentValue>(unitToGen.values())));
    }

    public DownSafetyAnalysis(DirectedGraph<Unit> dg, Map<Unit, EquivalentValue> unitToGen, SideEffectTester sideEffect, BoundedFlowSet<EquivalentValue> set) {
        super(dg);
        this.sideEffect = sideEffect;
        this.set = set;
        this.unitToGenerateMap = unitToGen;
        this.doAnalysis();
    }

    @Override
    protected FlowSet<EquivalentValue> newInitialFlow() {
        return this.set.topSet();
    }

    @Override
    protected FlowSet<EquivalentValue> entryInitialFlow() {
        return this.set.emptySet();
    }

    @Override
    protected void flowThrough(FlowSet<EquivalentValue> in, Unit u, FlowSet<EquivalentValue> out) {
        in.copy(out);
        Iterator<EquivalentValue> outIt = out.iterator();
        block0: while (outIt.hasNext()) {
            EquivalentValue equiVal = outIt.next();
            Value avail = equiVal.getValue();
            if (avail instanceof FieldRef) {
                if (!this.sideEffect.unitCanWriteTo(u, avail)) continue;
                outIt.remove();
                continue;
            }
            for (ValueBox next : avail.getUseBoxes()) {
                Value use = next.getValue();
                if (!this.sideEffect.unitCanWriteTo(u, use)) continue;
                outIt.remove();
                continue block0;
            }
        }
        EquivalentValue add = this.unitToGenerateMap.get(u);
        if (add != null) {
            out.add(add, out);
        }
    }

    @Override
    protected void merge(FlowSet<EquivalentValue> in1, FlowSet<EquivalentValue> in2, FlowSet<EquivalentValue> out) {
        in1.intersection(in2, out);
    }

    @Override
    protected void copy(FlowSet<EquivalentValue> source, FlowSet<EquivalentValue> dest) {
        source.copy(dest);
    }
}

