/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.Local;
import soot.Type;
import soot.jimple.Jimple;
import soot.jimple.toolkits.scalar.LocalCreation;

public class DefaultLocalCreation
extends LocalCreation {
    public static final String DEFAULT_PREFIX = "soot";
    private final Set<String> locals;
    private int counter;

    public DefaultLocalCreation(Collection<Local> locals) {
        this(locals, DEFAULT_PREFIX);
    }

    public DefaultLocalCreation(Collection<Local> locals, String prefix) {
        super(locals, prefix);
        this.locals = new HashSet<String>(locals.size());
        for (Local l : locals) {
            this.locals.add(l.getName());
        }
        this.counter = 0;
    }

    @Override
    public Local newLocal(Type type) {
        return this.newLocal(this.prefix, type);
    }

    @Override
    public Local newLocal(String prefix, Type type) {
        int suffix;
        int n = suffix = prefix.equals(this.prefix) ? this.counter : 0;
        while (this.locals.contains(prefix + suffix)) {
            ++suffix;
        }
        if (prefix.equals(this.prefix)) {
            this.counter = suffix + 1;
        }
        String newName = prefix + suffix;
        Local newLocal = Jimple.v().newLocal(newName, type);
        this.localChain.add(newLocal);
        this.locals.add(newName);
        return newLocal;
    }
}

