/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Context;
import soot.FastHierarchy;
import soot.Kind;
import soot.Local;
import soot.PhaseOptions;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.spark.builder.GlobalNodeFactory;
import soot.jimple.spark.builder.MethodNodeFactory;
import soot.jimple.spark.internal.ClientAccessibilityOracle;
import soot.jimple.spark.internal.SparkLibraryHelper;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.MethodPAG;
import soot.jimple.spark.pag.NewInstanceNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.StringConstantNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.BitPointsToSet;
import soot.jimple.spark.sets.DoublePointsToSet;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.HashPointsToSet;
import soot.jimple.spark.sets.HybridPointsToSet;
import soot.jimple.spark.sets.P2SetFactory;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.sets.SharedHybridSet;
import soot.jimple.spark.sets.SharedListSet;
import soot.jimple.spark.sets.SortedArraySet;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.pointer.util.NativeMethodDriver;
import soot.options.CGOptions;
import soot.options.SparkOptions;
import soot.tagkit.LinkTag;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.toolkits.scalar.Pair;
import soot.util.ArrayNumberer;
import soot.util.HashMultiMap;
import soot.util.LargeNumberedMap;
import soot.util.MultiMap;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class PAG
implements PointsToAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(PAG.class);
    protected static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    protected P2SetFactory setFactory;
    protected boolean somethingMerged = false;
    ChunkedQueue<AllocNode> newAllocNodes = new ChunkedQueue();
    protected ChunkedQueue<Node> edgeQueue = new ChunkedQueue();
    protected final ArrayNumberer<AllocNode> allocNodeNumberer = new ArrayNumberer();
    private final ArrayNumberer<VarNode> varNodeNumberer = new ArrayNumberer();
    private final ArrayNumberer<FieldRefNode> fieldRefNodeNumberer = new ArrayNumberer();
    private final ArrayNumberer<AllocDotField> allocDotFieldNodeNumberer = new ArrayNumberer();
    protected SparkOptions opts;
    protected CGOptions cgOpts;
    protected ClientAccessibilityOracle accessibilityOracle = Scene.v().getClientAccessibilityOracle();
    protected Map<VarNode, Object> simple = new HashMap<VarNode, Object>();
    protected Map<FieldRefNode, Object> load = new HashMap<FieldRefNode, Object>();
    protected Map<VarNode, Object> store = new HashMap<VarNode, Object>();
    protected Map<AllocNode, Object> alloc = new HashMap<AllocNode, Object>();
    protected Map<VarNode, Object> newInstance = new HashMap<VarNode, Object>();
    protected Map<NewInstanceNode, Object> assignInstance = new HashMap<NewInstanceNode, Object>();
    protected Map<VarNode, Object> simpleInv = new HashMap<VarNode, Object>();
    protected Map<VarNode, Object> loadInv = new HashMap<VarNode, Object>();
    protected Map<FieldRefNode, Object> storeInv = new HashMap<FieldRefNode, Object>();
    protected Map<VarNode, Object> allocInv = new HashMap<VarNode, Object>();
    protected Map<NewInstanceNode, Object> newInstanceInv = new HashMap<NewInstanceNode, Object>();
    protected Map<VarNode, Object> assignInstanceInv = new HashMap<VarNode, Object>();
    private boolean runGeomPTA = false;
    protected MultiMap<Pair<Node, Node>, Edge> assign2edges = new HashMultiMap<Pair<Node, Node>, Edge>();
    private final Map<Object, LocalVarNode> valToLocalVarNode = new HashMap<Object, LocalVarNode>(1000);
    private final Map<Object, GlobalVarNode> valToGlobalVarNode = new HashMap<Object, GlobalVarNode>(1000);
    private final Map<Object, AllocNode> valToAllocNode = new HashMap<Object, AllocNode>(1000);
    private final Table<Object, Type, AllocNode> valToReflAllocNode = HashBasedTable.create();
    private OnFlyCallGraph ofcg;
    private final ArrayList<VarNode> dereferences = new ArrayList();
    protected TypeManager typeManager;
    private final LargeNumberedMap<Local, LocalVarNode> localToNodeMap = new LargeNumberedMap(Scene.v().getLocalNumberer());
    private final Map<Value, NewInstanceNode> newInstToNodeMap = new HashMap<Value, NewInstanceNode>();
    public int maxFinishNumber = 0;
    private Map<Node, Tag> nodeToTag;
    private final GlobalNodeFactory nodeFactory = new GlobalNodeFactory(this);
    public NativeMethodDriver nativeMethodDriver;
    public HashMultiMap<InvokeExpr, Pair<Node, Node>> callAssigns;
    public Map<InvokeExpr, SootMethod> callToMethod;
    public Map<InvokeExpr, Node> virtualCallsToReceivers;

    public PAG(SparkOptions opts) {
        this.opts = opts;
        this.cgOpts = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        if (opts.add_tags()) {
            this.nodeToTag = new HashMap<Node, Tag>();
        }
        if (opts.rta() && opts.on_fly_cg()) {
            throw new RuntimeException("Incompatible options rta:true and on-fly-cg:true for cg.spark. Use -p cg-.spark on-fly-cg:false when using RTA.");
        }
        this.typeManager = new TypeManager(this);
        if (!opts.ignore_types()) {
            this.typeManager.setFastHierarchy(() -> Scene.v().getOrMakeFastHierarchy());
        }
        if (opts.cs_demand()) {
            this.virtualCallsToReceivers = new HashMap<InvokeExpr, Node>();
            this.callToMethod = new HashMap<InvokeExpr, SootMethod>();
            this.callAssigns = new HashMultiMap();
        }
        switch (opts.set_impl()) {
            case 1: {
                this.setFactory = HashPointsToSet.getFactory();
                break;
            }
            case 3: {
                this.setFactory = HybridPointsToSet.getFactory();
                break;
            }
            case 5: {
                this.setFactory = SharedHybridSet.getFactory();
                break;
            }
            case 6: {
                this.setFactory = SharedListSet.getFactory();
                break;
            }
            case 4: {
                this.setFactory = SortedArraySet.getFactory();
                break;
            }
            case 2: {
                this.setFactory = BitPointsToSet.getFactory();
                break;
            }
            case 7: {
                P2SetFactory newF;
                P2SetFactory oldF;
                switch (opts.double_set_old()) {
                    case 1: {
                        oldF = HashPointsToSet.getFactory();
                        break;
                    }
                    case 3: {
                        oldF = HybridPointsToSet.getFactory();
                        break;
                    }
                    case 5: {
                        oldF = SharedHybridSet.getFactory();
                        break;
                    }
                    case 6: {
                        oldF = SharedListSet.getFactory();
                        break;
                    }
                    case 4: {
                        oldF = SortedArraySet.getFactory();
                        break;
                    }
                    case 2: {
                        oldF = BitPointsToSet.getFactory();
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                switch (opts.double_set_new()) {
                    case 1: {
                        newF = HashPointsToSet.getFactory();
                        break;
                    }
                    case 3: {
                        newF = HybridPointsToSet.getFactory();
                        break;
                    }
                    case 5: {
                        newF = SharedHybridSet.getFactory();
                        break;
                    }
                    case 6: {
                        newF = SharedListSet.getFactory();
                        break;
                    }
                    case 4: {
                        newF = SortedArraySet.getFactory();
                        break;
                    }
                    case 2: {
                        newF = BitPointsToSet.getFactory();
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                this.setFactory = DoublePointsToSet.getFactory(newF, oldF);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.runGeomPTA = opts.geom_pta();
    }

    @Override
    public PointsToSet reachingObjects(Local l) {
        LocalVarNode n = this.findLocalVarNode(l);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l) {
        ContextVarNode n = this.findContextVarNode(l, c);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    @Override
    public PointsToSet reachingObjects(SootField f) {
        if (!f.isStatic()) {
            throw new RuntimeException("The parameter f must be a *static* field.");
        }
        GlobalVarNode n = this.findGlobalVarNode(f);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    @Override
    public PointsToSet reachingObjects(PointsToSet s, SootField f) {
        if (f.isStatic()) {
            throw new RuntimeException("The parameter f must be an *instance* field.");
        }
        return this.reachingObjectsInternal(s, f);
    }

    @Override
    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s) {
        return this.reachingObjectsInternal(s, ArrayElement.v());
    }

    private PointsToSet reachingObjectsInternal(PointsToSet s, final SparkField f) {
        if (this.getOpts().field_based() || this.getOpts().vta()) {
            GlobalVarNode n = this.findGlobalVarNode(f);
            if (n == null) {
                return EmptyPointsToSet.v();
            }
            return n.getP2Set();
        }
        if (this.getOpts().propagator() == 5) {
            throw new RuntimeException("The alias edge propagator does not compute points-to information for instance fields!Use a different propagator.");
        }
        PointsToSetInternal bases = (PointsToSetInternal)s;
        Object ret = this.setFactory.newSet(f instanceof SootField ? ((SootField)f).getType() : null, this);
        bases.forall(new P2SetVisitor((PointsToSetInternal)ret){
            final /* synthetic */ PointsToSetInternal val$ret;
            {
                this.val$ret = pointsToSetInternal;
            }

            @Override
            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF != null) {
                    this.val$ret.addAll(nDotF.getP2Set(), null);
                }
            }
        });
        return ret;
    }

    public P2SetFactory getSetFactory() {
        return this.setFactory;
    }

    private <K extends Node> void lookupInMap(Map<K, Object> map) {
        for (Node object : map.keySet()) {
            this.lookup(map, object);
        }
    }

    public void cleanUpMerges() {
        if (this.opts.verbose()) {
            logger.debug("Cleaning up graph for merged nodes");
        }
        this.lookupInMap(this.simple);
        this.lookupInMap(this.alloc);
        this.lookupInMap(this.store);
        this.lookupInMap(this.load);
        this.lookupInMap(this.simpleInv);
        this.lookupInMap(this.allocInv);
        this.lookupInMap(this.storeInv);
        this.lookupInMap(this.loadInv);
        this.somethingMerged = false;
        if (this.opts.verbose()) {
            logger.debug("Done cleaning up graph for merged nodes");
        }
    }

    public boolean doAddSimpleEdge(VarNode from, VarNode to) {
        return this.addToMap(this.simple, from, to) | this.addToMap(this.simpleInv, to, from);
    }

    public boolean doAddStoreEdge(VarNode from, FieldRefNode to) {
        return this.addToMap(this.store, from, to) | this.addToMap(this.storeInv, to, from);
    }

    public boolean doAddLoadEdge(FieldRefNode from, VarNode to) {
        return this.addToMap(this.load, from, to) | this.addToMap(this.loadInv, to, from);
    }

    public boolean doAddAllocEdge(AllocNode from, VarNode to) {
        return this.addToMap(this.alloc, from, to) | this.addToMap(this.allocInv, to, from);
    }

    public boolean doAddNewInstanceEdge(VarNode from, NewInstanceNode to) {
        return this.addToMap(this.newInstance, from, to) | this.addToMap(this.newInstanceInv, to, from);
    }

    public boolean doAddAssignInstanceEdge(NewInstanceNode from, VarNode to) {
        return this.addToMap(this.assignInstance, from, to) | this.addToMap(this.assignInstanceInv, to, from);
    }

    void mergedWith(Node n1, Node n2) {
        Map[] maps;
        if (n1.equals(n2)) {
            throw new RuntimeException("oops");
        }
        this.somethingMerged = true;
        if (this.ofcg() != null) {
            this.ofcg().mergedWith(n1, n2);
        }
        for (Map m : maps = new Map[]{this.simple, this.alloc, this.store, this.load, this.simpleInv, this.allocInv, this.storeInv, this.loadInv}) {
            if (!m.keySet().contains(n2)) continue;
            Object[] os = new Object[]{m.get(n1), m.get(n2)};
            int size1 = PAG.getSize(os[0]);
            int size2 = PAG.getSize(os[1]);
            if (size1 == 0) {
                if (os[1] != null) {
                    m.put(n1, os[1]);
                }
            } else if (size2 != 0) {
                Node[] ar;
                if (os[0] instanceof HashSet) {
                    if (os[1] instanceof HashSet) {
                        ((HashSet)os[0]).addAll((HashSet)os[1]);
                    } else {
                        ar = (Node[])os[1];
                        for (Node node : ar) {
                            ((HashSet)os[0]).add(node);
                        }
                    }
                } else if (os[1] instanceof HashSet) {
                    ar = (Node[])os[0];
                    for (Node node : ar) {
                        ((HashSet)os[1]).add(node);
                    }
                    m.put(n1, os[1]);
                } else if (size1 * size2 < 1000) {
                    Node[] a1 = (Node[])os[0];
                    Node[] a2 = (Node[])os[1];
                    Node[] ret = new Node[size1 + size2];
                    System.arraycopy(a1, 0, ret, 0, a1.length);
                    int j = a1.length;
                    block3: for (Node rep : a2) {
                        for (int k = 0; k < j; ++k) {
                            if (rep == ret[k]) continue block3;
                        }
                        ret[j++] = rep;
                    }
                    Node[] nodeArray = new Node[j];
                    System.arraycopy(ret, 0, nodeArray, 0, j);
                    ret = nodeArray;
                    m.put(n1, nodeArray);
                } else {
                    HashSet<Node> s = new HashSet<Node>(size1 + size2);
                    for (Object object : os) {
                        Node[] ar2;
                        if (object == null) continue;
                        if (object instanceof Set) {
                            s.addAll((Set)object);
                            continue;
                        }
                        for (Node element1 : ar2 = (Node[])object) {
                            s.add(element1);
                        }
                    }
                    m.put(n1, s);
                }
            }
            m.remove(n2);
        }
    }

    protected <K extends Node> Node[] lookup(Map<K, Object> m, K key) {
        Node[] valueList = m.get(key);
        if (valueList == null) {
            return EMPTY_NODE_ARRAY;
        }
        if (valueList instanceof Set) {
            try {
                valueList = ((Set)valueList).toArray(EMPTY_NODE_ARRAY);
                m.put(key, valueList);
            }
            catch (Exception e) {
                Iterator it = ((Set)valueList).iterator();
                while (it.hasNext()) {
                    logger.debug("" + it.next());
                }
                throw new RuntimeException("" + valueList + e);
            }
        }
        Node[] ret = valueList;
        if (this.somethingMerged) {
            for (int i = 0; i < ret.length; ++i) {
                int j;
                Node reti = ret[i];
                Node rep = reti.getReplacement();
                if (rep == reti && rep != key) continue;
                if (ret.length <= 75) {
                    int j2 = i;
                    while (i < ret.length) {
                        block14: {
                            reti = ret[i];
                            rep = reti.getReplacement();
                            if (rep != key) {
                                for (int k = 0; k < j2; ++k) {
                                    if (rep != ret[k]) {
                                        continue;
                                    }
                                    break block14;
                                }
                                ret[j2++] = rep;
                            }
                        }
                        ++i;
                    }
                    Node[] newArray = new Node[j2];
                    System.arraycopy(ret, 0, newArray, 0, j2);
                    ret = newArray;
                    m.put(key, newArray);
                    break;
                }
                HashSet<Node> s = new HashSet<Node>(ret.length * 2);
                for (j = 0; j < i; ++j) {
                    s.add(ret[j]);
                }
                for (j = i; j < ret.length; ++j) {
                    rep = ret[j].getReplacement();
                    if (rep == key) continue;
                    s.add(rep);
                }
                ret = s.toArray(EMPTY_NODE_ARRAY);
                m.put(key, ret);
                break;
            }
        }
        return ret;
    }

    public Node[] simpleLookup(VarNode key) {
        return this.lookup(this.simple, key);
    }

    public Node[] simpleInvLookup(VarNode key) {
        return this.lookup(this.simpleInv, key);
    }

    public Node[] loadLookup(FieldRefNode key) {
        return this.lookup(this.load, key);
    }

    public Node[] loadInvLookup(VarNode key) {
        return this.lookup(this.loadInv, key);
    }

    public Node[] storeLookup(VarNode key) {
        return this.lookup(this.store, key);
    }

    public Node[] newInstanceLookup(VarNode key) {
        return this.lookup(this.newInstance, key);
    }

    public Node[] assignInstanceLookup(NewInstanceNode key) {
        return this.lookup(this.assignInstance, key);
    }

    public Node[] storeInvLookup(FieldRefNode key) {
        return this.lookup(this.storeInv, key);
    }

    public Node[] allocLookup(AllocNode key) {
        return this.lookup(this.alloc, key);
    }

    public Node[] allocInvLookup(VarNode key) {
        return this.lookup(this.allocInv, key);
    }

    public Set<VarNode> simpleSources() {
        return this.simple.keySet();
    }

    public Set<AllocNode> allocSources() {
        return this.alloc.keySet();
    }

    public Set<VarNode> storeSources() {
        return this.store.keySet();
    }

    public Set<FieldRefNode> loadSources() {
        return this.load.keySet();
    }

    public Set<VarNode> newInstanceSources() {
        return this.newInstance.keySet();
    }

    public Set<NewInstanceNode> assignInstanceSources() {
        return this.assignInstance.keySet();
    }

    public Set<VarNode> simpleInvSources() {
        return this.simpleInv.keySet();
    }

    public Set<VarNode> allocInvSources() {
        return this.allocInv.keySet();
    }

    public Set<FieldRefNode> storeInvSources() {
        return this.storeInv.keySet();
    }

    public Set<VarNode> loadInvSources() {
        return this.loadInv.keySet();
    }

    public Iterator<VarNode> simpleSourcesIterator() {
        return this.simple.keySet().iterator();
    }

    public Iterator<AllocNode> allocSourcesIterator() {
        return this.alloc.keySet().iterator();
    }

    public Iterator<VarNode> storeSourcesIterator() {
        return this.store.keySet().iterator();
    }

    public Iterator<FieldRefNode> loadSourcesIterator() {
        return this.load.keySet().iterator();
    }

    public Iterator<VarNode> simpleInvSourcesIterator() {
        return this.simpleInv.keySet().iterator();
    }

    public Iterator<VarNode> allocInvSourcesIterator() {
        return this.allocInv.keySet().iterator();
    }

    public Iterator<FieldRefNode> storeInvSourcesIterator() {
        return this.storeInv.keySet().iterator();
    }

    public Iterator<VarNode> loadInvSourcesIterator() {
        return this.loadInv.keySet().iterator();
    }

    private static int getSize(Object set) {
        if (set instanceof Set) {
            return ((Set)set).size();
        }
        if (set == null) {
            return 0;
        }
        return ((Object[])set).length;
    }

    @Override
    public PointsToSet reachingObjects(Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(l), f);
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(c, l), f);
    }

    private void addNodeTag(Node node, SootMethod m) {
        if (this.nodeToTag != null) {
            StringTag tag = m == null ? new StringTag(node.toString()) : new LinkTag(node.toString(), m, m.getDeclaringClass().getName());
            this.nodeToTag.put(node, tag);
        }
    }

    public AllocNode makeAllocNode(Object newExpr, Type type, SootMethod m) {
        if (this.opts.types_for_sites() || this.opts.vta()) {
            newExpr = type;
        }
        AllocNode ret = this.valToAllocNode.get(newExpr);
        if (newExpr instanceof NewExpr) {
            if (ret == null) {
                ret = new AllocNode(this, newExpr, type, m);
                this.valToAllocNode.put(newExpr, ret);
                this.newAllocNodes.add(ret);
                this.addNodeTag(ret, m);
            } else if (!ret.getType().equals(type)) {
                throw new RuntimeException("NewExpr " + newExpr + " of type " + type + " previously had type " + ret.getType());
            }
        } else {
            ret = (AllocNode)this.valToReflAllocNode.get(newExpr, (Object)type);
            if (ret == null) {
                ret = new AllocNode(this, newExpr, type, m);
                this.valToReflAllocNode.put(newExpr, (Object)type, (Object)ret);
                this.newAllocNodes.add(ret);
                this.addNodeTag(ret, m);
            }
        }
        return ret;
    }

    public AllocNode makeStringConstantNode(String s) {
        if (this.opts.types_for_sites() || this.opts.vta()) {
            return this.makeAllocNode(RefType.v("java.lang.String"), RefType.v("java.lang.String"), null);
        }
        StringConstantNode ret = (StringConstantNode)this.valToAllocNode.get(s);
        if (ret == null) {
            ret = new StringConstantNode(this, s);
            this.valToAllocNode.put(s, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, null);
        }
        return ret;
    }

    public AllocNode makeClassConstantNode(ClassConstant cc) {
        if (this.opts.types_for_sites() || this.opts.vta()) {
            return this.makeAllocNode(RefType.v("java.lang.Class"), RefType.v("java.lang.Class"), null);
        }
        ClassConstantNode ret = (ClassConstantNode)this.valToAllocNode.get(cc);
        if (ret == null) {
            ret = new ClassConstantNode(this, cc);
            this.valToAllocNode.put(cc, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, null);
        }
        return ret;
    }

    public QueueReader<AllocNode> allocNodeListener() {
        return this.newAllocNodes.reader();
    }

    public GlobalVarNode findGlobalVarNode(Object value) {
        if (this.opts.rta()) {
            value = null;
        }
        return this.valToGlobalVarNode.get(value);
    }

    public LocalVarNode findLocalVarNode(Object value) {
        if (this.opts.rta()) {
            value = null;
        } else if (value instanceof Local) {
            return this.localToNodeMap.get((Local)value);
        }
        return this.valToLocalVarNode.get(value);
    }

    public GlobalVarNode makeGlobalVarNode(Object value, Type type) {
        GlobalVarNode ret;
        if (this.opts.rta()) {
            value = null;
            type = Scene.v().getObjectType();
        }
        if ((ret = this.valToGlobalVarNode.get(value)) == null) {
            SootField sf;
            ret = new GlobalVarNode(this, value, type);
            this.valToGlobalVarNode.put(value, ret);
            if (this.cgOpts.library() != 1 && value instanceof SootField && this.accessibilityOracle.isAccessible(sf = (SootField)value)) {
                type.apply(new SparkLibraryHelper(this, ret, null));
            }
            this.addNodeTag(ret, null);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public LocalVarNode makeLocalVarNode(Object value, Type type, SootMethod method) {
        if (this.opts.rta()) {
            value = null;
            type = Scene.v().getObjectType();
            method = null;
        } else if (value instanceof Local) {
            LocalVarNode ret;
            Local val = (Local)value;
            if (val.getNumber() == 0) {
                Scene.v().getLocalNumberer().add(val);
            }
            if ((ret = this.localToNodeMap.get(val)) == null) {
                ret = new LocalVarNode(this, value, type, method);
                this.localToNodeMap.put((Local)value, ret);
                this.addNodeTag(ret, method);
            } else if (!ret.getType().equals(type)) {
                throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
            }
            return ret;
        }
        LocalVarNode ret = this.valToLocalVarNode.get(value);
        if (ret == null) {
            ret = new LocalVarNode(this, value, type, method);
            this.valToLocalVarNode.put(value, ret);
            this.addNodeTag(ret, method);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public NewInstanceNode makeNewInstanceNode(Value value, Type type, SootMethod method) {
        NewInstanceNode node = this.newInstToNodeMap.get(value);
        if (node == null) {
            node = new NewInstanceNode(this, value, type);
            this.newInstToNodeMap.put(value, node);
            this.addNodeTag(node, method);
        }
        return node;
    }

    public ContextVarNode findContextVarNode(Object baseValue, Context context) {
        LocalVarNode base = this.findLocalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.context(context);
    }

    public ContextVarNode makeContextVarNode(Object baseValue, Type baseType, Context context, SootMethod method) {
        LocalVarNode base = this.makeLocalVarNode(baseValue, baseType, method);
        return this.makeContextVarNode(base, context);
    }

    public ContextVarNode makeContextVarNode(LocalVarNode base, Context context) {
        ContextVarNode ret = base.context(context);
        if (ret == null) {
            ret = new ContextVarNode(this, base, context);
            this.addNodeTag(ret, base.getMethod());
        }
        return ret;
    }

    public FieldRefNode findLocalFieldRefNode(Object baseValue, SparkField field) {
        LocalVarNode base = this.findLocalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.dot(field);
    }

    public FieldRefNode findGlobalFieldRefNode(Object baseValue, SparkField field) {
        GlobalVarNode base = this.findGlobalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.dot(field);
    }

    public FieldRefNode makeLocalFieldRefNode(Object baseValue, Type baseType, SparkField field, SootMethod method) {
        LocalVarNode base = this.makeLocalVarNode(baseValue, baseType, method);
        FieldRefNode ret = this.makeFieldRefNode(base, field);
        if (this.cgOpts.library() != 1 && field instanceof SootField) {
            SootField sf = (SootField)field;
            Type type = sf.getType();
            if (this.accessibilityOracle.isAccessible(sf)) {
                type.apply(new SparkLibraryHelper(this, ret, method));
            }
        }
        return ret;
    }

    public FieldRefNode makeGlobalFieldRefNode(Object baseValue, Type baseType, SparkField field) {
        GlobalVarNode base = this.makeGlobalVarNode(baseValue, baseType);
        return this.makeFieldRefNode(base, field);
    }

    public FieldRefNode makeFieldRefNode(VarNode base, SparkField field) {
        FieldRefNode ret = base.dot(field);
        if (ret == null) {
            ret = new FieldRefNode(this, base, field);
            if (base instanceof LocalVarNode) {
                this.addNodeTag(ret, ((LocalVarNode)base).getMethod());
            } else {
                this.addNodeTag(ret, null);
            }
        }
        return ret;
    }

    public AllocDotField findAllocDotField(AllocNode an, SparkField field) {
        return an.dot(field);
    }

    public AllocDotField makeAllocDotField(AllocNode an, SparkField field) {
        AllocDotField ret = an.dot(field);
        if (ret == null) {
            ret = new AllocDotField(this, an, field);
        }
        return ret;
    }

    public boolean addSimpleEdge(VarNode from, VarNode to) {
        boolean ret = false;
        if (this.doAddSimpleEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            ret = true;
        }
        if (this.opts.simple_edges_bidirectional() && this.doAddSimpleEdge(to, from)) {
            this.edgeQueue.add(to);
            this.edgeQueue.add(from);
            ret = true;
        }
        return ret;
    }

    public boolean addStoreEdge(VarNode from, FieldRefNode to) {
        if (!this.opts.rta() && this.doAddStoreEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public boolean addLoadEdge(FieldRefNode from, VarNode to) {
        if (!this.opts.rta() && this.doAddLoadEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public boolean addAllocEdge(AllocNode from, VarNode to) {
        FastHierarchy fh = this.typeManager.getFastHierarchy();
        if ((fh == null || to.getType() == null || fh.canStoreType(from.getType(), to.getType())) && this.doAddAllocEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public boolean addNewInstanceEdge(VarNode from, NewInstanceNode to) {
        if (!this.opts.rta() && this.doAddNewInstanceEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public boolean addAssignInstanceEdge(NewInstanceNode from, VarNode to) {
        if (!this.opts.rta() && this.doAddAssignInstanceEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public boolean addEdge(Node from, Node to) {
        from = from.getReplacement();
        to = to.getReplacement();
        if (from instanceof VarNode) {
            if (to instanceof VarNode) {
                return this.addSimpleEdge((VarNode)from, (VarNode)to);
            }
            if (to instanceof FieldRefNode) {
                return this.addStoreEdge((VarNode)from, (FieldRefNode)to);
            }
            if (to instanceof NewInstanceNode) {
                return this.addNewInstanceEdge((VarNode)from, (NewInstanceNode)to);
            }
            throw new RuntimeException("Invalid node type");
        }
        if (from instanceof FieldRefNode) {
            return this.addLoadEdge((FieldRefNode)from, (VarNode)to);
        }
        if (from instanceof NewInstanceNode) {
            return this.addAssignInstanceEdge((NewInstanceNode)from, (VarNode)to);
        }
        return this.addAllocEdge((AllocNode)from, (VarNode)to);
    }

    public QueueReader<Node> edgeReader() {
        return this.edgeQueue.reader();
    }

    public int getNumAllocNodes() {
        return this.allocNodeNumberer.size();
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setOnFlyCallGraph(OnFlyCallGraph ofcg) {
        this.ofcg = ofcg;
    }

    public OnFlyCallGraph getOnFlyCallGraph() {
        return this.ofcg;
    }

    public OnFlyCallGraph ofcg() {
        return this.ofcg;
    }

    public void addDereference(VarNode base) {
        this.dereferences.add(base);
    }

    public List<VarNode> getDereferences() {
        return this.dereferences;
    }

    public Map<Node, Tag> getNodeTags() {
        return this.nodeToTag;
    }

    public ArrayNumberer<AllocNode> getAllocNodeNumberer() {
        return this.allocNodeNumberer;
    }

    public ArrayNumberer<VarNode> getVarNodeNumberer() {
        return this.varNodeNumberer;
    }

    public ArrayNumberer<FieldRefNode> getFieldRefNodeNumberer() {
        return this.fieldRefNodeNumberer;
    }

    public ArrayNumberer<AllocDotField> getAllocDotFieldNodeNumberer() {
        return this.allocDotFieldNodeNumberer;
    }

    public SparkOptions getOpts() {
        return this.opts;
    }

    public CGOptions getCGOpts() {
        return this.cgOpts;
    }

    public Pair<Node, Node> addInterproceduralAssignment(Node from, Node to, Edge e) {
        Pair<Node, Node> val = new Pair<Node, Node>(from, to);
        if (this.runGeomPTA) {
            this.assign2edges.put(val, e);
        }
        return val;
    }

    public Set<Edge> lookupEdgesForAssignment(Pair<Node, Node> val) {
        return this.assign2edges.get(val);
    }

    public void addCallTarget(Edge e) {
        if (!e.passesParameters()) {
            return;
        }
        MethodPAG srcmpag = MethodPAG.v(this, e.src());
        MethodPAG tgtmpag = MethodPAG.v(this, e.tgt());
        if (e.isExplicit() || e.kind() == Kind.THREAD) {
            this.addCallTarget(srcmpag, tgtmpag, (Stmt)e.srcUnit(), e.srcCtxt(), e.tgtCtxt(), e);
        } else if (e.kind() == Kind.ASYNCTASK) {
            this.addCallTarget(srcmpag, tgtmpag, (Stmt)e.srcUnit(), e.srcCtxt(), e.tgtCtxt(), e, false);
        } else if (e.kind() == Kind.EXECUTOR) {
            InvokeExpr ie = e.srcStmt().getInvokeExpr();
            Node parm = srcmpag.nodeFactory().getNode(ie.getArg(0));
            parm = srcmpag.parameterize(parm, e.srcCtxt());
            parm = parm.getReplacement();
            Node thiz = tgtmpag.nodeFactory().caseThis();
            thiz = tgtmpag.parameterize(thiz, e.tgtCtxt());
            thiz = thiz.getReplacement();
            this.addEdge(parm, thiz);
            Pair<Node, Node> pval = this.addInterproceduralAssignment(parm, thiz, e);
            if (this.callAssigns != null) {
                boolean virtualCall;
                this.callToMethod.put(ie, srcmpag.getMethod());
                boolean bl = virtualCall = !this.callAssigns.put(ie, pval);
                if (virtualCall) {
                    this.virtualCallsToReceivers.putIfAbsent(ie, parm);
                }
            }
        } else if (e.kind() == Kind.HANDLER) {
            InvokeExpr ie = e.srcStmt().getInvokeExpr();
            Node base = srcmpag.nodeFactory().getNode(((VirtualInvokeExpr)ie).getBase());
            base = srcmpag.parameterize(base, e.srcCtxt());
            base = base.getReplacement();
            Node thiz = tgtmpag.nodeFactory().caseThis();
            thiz = tgtmpag.parameterize(thiz, e.tgtCtxt());
            thiz = thiz.getReplacement();
            this.addEdge(base, thiz);
            Pair<Node, Node> pval = this.addInterproceduralAssignment(base, thiz, e);
            if (this.callAssigns != null) {
                boolean virtualCall;
                boolean bl = virtualCall = !this.callAssigns.put(ie, pval);
                assert (virtualCall);
                this.callToMethod.put(ie, srcmpag.getMethod());
                this.virtualCallsToReceivers.put(ie, base);
            }
        } else if (e.kind() == Kind.PRIVILEGED) {
            InvokeExpr ie = e.srcStmt().getInvokeExpr();
            Node parm = srcmpag.nodeFactory().getNode(ie.getArg(0));
            parm = srcmpag.parameterize(parm, e.srcCtxt());
            parm = parm.getReplacement();
            Node thiz = tgtmpag.nodeFactory().caseThis();
            thiz = tgtmpag.parameterize(thiz, e.tgtCtxt());
            thiz = thiz.getReplacement();
            this.addEdge(parm, thiz);
            Pair<Node, Node> pval = this.addInterproceduralAssignment(parm, thiz, e);
            if (this.callAssigns != null) {
                this.callAssigns.put(ie, pval);
                this.callToMethod.put(ie, srcmpag.getMethod());
            }
            if (e.srcUnit() instanceof AssignStmt) {
                AssignStmt as = (AssignStmt)e.srcUnit();
                Node ret = tgtmpag.nodeFactory().caseRet();
                ret = tgtmpag.parameterize(ret, e.tgtCtxt());
                ret = ret.getReplacement();
                Node lhs = srcmpag.nodeFactory().getNode(as.getLeftOp());
                lhs = srcmpag.parameterize(lhs, e.srcCtxt());
                lhs = lhs.getReplacement();
                this.addEdge(ret, lhs);
                pval = this.addInterproceduralAssignment(ret, lhs, e);
                if (this.callAssigns != null) {
                    this.callAssigns.put(ie, pval);
                    this.callToMethod.put(ie, srcmpag.getMethod());
                }
            }
        } else if (e.kind() == Kind.FINALIZE) {
            Node srcThis = srcmpag.nodeFactory().caseThis();
            srcThis = srcmpag.parameterize(srcThis, e.srcCtxt());
            srcThis = srcThis.getReplacement();
            Node tgtThis = tgtmpag.nodeFactory().caseThis();
            tgtThis = tgtmpag.parameterize(tgtThis, e.tgtCtxt());
            tgtThis = tgtThis.getReplacement();
            this.addEdge(srcThis, tgtThis);
            Pair<Node, Node> pval = this.addInterproceduralAssignment(srcThis, tgtThis, e);
        } else if (e.kind() == Kind.NEWINSTANCE) {
            Stmt s = (Stmt)e.srcUnit();
            InstanceInvokeExpr iie = (InstanceInvokeExpr)s.getInvokeExpr();
            Node cls = srcmpag.nodeFactory().getNode(iie.getBase());
            cls = srcmpag.parameterize(cls, e.srcCtxt());
            cls = cls.getReplacement();
            Node newObject = this.nodeFactory.caseNewInstance((VarNode)cls);
            Node initThis = tgtmpag.nodeFactory().caseThis();
            initThis = tgtmpag.parameterize(initThis, e.tgtCtxt());
            initThis = initThis.getReplacement();
            this.addEdge(newObject, initThis);
            if (s instanceof AssignStmt) {
                AssignStmt as = (AssignStmt)s;
                Node asLHS = srcmpag.nodeFactory().getNode(as.getLeftOp());
                asLHS = srcmpag.parameterize(asLHS, e.srcCtxt());
                asLHS = asLHS.getReplacement();
                this.addEdge(newObject, asLHS);
            }
            Pair<Node, Node> pval = this.addInterproceduralAssignment(newObject, initThis, e);
            if (this.callAssigns != null) {
                this.callAssigns.put(s.getInvokeExpr(), pval);
                this.callToMethod.put(s.getInvokeExpr(), srcmpag.getMethod());
            }
        } else if (e.kind() == Kind.REFL_INVOKE) {
            Pair<Node, Node> pval;
            InvokeExpr ie = e.srcStmt().getInvokeExpr();
            Value arg0 = ie.getArg(0);
            if (arg0 != NullConstant.v()) {
                Node parm0 = srcmpag.nodeFactory().getNode(arg0);
                parm0 = srcmpag.parameterize(parm0, e.srcCtxt());
                parm0 = parm0.getReplacement();
                Node thiz = tgtmpag.nodeFactory().caseThis();
                thiz = tgtmpag.parameterize(thiz, e.tgtCtxt());
                thiz = thiz.getReplacement();
                this.addEdge(parm0, thiz);
                pval = this.addInterproceduralAssignment(parm0, thiz, e);
                if (this.callAssigns != null) {
                    this.callAssigns.put(ie, pval);
                    this.callToMethod.put(ie, srcmpag.getMethod());
                }
            }
            Value arg1 = ie.getArg(1);
            SootMethod tgt = e.getTgt().method();
            if (arg1 != NullConstant.v() && tgt.getParameterCount() > 0) {
                Node parm1 = srcmpag.nodeFactory().getNode(arg1);
                parm1 = srcmpag.parameterize(parm1, e.srcCtxt());
                parm1 = parm1.getReplacement();
                FieldRefNode parm1contents = this.makeFieldRefNode((VarNode)parm1, ArrayElement.v());
                for (int i = 0; i < tgt.getParameterCount(); ++i) {
                    if (!(tgt.getParameterType(i) instanceof RefLikeType)) continue;
                    Node tgtParmI = tgtmpag.nodeFactory().caseParm(i);
                    tgtParmI = tgtmpag.parameterize(tgtParmI, e.tgtCtxt());
                    tgtParmI = tgtParmI.getReplacement();
                    this.addEdge(parm1contents, tgtParmI);
                    pval = this.addInterproceduralAssignment(parm1contents, tgtParmI, e);
                    if (this.callAssigns == null) continue;
                    this.callAssigns.put(ie, pval);
                }
            }
            if (e.srcUnit() instanceof AssignStmt && tgt.getReturnType() instanceof RefLikeType) {
                AssignStmt as = (AssignStmt)e.srcUnit();
                Node ret = tgtmpag.nodeFactory().caseRet();
                ret = tgtmpag.parameterize(ret, e.tgtCtxt());
                ret = ret.getReplacement();
                Node lhs = srcmpag.nodeFactory().getNode(as.getLeftOp());
                lhs = srcmpag.parameterize(lhs, e.srcCtxt());
                lhs = lhs.getReplacement();
                this.addEdge(ret, lhs);
                pval = this.addInterproceduralAssignment(ret, lhs, e);
                if (this.callAssigns != null) {
                    this.callAssigns.put(ie, pval);
                }
            }
        } else if (e.kind() == Kind.REFL_CLASS_NEWINSTANCE || e.kind() == Kind.REFL_CONSTR_NEWINSTANCE) {
            Pair<Node, Node> pval;
            Stmt s = (Stmt)e.srcUnit();
            InstanceInvokeExpr iie = (InstanceInvokeExpr)s.getInvokeExpr();
            Node cls = srcmpag.nodeFactory().getNode(iie.getBase());
            cls = srcmpag.parameterize(cls, e.srcCtxt());
            if ((cls = cls.getReplacement()) instanceof ContextVarNode) {
                cls = this.findLocalVarNode(((VarNode)cls).getVariable());
            }
            GlobalVarNode newObject = this.makeGlobalVarNode(cls, Scene.v().getObjectType());
            SootClass tgtClass = e.getTgt().method().getDeclaringClass();
            RefType tgtType = tgtClass.getType();
            AllocNode site = this.makeAllocNode(new Pair<Node, SootClass>(cls, tgtClass), tgtType, null);
            this.addEdge(site, newObject);
            Node initThis = tgtmpag.nodeFactory().caseThis();
            initThis = tgtmpag.parameterize(initThis, e.tgtCtxt());
            initThis = initThis.getReplacement();
            this.addEdge(newObject, initThis);
            this.addInterproceduralAssignment(newObject, initThis, e);
            if (e.kind() == Kind.REFL_CONSTR_NEWINSTANCE) {
                Value arg = iie.getArg(0);
                SootMethod tgt = e.getTgt().method();
                if (arg != NullConstant.v() && tgt.getParameterCount() > 0) {
                    Node parm0 = srcmpag.nodeFactory().getNode(arg);
                    parm0 = srcmpag.parameterize(parm0, e.srcCtxt());
                    parm0 = parm0.getReplacement();
                    FieldRefNode parm1contents = this.makeFieldRefNode((VarNode)parm0, ArrayElement.v());
                    for (int i = 0; i < tgt.getParameterCount(); ++i) {
                        if (!(tgt.getParameterType(i) instanceof RefLikeType)) continue;
                        Node tgtParmI = tgtmpag.nodeFactory().caseParm(i);
                        tgtParmI = tgtmpag.parameterize(tgtParmI, e.tgtCtxt());
                        tgtParmI = tgtParmI.getReplacement();
                        this.addEdge(parm1contents, tgtParmI);
                        pval = this.addInterproceduralAssignment(parm1contents, tgtParmI, e);
                        if (this.callAssigns == null) continue;
                        this.callAssigns.put(iie, pval);
                    }
                }
            }
            if (s instanceof AssignStmt) {
                AssignStmt as = (AssignStmt)s;
                Node asLHS = srcmpag.nodeFactory().getNode(as.getLeftOp());
                asLHS = srcmpag.parameterize(asLHS, e.srcCtxt());
                asLHS = asLHS.getReplacement();
                this.addEdge(newObject, asLHS);
            }
            pval = this.addInterproceduralAssignment(newObject, initThis, e);
            if (this.callAssigns != null) {
                this.callAssigns.put(s.getInvokeExpr(), pval);
                this.callToMethod.put(s.getInvokeExpr(), srcmpag.getMethod());
            }
        } else {
            throw new RuntimeException("Unhandled edge " + e);
        }
    }

    public void addCallTarget(MethodPAG srcmpag, MethodPAG tgtmpag, Stmt s, Context srcContext, Context tgtContext, Edge e) {
        this.addCallTarget(srcmpag, tgtmpag, s, srcContext, tgtContext, e, true);
    }

    public void addCallTarget(MethodPAG srcmpag, MethodPAG tgtmpag, Stmt s, Context srcContext, Context tgtContext, Edge e, boolean propagateReturn) {
        Value dest;
        Pair<Node, Node> pval;
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
        InvokeExpr ie = s.getInvokeExpr();
        int numArgs = ie.getArgCount();
        for (int i = 0; i < numArgs; ++i) {
            Value arg = ie.getArg(i);
            if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
            Node argNode = srcnf.getNode(arg);
            argNode = srcmpag.parameterize(argNode, srcContext);
            argNode = argNode.getReplacement();
            Node parm = tgtnf.caseParm(i);
            if (parm == null) continue;
            parm = tgtmpag.parameterize(parm, tgtContext);
            parm = parm.getReplacement();
            this.addEdge(argNode, parm);
            Pair<Node, Node> pval2 = this.addInterproceduralAssignment(argNode, parm, e);
            if (this.callAssigns == null) continue;
            this.callAssigns.put(ie, pval2);
            this.callToMethod.put(ie, srcmpag.getMethod());
        }
        if (ie instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            Node baseNode = srcnf.getNode(iie.getBase());
            baseNode = srcmpag.parameterize(baseNode, srcContext);
            baseNode = baseNode.getReplacement();
            Node thisRef = tgtnf.caseThis();
            thisRef = tgtmpag.parameterize(thisRef, tgtContext);
            thisRef = thisRef.getReplacement();
            this.addEdge(baseNode, thisRef);
            pval = this.addInterproceduralAssignment(baseNode, thisRef, e);
            if (this.callAssigns != null) {
                boolean virtualCall = !this.callAssigns.put(ie, pval);
                this.callToMethod.put(ie, srcmpag.getMethod());
                if (virtualCall) {
                    this.virtualCallsToReceivers.putIfAbsent(ie, baseNode);
                }
            }
        }
        if (propagateReturn && s instanceof AssignStmt && (dest = ((AssignStmt)s).getLeftOp()).getType() instanceof RefLikeType && !(dest instanceof NullConstant)) {
            Node destNode = srcnf.getNode(dest);
            destNode = srcmpag.parameterize(destNode, srcContext);
            destNode = destNode.getReplacement();
            Node retNode = tgtnf.caseRet();
            retNode = tgtmpag.parameterize(retNode, tgtContext);
            retNode = retNode.getReplacement();
            this.addEdge(retNode, destNode);
            pval = this.addInterproceduralAssignment(retNode, destNode, e);
            if (this.callAssigns != null) {
                this.callAssigns.put(ie, pval);
                this.callToMethod.put(ie, srcmpag.getMethod());
            }
        }
    }

    public void cleanPAG() {
        this.simple.clear();
        this.load.clear();
        this.store.clear();
        this.alloc.clear();
        this.simpleInv.clear();
        this.loadInv.clear();
        this.storeInv.clear();
        this.allocInv.clear();
    }

    protected <K extends Node> boolean addToMap(Map<K, Object> m, K key, Node value) {
        HashSet valueList = m.get(key);
        if (valueList == null) {
            valueList = new HashSet(4);
            m.put(key, valueList);
        } else if (!(valueList instanceof Set)) {
            Node[] ar = (Node[])valueList;
            HashSet<Node> vl = new HashSet<Node>(ar.length + 4);
            m.put(key, vl);
            for (Node element : ar) {
                vl.add(element);
            }
            return vl.add(value);
        }
        return ((Set)valueList).add(value);
    }

    public GlobalNodeFactory nodeFactory() {
        return this.nodeFactory;
    }
}

