/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand;

import java.util.HashSet;
import java.util.Set;
import soot.RefType;
import soot.SootField;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.ondemand.FieldCheckHeuristic;
import soot.jimple.spark.ondemand.pautil.SootUtil;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.SparkField;

public class IncrementalTypesHeuristic
implements FieldCheckHeuristic {
    private final TypeManager manager;
    private static final boolean EXCLUDE_TYPES = false;
    private static final String[] EXCLUDED_NAMES = new String[]{"ca.mcgill.sable.soot.SootMethod"};
    private Set<RefType> typesToCheck = new HashSet<RefType>();
    private Set<RefType> notBothEndsTypes = new HashSet<RefType>();
    private RefType newTypeOnQuery = null;

    @Override
    public boolean runNewPass() {
        if (this.newTypeOnQuery != null) {
            boolean added = this.typesToCheck.add(this.newTypeOnQuery);
            if (SootUtil.hasRecursiveField(this.newTypeOnQuery.getSootClass())) {
                this.notBothEndsTypes.add(this.newTypeOnQuery);
            }
            this.newTypeOnQuery = null;
            return added;
        }
        return false;
    }

    @Override
    public boolean validateMatchesForField(SparkField field) {
        if (field instanceof ArrayElement) {
            return true;
        }
        SootField sootField = (SootField)field;
        RefType declaringType = sootField.getDeclaringClass().getType();
        for (RefType typeToCheck : this.typesToCheck) {
            if (!this.manager.castNeverFails(declaringType, typeToCheck)) continue;
            return true;
        }
        if (this.newTypeOnQuery == null) {
            this.newTypeOnQuery = declaringType;
        }
        return false;
    }

    public IncrementalTypesHeuristic(TypeManager manager) {
        this.manager = manager;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("types ");
        ret.append(this.typesToCheck.toString());
        if (!this.notBothEndsTypes.isEmpty()) {
            ret.append(" not both ");
            ret.append(this.notBothEndsTypes.toString());
        }
        return ret.toString();
    }

    @Override
    public boolean validFromBothEnds(SparkField field) {
        if (field instanceof SootField) {
            SootField sootField = (SootField)field;
            RefType declaringType = sootField.getDeclaringClass().getType();
            for (RefType type : this.notBothEndsTypes) {
                if (!this.manager.castNeverFails(declaringType, type)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean refineVirtualCall(SootUtil.CallSiteAndContext callSiteAndContext) {
        return true;
    }
}

