/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.LookupSwitchInst;
import soot.baf.PlaceholderInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.StmtSwitch;
import soot.jimple.internal.AbstractSwitchStmt;
import soot.util.Switch;

public class JLookupSwitchStmt
extends AbstractSwitchStmt
implements LookupSwitchStmt {
    protected List<IntConstant> lookupValues;

    public JLookupSwitchStmt(Value key, List<IntConstant> lookupValues, List<? extends Unit> targets, Unit defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lookupValues, JLookupSwitchStmt.getTargetBoxesArray(targets, Jimple.v()::newStmtBox), Jimple.v().newStmtBox(defaultTarget));
    }

    public JLookupSwitchStmt(Value key, List<IntConstant> lookupValues, List<? extends UnitBox> targets, UnitBox defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lookupValues, targets.toArray(new UnitBox[targets.size()]), defaultTarget);
    }

    protected JLookupSwitchStmt(ValueBox keyBox, List<IntConstant> lookupValues, UnitBox[] targetBoxes, UnitBox defaultTargetBox) {
        super(keyBox, defaultTargetBox, targetBoxes);
        this.setLookupValues(lookupValues);
    }

    @Override
    public Object clone() {
        ArrayList<IntConstant> clonedLookupValues = new ArrayList<IntConstant>(this.lookupValues.size());
        for (IntConstant c : this.lookupValues) {
            clonedLookupValues.add(IntConstant.v(c.value));
        }
        return new JLookupSwitchStmt(this.getKey(), clonedLookupValues, this.getTargets(), this.getDefaultTarget());
    }

    public String toString() {
        int endOfLine = 32;
        StringBuilder buf = new StringBuilder("lookupswitch(");
        buf.append(this.keyBox.getValue().toString()).append(')').append(' ');
        buf.append('{').append(' ');
        ListIterator<IntConstant> it = this.lookupValues.listIterator();
        while (it.hasNext()) {
            IntConstant c = it.next();
            buf.append("    case ").append(c).append(": goto ");
            Unit target = this.getTarget(it.previousIndex());
            buf.append(target == this ? "self" : target).append(';').append(' ');
        }
        buf.append("    default: goto ");
        Unit target = this.getDefaultTarget();
        buf.append(target == this ? "self" : target).append(';').append(' ');
        buf.append('}');
        return buf.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("lookupswitch(");
        this.keyBox.toString(up);
        up.literal(")");
        up.newline();
        up.literal("{");
        up.newline();
        ListIterator<IntConstant> it = this.lookupValues.listIterator();
        while (it.hasNext()) {
            IntConstant c = it.next();
            up.literal("    case ");
            up.constant(c);
            up.literal(": goto ");
            this.targetBoxes[it.previousIndex()].toString(up);
            up.literal(";");
            up.newline();
        }
        up.literal("    default: goto ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    @Override
    public void setLookupValues(List<IntConstant> lookupValues) {
        this.lookupValues = new ArrayList<IntConstant>(lookupValues);
    }

    @Override
    public void setLookupValue(int index, int value) {
        this.lookupValues.set(index, IntConstant.v(value));
    }

    @Override
    public int getLookupValue(int index) {
        return this.lookupValues.get((int)index).value;
    }

    @Override
    public List<IntConstant> getLookupValues() {
        return Collections.unmodifiableList(this.lookupValues);
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseLookupSwitchStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ((ConvertToBaf)((Object)this.getKey())).convertToBaf(context, out);
        Baf baf = Baf.v();
        List<Unit> targets = this.getTargets();
        ArrayList<PlaceholderInst> targetPlaceholders = new ArrayList<PlaceholderInst>(targets.size());
        for (Unit target : targets) {
            targetPlaceholders.add(baf.newPlaceholderInst(target));
        }
        LookupSwitchInst u = baf.newLookupSwitchInst(baf.newPlaceholderInst(this.getDefaultTarget()), this.getLookupValues(), targetPlaceholders);
        u.addAllTagsOf(this);
        out.add(u);
    }
}

