/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import soot.Body;
import soot.RefType;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilBlockContainer;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;

public class CilTryFinallyInstruction
extends AbstractCilnstruction {
    public CilTryFinallyInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        CilBlockContainer tryContainer = new CilBlockContainer(this.instruction.getTryBlock(), this.dotnetBody, CilBlockContainer.BlockContainerKind.TRY);
        Body tryContainerBlock = tryContainer.jimplify();
        CilBlockContainer finallyBlockContainer = new CilBlockContainer(this.instruction.getFinallyBlock(), this.dotnetBody, CilBlockContainer.BlockContainerKind.FINALLY);
        Body finallyBlockContainerBody = finallyBlockContainer.jimplify();
        tryContainerBlock.getLocals().addAll(finallyBlockContainerBody.getLocals());
        HashMap<Trap, Unit> tmpTrapEnds = new HashMap<Trap, Unit>();
        for (Trap trap : tryContainerBlock.getTraps()) {
            tmpTrapEnds.put(trap, trap.getEndUnit());
        }
        ArrayList<Unit> tmpUnits = new ArrayList<Unit>();
        for (Unit unit : tryContainerBlock.getUnits()) {
            if (!CilBlockContainer.isExitStmt(unit)) continue;
            tmpUnits.add(unit);
        }
        for (Unit unit : tmpUnits) {
            finallyBlockContainerBody.setMethod(new SootMethod("", new ArrayList<Type>(), RefType.v("")));
            Body cloneFinallyBlock = (Body)finallyBlockContainerBody.clone(true);
            tryContainerBlock.getUnits().insertBefore(cloneFinallyBlock.getUnits(), unit);
            tryContainerBlock.getTraps().addAll(cloneFinallyBlock.getTraps());
        }
        for (Map.Entry entry : tmpTrapEnds.entrySet()) {
            ((Trap)entry.getKey()).setEndUnit((Unit)entry.getValue());
        }
        jb.getLocals().addAll(tryContainerBlock.getLocals());
        jb.getUnits().addAll(tryContainerBlock.getUnits());
        jb.getTraps().addAll(tryContainerBlock.getTraps());
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

