/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.List;
import soot.Body;
import soot.Local;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.AbstractNewObjInstanceInstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilCallVirtInstruction;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.instructions.CilIsInstInstruction;
import soot.dotnet.instructions.CilLdElemaInstruction;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Jimple;
import soot.toolkits.scalar.Pair;

public class CilStLocInstruction
extends AbstractCilnstruction {
    public CilStLocInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        List<Pair<Local, Local>> locals;
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getValueInstruction(), this.dotnetBody, this.cilBlock);
        Value value = cilExpr.jimplifyExpr(jb);
        if (cilExpr instanceof CilIsInstInstruction) {
            CilIsInstInstruction isInst = (CilIsInstInstruction)cilExpr;
            Local variable = this.dotnetBody.variableManager.addOrGetVariable(this.instruction.getVariable(), jb);
            isInst.resolveRewritingIsInst(jb, variable, value);
            return;
        }
        if (cilExpr instanceof CilLdElemaInstruction && ((CilLdElemaInstruction)cilExpr).isMultiArrayRef()) {
            CilLdElemaInstruction newArrInstruction = (CilLdElemaInstruction)cilExpr;
            value = newArrInstruction.resolveRewriteMultiArrAccess(jb);
        }
        Local variable = this.dotnetBody.variableManager.addOrGetVariable(this.instruction.getVariable(), value.getType(), jb);
        if (cilExpr instanceof CilCallVirtInstruction && (locals = ((CilCallVirtInstruction)cilExpr).getLocalsToCastForCall()).size() != 0) {
            for (Pair<Local, Local> pair : locals) {
                CastExpr castExpr = Jimple.v().newCastExpr(pair.getO1(), pair.getO2().getType());
                AssignStmt assignStmt = Jimple.v().newAssignStmt(pair.getO2(), castExpr);
                jb.getUnits().add(assignStmt);
            }
        }
        if (value instanceof Local && !variable.getType().toString().equals(value.getType().toString()) && this.dotnetBody.variableManager.localsToCastContains(((Local)value).getName())) {
            value = Jimple.v().newCastExpr(value, variable.getType());
        }
        if (value instanceof Local && value.getType().toString().equals("System.Object") && !variable.getType().toString().equals("System.Object")) {
            value = Jimple.v().newCastExpr(value, variable.getType());
        }
        AssignStmt astm = Jimple.v().newAssignStmt(variable, value);
        jb.getUnits().add(astm);
        if (cilExpr instanceof AbstractNewObjInstanceInstruction) {
            ((AbstractNewObjInstanceInstruction)cilExpr).resolveCallConstructorBody(jb, variable);
        }
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

