/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedTypeReference;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.MultiDexContainer;
import soot.ArrayType;
import soot.CompilationDeathException;
import soot.PrimType;
import soot.Scene;
import soot.SootClass;
import soot.SootResolver;
import soot.Type;
import soot.VoidType;
import soot.dexpler.DexClassLoader;
import soot.dexpler.DexFileProvider;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;

public class DexlibWrapper {
    private static final Set<String> systemAnnotationNames;
    private final DexClassLoader dexLoader = this.createDexClassLoader();
    private final Map<String, ClassInformation> classesToDefItems = new HashMap<String, ClassInformation>();
    private final Collection<MultiDexContainer.DexEntry<? extends DexFile>> dexFiles;

    public DexlibWrapper(File dexSource) {
        try {
            List<DexFileProvider.DexContainer<? extends DexFile>> containers = DexFileProvider.v().getDexFromSource(dexSource);
            this.dexFiles = new ArrayList<MultiDexContainer.DexEntry<? extends DexFile>>(containers.size());
            for (DexFileProvider.DexContainer<? extends DexFile> container2 : containers) {
                this.dexFiles.add(container2.getBase());
            }
        }
        catch (IOException e) {
            throw new CompilationDeathException("IOException during dex parsing", e);
        }
    }

    protected DexClassLoader createDexClassLoader() {
        return new DexClassLoader();
    }

    public void initialize() {
        DexFile dexFile;
        for (MultiDexContainer.DexEntry<? extends DexFile> dexEntry : this.dexFiles) {
            dexFile = dexEntry.getDexFile();
            for (ClassDef defItem : dexFile.getClasses()) {
                String forClassName = Util.dottedClassName(defItem.getType());
                this.classesToDefItems.put(forClassName, new ClassInformation(dexEntry, defItem));
            }
        }
        for (MultiDexContainer.DexEntry<? extends DexFile> dexEntry : this.dexFiles) {
            dexFile = dexEntry.getDexFile();
            if (!(dexFile instanceof DexBackedDexFile)) continue;
            for (DexBackedTypeReference typeRef : ((DexBackedDexFile)dexFile).getTypeReferences()) {
                String t = typeRef.getType();
                Type st = DexType.toSoot(t);
                if (st instanceof ArrayType) {
                    st = ((ArrayType)st).baseType;
                }
                String sootTypeName = st.toString();
                if (!Scene.v().containsClass(sootTypeName)) {
                    if (st instanceof PrimType || st instanceof VoidType || systemAnnotationNames.contains(sootTypeName)) continue;
                    SootResolver.v().makeClassRef(sootTypeName);
                }
                SootResolver.v().resolveClass(sootTypeName, 2);
            }
        }
    }

    public IInitialResolver.Dependencies makeSootClass(SootClass sc, String className) {
        ClassInformation defItem;
        if (Util.isByteCodeClassName(className)) {
            className = Util.dottedClassName(className);
        }
        if ((defItem = this.classesToDefItems.get(className)) != null) {
            return this.dexLoader.makeSootClass(sc, defItem.classDefinition, defItem.dexEntry);
        }
        throw new RuntimeException("Error: class not found in DEX files: " + className);
    }

    static {
        HashSet<String> systemAnnotationNamesModifiable = new HashSet<String>();
        systemAnnotationNamesModifiable.add("dalvik.annotation.AnnotationDefault");
        systemAnnotationNamesModifiable.add("dalvik.annotation.EnclosingClass");
        systemAnnotationNamesModifiable.add("dalvik.annotation.EnclosingMethod");
        systemAnnotationNamesModifiable.add("dalvik.annotation.InnerClass");
        systemAnnotationNamesModifiable.add("dalvik.annotation.MemberClasses");
        systemAnnotationNamesModifiable.add("dalvik.annotation.Signature");
        systemAnnotationNamesModifiable.add("dalvik.annotation.Throws");
        systemAnnotationNames = Collections.unmodifiableSet(systemAnnotationNamesModifiable);
    }

    private static class ClassInformation {
        public MultiDexContainer.DexEntry<? extends DexFile> dexEntry;
        public ClassDef classDefinition;

        public ClassInformation(MultiDexContainer.DexEntry<? extends DexFile> entry, ClassDef classDef) {
            this.dexEntry = entry;
            this.classDefinition = classDef;
        }
    }
}

