/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.Scene;
import soot.Trap;
import soot.Unit;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;

public class DexTrapStackFixer
extends BodyTransformer {
    public static DexTrapStackFixer v() {
        return new DexTrapStackFixer();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        for (Trap t : b.getTraps()) {
            if (this.isCaughtExceptionRef(t.getHandlerUnit())) continue;
            Local l = Scene.v().createLocalGenerator(b).generateLocal(t.getException().getType());
            IdentityStmt caughtStmt = Jimple.v().newIdentityStmt(l, Jimple.v().newCaughtExceptionRef());
            b.getUnits().add(caughtStmt);
            b.getUnits().add(Jimple.v().newGotoStmt(t.getHandlerUnit()));
            t.setHandlerUnit(caughtStmt);
        }
    }

    private boolean isCaughtExceptionRef(Unit handlerUnit) {
        if (!(handlerUnit instanceof IdentityStmt)) {
            return false;
        }
        IdentityStmt stmt = (IdentityStmt)handlerUnit;
        return stmt.getRightOp() instanceof CaughtExceptionRef;
    }
}

