/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Local;
import soot.RefType;
import soot.Singletons;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETSynchronizedBlockNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.toolkits.base.finders.ExceptionNode;
import soot.dava.toolkits.base.finders.FactFinder;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.JGotoStmt;
import soot.toolkits.graph.StronglyConnectedComponentsFast;
import soot.util.IterableSet;

public class SynchronizedBlockFinder
implements FactFinder {
    private HashMap<AugmentedStmt, Map<Value, Integer>> as2ml;
    private DavaBody davaBody;
    private IterableSet monitorLocalSet;
    private IterableSet monitorEnterSet;
    private final Integer WHITE = new Integer(0);
    private final Integer GRAY = new Integer(1);
    private final Integer BLACK = new Integer(2);
    private final int UNKNOWN = -100000;
    private final Integer VARIABLE_INCR = new Integer(-100000);
    private final String THROWABLE = "java.lang.Throwable";

    public SynchronizedBlockFinder(Singletons.Global g) {
    }

    public static SynchronizedBlockFinder v() {
        return G.v().soot_dava_toolkits_base_finders_SynchronizedBlockFinder();
    }

    @Override
    public void find(DavaBody body, AugmentedStmtGraph asg, SETNode SET) throws RetriggerAnalysisException {
        this.davaBody = body;
        Dava.v().log("SynchronizedBlockFinder::find()");
        this.as2ml = new HashMap();
        IterableSet<ExceptionNode> synchronizedBlockFacts = body.get_SynchronizedBlockFacts();
        synchronizedBlockFacts.clear();
        this.set_MonitorLevels(asg);
        Map<AugmentedStmt, IterableSet> as2synchSet = this.build_SynchSets();
        IterableSet<AugmentedStmt> usedMonitors = new IterableSet<AugmentedStmt>();
        AugmentedStmt previousStmt = null;
        for (AugmentedStmt as : asg) {
            IterableSet synchSet;
            if (as.get_Stmt() instanceof EnterMonitorStmt && (synchSet = as2synchSet.get(as)) != null) {
                DefinitionStmt previousDef;
                Value rightPrevious;
                Stmt previousS;
                IterableSet synchBody = this.get_BodyApproximation(as, synchSet);
                Value local = ((EnterMonitorStmt)as.get_Stmt()).getOp();
                Value copiedLocal = null;
                if (previousStmt != null && (previousS = previousStmt.get_Stmt()) instanceof DefinitionStmt && (rightPrevious = (previousDef = (DefinitionStmt)previousS).getRightOp()).toString().compareTo(local.toString()) == 0) {
                    copiedLocal = previousDef.getLeftOp();
                }
                Integer level = this.as2ml.get(as).get(local);
                Iterator enit = body.get_ExceptionFacts().iterator();
                boolean done = false;
                IterableSet origSynchBody = synchBody;
                while (enit.hasNext()) {
                    ExceptionNode en = (ExceptionNode)enit.next();
                    if (!this.verify_CatchBody(en, synchBody = (IterableSet)origSynchBody.clone(), local, copiedLocal)) continue;
                    if (!SET.nest(new SETSynchronizedBlockNode(en, local))) break;
                    done = true;
                    for (AugmentedStmt ssas : synchSet) {
                        Stmt sss = ssas.get_Stmt();
                        if (!(sss instanceof MonitorStmt)) continue;
                        if (((MonitorStmt)sss).getOp() == local && this.as2ml.get(ssas).get(local).equals(level) && !usedMonitors.contains(ssas)) {
                            usedMonitors.add(ssas);
                            continue;
                        }
                        if (((MonitorStmt)sss).getOp() != copiedLocal || usedMonitors.contains(ssas)) continue;
                        usedMonitors.add(ssas);
                    }
                    synchronizedBlockFacts.add(en);
                    break;
                }
                if (!done) {
                    throw new RuntimeException("Could not verify approximated Synchronized body!\nMethod:\n" + body.getMethod() + "Body:\n===============================================================\n" + body.getUnits() + "===============================================================\n");
                }
            }
            previousStmt = as;
        }
        IterableSet<AugmentedStmt> monitorFacts = body.get_MonitorFacts();
        monitorFacts.clear();
        for (AugmentedStmt as : asg) {
            if (!(as.get_Stmt() instanceof MonitorStmt) || usedMonitors.contains(as)) continue;
            monitorFacts.add(as);
        }
    }

    private void find_VariableIncreasing(AugmentedStmtGraph asg, HashMap local2level_template, LinkedList<AugmentedStmt> viAugStmts, HashMap<AugmentedStmt, LinkedList<Value>> as2locals) {
        HashMap local2level;
        StronglyConnectedComponentsFast<AugmentedStmt> scc = new StronglyConnectedComponentsFast<AugmentedStmt>(asg);
        IterableSet viSeeds = new IterableSet();
        HashMap as2color = new HashMap();
        HashMap<AugmentedStmt, Object> as2rml = new HashMap<AugmentedStmt, Object>();
        Iterator<AugmentedStmt> asgit = asg.iterator();
        while (asgit.hasNext()) {
            as2rml.put(asgit.next(), local2level_template.clone());
        }
        for (List<AugmentedStmt> componentList : scc.getTrueComponents()) {
            IterableSet component = new IterableSet();
            component.addAll(componentList);
            Iterator cit = component.iterator();
            while (cit.hasNext()) {
                as2color.put(cit.next(), this.WHITE);
            }
            AugmentedStmt seedStmt = (AugmentedStmt)component.getFirst();
            this.DFS_Scc(seedStmt, component, as2rml, as2color, seedStmt, viSeeds);
        }
        IterableSet worklist = new IterableSet();
        worklist.addAll(viSeeds);
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.getFirst();
            worklist.removeFirst();
            local2level = (HashMap)as2rml.get(as);
            for (AugmentedStmt sas : as.csuccs) {
                HashMap slocal2level = (HashMap)as2rml.get(sas);
                for (Value local : this.monitorLocalSet) {
                    if (local2level.get(local) != this.VARIABLE_INCR || slocal2level.get(local) == this.VARIABLE_INCR) continue;
                    slocal2level.put(local, this.VARIABLE_INCR);
                    if (worklist.contains(sas)) continue;
                    worklist.addLast(sas);
                }
            }
        }
        for (AugmentedStmt as : asg) {
            local2level = (HashMap)as2rml.get(as);
            for (Value local : this.monitorLocalSet) {
                if (local2level.get(local) != this.VARIABLE_INCR) continue;
                if (!viAugStmts.isEmpty()) {
                    if (viAugStmts.getLast() != as) {
                        viAugStmts.addLast(as);
                    }
                } else {
                    viAugStmts.addLast(as);
                }
                LinkedList<Value> locals = null;
                locals = as2locals.get(as);
                if (locals == null) {
                    locals = new LinkedList();
                    as2locals.put(as, locals);
                }
                locals.addLast(local);
            }
        }
    }

    private void DFS_Scc(AugmentedStmt as, IterableSet component, HashMap as2rml, HashMap as2color, AugmentedStmt seedStmt, IterableSet viSeeds) {
        as2color.put(as, this.GRAY);
        Stmt s = as.get_Stmt();
        HashMap local2level = (HashMap)as2rml.get(as);
        if (s instanceof MonitorStmt) {
            Value local = ((MonitorStmt)s).getOp();
            if (s instanceof EnterMonitorStmt) {
                local2level.put(local, new Integer((Integer)local2level.get(local) + 1));
            } else {
                local2level.put(local, new Integer((Integer)local2level.get(local) - 1));
            }
        }
        for (AugmentedStmt sas : as.csuccs) {
            if (!component.contains(sas)) continue;
            HashMap slocal2level = (HashMap)as2rml.get(sas);
            Integer scolor = (Integer)as2color.get(sas);
            if (scolor.equals(this.WHITE)) {
                for (Value local : this.monitorLocalSet) {
                    slocal2level.put(local, local2level.get(local));
                }
                this.DFS_Scc(sas, component, as2rml, as2color, seedStmt, viSeeds);
                continue;
            }
            for (Value local : this.monitorLocalSet) {
                if ((Integer)slocal2level.get(local) >= (Integer)local2level.get(local)) continue;
                slocal2level.put(local, this.VARIABLE_INCR);
                if (viSeeds.contains(sas)) continue;
                viSeeds.add(sas);
            }
        }
        as2color.put(as, this.BLACK);
    }

    private Map<AugmentedStmt, IterableSet> build_SynchSets() {
        HashMap<AugmentedStmt, IterableSet> as2synchSet = new HashMap<AugmentedStmt, IterableSet>();
        block0: for (AugmentedStmt headAs : this.monitorEnterSet) {
            Value local = ((EnterMonitorStmt)headAs.get_Stmt()).getOp();
            IterableSet<AugmentedStmt> synchSet = new IterableSet<AugmentedStmt>();
            int monitorLevel = this.as2ml.get(headAs).get(local);
            IterableSet<AugmentedStmt> worklist = new IterableSet<AugmentedStmt>();
            worklist.add(headAs);
            while (!worklist.isEmpty()) {
                AugmentedStmt as = (AugmentedStmt)worklist.getFirst();
                worklist.removeFirst();
                Stmt s = as.get_Stmt();
                if (s instanceof DefinitionStmt && ((DefinitionStmt)s).getLeftOp() == local) continue block0;
                synchSet.add(as);
                for (AugmentedStmt sas : as.csuccs) {
                    int sml = this.as2ml.get(sas).get(local);
                    if (!sas.get_Dominators().contains(headAs) || sml < monitorLevel || worklist.contains(sas) || synchSet.contains(sas)) continue;
                    worklist.addLast(sas);
                }
            }
            as2synchSet.put(headAs, synchSet);
        }
        return as2synchSet;
    }

    private void set_MonitorLevels(AugmentedStmtGraph asg) {
        this.monitorLocalSet = new IterableSet();
        this.monitorEnterSet = new IterableSet();
        for (AugmentedStmt as : asg) {
            Stmt s = as.get_Stmt();
            if (!(s instanceof MonitorStmt)) continue;
            Value local = ((MonitorStmt)s).getOp();
            if (!this.monitorLocalSet.contains(local)) {
                this.monitorLocalSet.add(local);
            }
            if (!(s instanceof EnterMonitorStmt)) continue;
            this.monitorEnterSet.add(as);
        }
        HashMap local2level_template = new HashMap();
        Iterator mlsit = this.monitorLocalSet.iterator();
        while (mlsit.hasNext()) {
            local2level_template.put(mlsit.next(), new Integer(0));
        }
        Iterator<AugmentedStmt> asgit = asg.iterator();
        while (asgit.hasNext()) {
            this.as2ml.put(asgit.next(), (Map)local2level_template.clone());
        }
        LinkedList<AugmentedStmt> viAugStmts = new LinkedList<AugmentedStmt>();
        HashMap<AugmentedStmt, LinkedList<Value>> incrAs2locals = new HashMap<AugmentedStmt, LinkedList<Value>>();
        this.find_VariableIncreasing(asg, local2level_template, viAugStmts, incrAs2locals);
        for (AugmentedStmt vias : viAugStmts) {
            Map<Value, Integer> local2level = this.as2ml.get(vias);
            Iterator lit = incrAs2locals.get(vias).iterator();
            while (lit.hasNext()) {
                local2level.put((Value)lit.next(), this.VARIABLE_INCR);
            }
        }
        IterableSet<AugmentedStmt> worklist = new IterableSet<AugmentedStmt>();
        worklist.addAll(this.monitorEnterSet);
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.getFirst();
            worklist.removeFirst();
            Map<Value, Integer> cur_local2level = this.as2ml.get(as);
            for (AugmentedStmt pas : as.cpreds) {
                Stmt s = as.get_Stmt();
                Map<Value, Integer> pred_local2level = this.as2ml.get(pas);
                for (Value local : this.monitorLocalSet) {
                    int curLevel;
                    MonitorStmt ems;
                    int predLevel = pred_local2level.get(local);
                    Stmt ps = pas.get_Stmt();
                    if (predLevel == -100000) continue;
                    if (ps instanceof ExitMonitorStmt && (ems = (ExitMonitorStmt)ps).getOp() == local && predLevel > 0) {
                        --predLevel;
                    }
                    if (s instanceof EnterMonitorStmt && (ems = (EnterMonitorStmt)s).getOp() == local && predLevel >= 0) {
                        ++predLevel;
                    }
                    if (predLevel <= (curLevel = cur_local2level.get(local).intValue())) continue;
                    cur_local2level.put(local, new Integer(predLevel));
                    for (AugmentedStmt so : as.csuccs) {
                        if (worklist.contains(so)) continue;
                        worklist.add(so);
                    }
                }
            }
        }
    }

    private void removeOtherDominatedStmts(IterableSet synchBody, AugmentedStmt sas) {
        ArrayList<AugmentedStmt> toRemove = new ArrayList<AugmentedStmt>();
        for (AugmentedStmt as : synchBody) {
            IterableSet<AugmentedStmt> doms = as.get_Dominators();
            if (!doms.contains(sas)) continue;
            toRemove.add(as);
        }
        for (AugmentedStmt as : toRemove) {
            synchBody.remove(as);
        }
    }

    private boolean verify_CatchBody(ExceptionNode en, IterableSet synchBody, Value monitorVariable, Value copiedLocal) {
        IterableSet<AugmentedStmt> tryBodySet = en.get_TryBody();
        Iterator tempIt = tryBodySet.iterator();
        AugmentedStmt tempas = null;
        block0: while (tempIt.hasNext()) {
            tempas = (AugmentedStmt)tempIt.next();
            for (AugmentedStmt succAS : tempas.bsuccs) {
                if (tryBodySet.contains(succAS)) continue;
                break block0;
            }
        }
        if (tempas != null) {
            for (AugmentedStmt sas : tempas.bsuccs) {
                synchBody.remove(sas);
                this.removeOtherDominatedStmts(synchBody, sas);
            }
        }
        for (AugmentedStmt as : en.get_TryBody()) {
            if (!(as.get_Stmt() instanceof ExitMonitorStmt)) continue;
            List<AugmentedStmt> csuccs = as.csuccs;
            csuccs.remove(as.bsuccs);
            for (AugmentedStmt as1 : csuccs) {
                if (!(as1.get_Stmt() instanceof GotoStmt)) continue;
                Unit target = ((JGotoStmt)as1.get_Stmt()).getTarget();
                if (target instanceof DefinitionStmt) {
                    DefinitionStmt defStmt = (DefinitionStmt)target;
                    Value asnFrom = defStmt.getRightOp();
                    if (!(asnFrom instanceof CaughtExceptionRef)) {
                        synchBody.remove(as1);
                        this.removeOtherDominatedStmts(synchBody, as1);
                        continue;
                    }
                    Value leftOp = defStmt.getLeftOp();
                    HashSet<CaughtExceptionRef> params = new HashSet<CaughtExceptionRef>();
                    params.addAll(this.davaBody.get_CaughtRefs());
                    Iterator<Local> localIt = this.davaBody.getLocals().iterator();
                    String typeName = "";
                    while (localIt.hasNext()) {
                        Local local = localIt.next();
                        if (local.toString().compareTo(leftOp.toString()) != 0) continue;
                        Type t = local.getType();
                        typeName = t.toString();
                        break;
                    }
                    if (typeName.compareTo("java.lang.Throwable") == 0) continue;
                    synchBody.remove(as1);
                    this.removeOtherDominatedStmts(synchBody, as1);
                    continue;
                }
                synchBody.remove(as1);
                synchBody.remove(as1.bsuccs.get(0));
                this.removeOtherDominatedStmts(synchBody, as1);
            }
        }
        AugmentedStmt synchEnter = null;
        block6: for (AugmentedStmt as : synchBody) {
            for (AugmentedStmt pas : as.cpreds) {
                Stmt pasStmt;
                if (synchBody.contains(pas) || !((pasStmt = pas.get_Stmt()) instanceof EnterMonitorStmt)) continue;
                synchEnter = as;
                break block6;
            }
        }
        if (synchEnter == null) {
            throw new RuntimeException("Could not find enter stmt of the synchBody: " + this.davaBody.getMethod().getSignature());
        }
        boolean unChanged = false;
        while (!unChanged) {
            unChanged = true;
            ArrayList<AugmentedStmt> toRemove = new ArrayList<AugmentedStmt>();
            for (AugmentedStmt synchAs : synchBody) {
                if (synchAs == synchEnter) continue;
                Iterator<AugmentedStmt> pit = synchAs.cpreds.iterator();
                boolean remove = true;
                while (pit.hasNext()) {
                    AugmentedStmt pAs = pit.next();
                    if (!synchBody.contains(pAs)) continue;
                    remove = false;
                }
                if (!remove) continue;
                toRemove.add(synchAs);
            }
            if (toRemove.size() <= 0) continue;
            synchBody.removeAll(toRemove);
            unChanged = false;
        }
        if (!en.get_Body().equals(synchBody) || !en.get_Exception().getName().equals("java.lang.Throwable") || en.get_CatchList().size() > 1) {
            return false;
        }
        IterableSet<AugmentedStmt> catchBody = en.get_CatchBody();
        AugmentedStmt entryPoint = null;
        block11: for (AugmentedStmt as : catchBody) {
            for (AugmentedStmt pas : as.cpreds) {
                if (catchBody.contains(pas)) continue;
                entryPoint = as;
                break block11;
            }
        }
        Unit entryPointTarget = null;
        if (entryPoint.get_Stmt() instanceof GotoStmt) {
            entryPointTarget = ((JGotoStmt)entryPoint.get_Stmt()).getTarget();
        }
        AugmentedStmt as = entryPoint;
        if (as.bsuccs.size() != 1) {
            return false;
        }
        while (as.get_Stmt() instanceof GotoStmt) {
            as = as.bsuccs.get(0);
            if (as.bsuccs.size() != 1) {
                return false;
            }
            if (!(entryPointTarget != null ? as.get_Stmt() != entryPointTarget && as.cpreds.size() != 1 && as.cpreds.size() != 1 : as != entryPoint && as.cpreds.size() != 1)) continue;
            return false;
        }
        Stmt s = as.get_Stmt();
        if (!(s instanceof DefinitionStmt)) {
            return false;
        }
        DefinitionStmt ds = (DefinitionStmt)s;
        Value asnFrom = ds.getRightOp();
        if (!(asnFrom instanceof CaughtExceptionRef) || !((RefType)((CaughtExceptionRef)asnFrom).getType()).getSootClass().getName().equals("java.lang.Throwable")) {
            return false;
        }
        Value throwlocal = ds.getLeftOp();
        IterableSet esuccs = new IterableSet();
        esuccs.addAll(as.csuccs);
        esuccs.removeAll(as.bsuccs);
        as = as.bsuccs.get(0);
        s = as.get_Stmt();
        while (s instanceof DefinitionStmt && ((DefinitionStmt)s).getRightOp().toString().compareTo(throwlocal.toString()) == 0) {
            throwlocal = ((DefinitionStmt)s).getLeftOp();
            as = as.bsuccs.get(0);
            s = as.get_Stmt();
        }
        if (as.bsuccs.size() != 1 || as.cpreds.size() != 1) {
            return false;
        }
        this.checkProtectionArea(as, ds);
        s = as.get_Stmt();
        if (!(s instanceof ExitMonitorStmt)) {
            return false;
        }
        if (((ExitMonitorStmt)s).getOp() != monitorVariable && ((ExitMonitorStmt)s).getOp() != copiedLocal) {
            return false;
        }
        as = as.bsuccs.get(0);
        if (as.bsuccs.size() != 0 || as.cpreds.size() != 1 || !this.verify_ESuccs(as, esuccs)) {
            return false;
        }
        s = as.get_Stmt();
        return s instanceof ThrowStmt && ((ThrowStmt)s).getOp() == throwlocal;
    }

    private boolean checkProtectionArea(AugmentedStmt as, DefinitionStmt s) {
        IterableSet esuccs = new IterableSet();
        esuccs.addAll(as.csuccs);
        esuccs.removeAll(as.bsuccs);
        for (AugmentedStmt tempas : esuccs) {
            Unit target;
            Stmt temps = tempas.get_Stmt();
            if (!(temps instanceof GotoStmt ? (target = ((GotoStmt)temps).getTarget()) != s : temps != s)) continue;
            return false;
        }
        return true;
    }

    private boolean verify_ESuccs(AugmentedStmt as, IterableSet ref) {
        IterableSet esuccs = new IterableSet();
        esuccs.addAll(as.csuccs);
        esuccs.removeAll(as.bsuccs);
        return esuccs.equals(ref);
    }

    private IterableSet get_BodyApproximation(AugmentedStmt head, IterableSet synchSet) {
        IterableSet body = (IterableSet)synchSet.clone();
        Value local = ((EnterMonitorStmt)head.get_Stmt()).getOp();
        Integer level = this.as2ml.get(head).get(local);
        body.remove(head);
        Iterator bit = body.snapshotIterator();
        while (bit.hasNext()) {
            AugmentedStmt as = (AugmentedStmt)bit.next();
            Stmt s = as.get_Stmt();
            if (!(s instanceof ExitMonitorStmt) || ((ExitMonitorStmt)s).getOp() != local || !this.as2ml.get(as).get(local).equals(level)) continue;
            for (AugmentedStmt sas : as.csuccs) {
                Stmt ss;
                if (!sas.get_Dominators().contains(head) || !((ss = sas.get_Stmt()) instanceof GotoStmt) && !(ss instanceof ThrowStmt) || body.contains(sas)) continue;
                body.add(sas);
            }
        }
        return body;
    }
}

